/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.provider;

import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.ContainerTreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.IdNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.TreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.ConflictViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.TreeProvider;
import graphmodel.GraphModel;
import info.scce.mcam.framework.modules.ChangeModule;
import info.scce.mcam.framework.processes.MergeInformation;
import info.scce.mcam.framework.processes.MergeProcess;
import java.util.Set;

public class ConflictViewTreeProvider<E extends _CincoId, M extends GraphModel, A extends _CincoAdapter<E, M>>
extends TreeProvider {
    private ConflictViewPage<E, M, A> page;
    private ContainerTreeNode byIdRoot;
    private ViewType activeView = ViewType.BY_ID;
    private MergeProcess<E, A> mp;

    public ConflictViewTreeProvider(ConflictViewPage<E, M, A> page) {
        this.page = page;
    }

    @Override
    public TreeNode getTreeRoot() {
        switch (this.activeView) {
            default: 
        }
        return this.byIdRoot;
    }

    public ViewType getActiveView() {
        return this.activeView;
    }

    public void setActiveView(ViewType activeView) {
        this.activeView = activeView;
    }

    public MergeProcess<E, A> getMergeProcess() {
        return this.mp;
    }

    @Override
    public void loadData(Object rootObject) {
        long timeStart = System.currentTimeMillis();
        this.mp = this.page.getMp();
        long timeLoad = System.currentTimeMillis();
        this.buildTree();
        long timeBuild = System.currentTimeMillis();
        System.out.println(String.valueOf(this.page.getClass().getSimpleName()) + " - load: " + (timeLoad - timeStart) + " ms / build: " + (timeBuild - timeLoad) + " ms");
    }

    protected void buildTree() {
        this.byIdRoot = new ContainerTreeNode(null, "byIdRoot");
        for (MergeInformation mergeInfo : this.mp.getMergeInformationMap().values()) {
            if (mergeInfo.getLocalChanges().size() <= 0 && mergeInfo.getRemoteChanges().size() <= 0) continue;
            this.buildTreeById(mergeInfo.getId(), this.byIdRoot);
        }
    }

    private TreeNode buildTreeById(Object obj, TreeNode parentNode) {
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof _CincoId) {
            _CincoId id = (_CincoId)obj;
            node = new IdNode(obj);
            node.setLabel(id.toString());
            MergeInformation mergeInfo = (MergeInformation)this.mp.getMergeInformationMap().get(id);
            for (Set conflictSet : mergeInfo.getListOfConflictedChangeSets()) {
                this.buildTreeById(conflictSet, node);
            }
            for (ChangeModule change : mergeInfo.getLocalChanges()) {
                if (mergeInfo.isConflictedChange(change)) continue;
                this.buildTreeById(change, node);
            }
            for (ChangeModule change : mergeInfo.getRemoteChanges()) {
                if (mergeInfo.isConflictedChange(change)) continue;
                this.buildTreeById(change, node);
            }
        }
        if (obj instanceof ChangeModule) {
            ChangeModule change = (ChangeModule)obj;
            node = new ContainerTreeNode(obj, obj.toString());
            node.setLabel(change.toString());
        }
        if (obj instanceof Set) {
            node = new ContainerTreeNode(obj, obj.toString());
            node.setLabel("Conflict Set");
            Set conflictSet = (Set)obj;
            for (ChangeModule change : conflictSet) {
                this.buildTreeById(change, node);
            }
        }
        parentNode.getChildren().add(node);
        node.setParent(parentNode);
        return node;
    }

    public static enum ViewType {
        BY_ID;

    }
}

