/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.provider;

import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.core.utils.job.ReiteratingThread;
import de.jabc.cinco.meta.core.utils.registry.NonEmptyRegistry;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.CheckModuleNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.CheckProcessNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.CheckResultNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.ContainerTreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.DefaultOkObject;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.IdNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.TreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.CheckViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.TreeProvider;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import info.scce.mcam.framework.adapter.EntityId;
import info.scce.mcam.framework.modules.CheckModule;
import info.scce.mcam.framework.processes.CheckInformation;
import info.scce.mcam.framework.processes.CheckProcess;
import info.scce.mcam.framework.processes.CheckResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;

public class CheckViewTreeProvider<E extends _CincoId, M extends GraphModel, A extends _CincoAdapter<E, M>>
extends TreeProvider {
    private CheckViewPage<E, M, A> page;
    private WorkbenchExtension workbench = new WorkbenchExtension();
    private ContainerTreeNode byModuleRoot = null;
    private ContainerTreeNode byIdRoot = null;
    private NonEmptyRegistry<CheckProcess<?, ?>, List<TreeNode>> byModuleNodes = new NonEmptyRegistry(cp -> new ArrayList());
    private NonEmptyRegistry<CheckProcess<?, ?>, List<TreeNode>> byIdNodes = new NonEmptyRegistry(cp -> new ArrayList());
    private ViewType activeView = ViewType.BY_ID;
    private boolean treeResortRequested = false;
    private ReiteratingThread treeRefresher = new TreeRefresher();
    private LinkedTransferQueue<CheckProcess<?, ?>> treeNodeRefreshRequests = new LinkedTransferQueue();
    private List<CheckProcess<?, ?>> checkProcesses = new ArrayList();
    private CompoundJob checkJob = null;
    private boolean foundFirstError = false;

    public CheckViewTreeProvider(CheckViewPage<E, M, A> page, ViewType vType) {
        this.page = page;
        this.activeView = vType;
    }

    @Override
    protected TreeNode getTreeRoot() {
        switch (this.activeView) {
            case BY_MODULE: {
                return this.byModuleRoot;
            }
        }
        return this.byIdRoot;
    }

    public ViewType getActiveView() {
        return this.activeView;
    }

    public void setActiveView(ViewType activeView) {
        this.activeView = activeView;
    }

    @Override
    protected void loadData(Object rootObject) {
        if (this.checkJob != null && this.checkJob.getResult() == null) {
            this.checkJob.cancel();
        }
        this.checkProcesses = this.page.getCheckProcesses();
        if (this.checkProcesses.size() <= 0) {
            return;
        }
        this.initTree();
        this.checkJob = JobFactory.job((String)"Validation");
        this.checkJob.consume(1).task(this::preChecking).consumeConcurrent(99).taskForEach(this.checkProcesses, this::runCheckProcess).onDone(this::postChecking).schedule();
    }

    protected void initTree() {
        this.byModuleNodes.clear();
        this.byModuleRoot = new ContainerTreeNode(null, "root");
        this.byIdNodes.clear();
        this.byIdRoot = new ContainerTreeNode(null, "root");
        this.refreshTree();
    }

    protected void buildTree() {
        this.byModuleRoot = new ContainerTreeNode(null, "root");
        this.byIdRoot = new ContainerTreeNode(null, "root");
        if (this.checkProcesses.size() == 1) {
            TreeNode node;
            CheckProcess<?, ?> checkProcess = this.checkProcesses.get(0);
            for (CheckModule module : checkProcess.getModules()) {
                node = this.buildTreeByModule(module, this.byModuleRoot, checkProcess);
                ((List)this.byModuleNodes.get(checkProcess)).add(node);
            }
            this.addDefaultOkNode(this.byModuleRoot);
            for (EntityId id : checkProcess.getCheckInformationMap().keySet()) {
                node = this.buildTreeById(id, this.byIdRoot, checkProcess);
                ((List)this.byIdNodes.get(checkProcess)).add(node);
            }
            this.addDefaultOkNode(this.byIdRoot);
        } else {
            for (CheckProcess<?, ?> checkProcess : this.checkProcesses) {
                TreeNode node = this.buildTreeByModule(checkProcess, this.byModuleRoot, checkProcess);
                ((List)this.byModuleNodes.get(checkProcess)).add(node);
                node = this.buildTreeById(checkProcess, this.byIdRoot, checkProcess);
                ((List)this.byIdNodes.get(checkProcess)).add(node);
            }
        }
        this.refreshTree();
    }

    protected void addDefaultOkNode(TreeNode parentNode) {
        ContainerTreeNode node = new ContainerTreeNode(new DefaultOkObject(), "defaultOK");
        this.findExistingNode(node, parentNode);
    }

    private TreeNode buildTreeById(Object obj, TreeNode parentNode, CheckProcess<?, ?> checkProcess) {
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof CheckProcess) {
            node = new CheckProcessNode(obj);
            CheckProcess cp = (CheckProcess)obj;
            node.setLabel(cp.getModel().getModelName());
            node = this.findExistingNode(node, parentNode);
            for (EntityId id : checkProcess.getCheckInformationMap().keySet()) {
                this.buildTreeById(id, node, cp);
            }
        }
        if (obj instanceof _CincoId) {
            node = new IdNode(obj);
            node.setLabel(((_CincoId)obj).toString());
            node = this.findExistingNode(node, parentNode);
            for (CheckResult result : ((CheckInformation)checkProcess.getCheckInformationMap().get(obj)).getResults()) {
                this.buildTreeById(result, node, checkProcess);
            }
        }
        if (obj instanceof CheckResult) {
            CheckResult result;
            result = (CheckResult)obj;
            node = new CheckResultNode(result);
            node.setLabel("[" + result.getModule().getName() + "] " + result.getMessage());
            node = this.findExistingNode(node, parentNode);
        }
        return node;
    }

    private TreeNode buildTreeByModule(Object obj, TreeNode parentNode, CheckProcess<?, ?> checkProcess) {
        TreeNode node = new ContainerTreeNode(null, "dummy");
        if (obj instanceof CheckProcess) {
            node = new CheckProcessNode(obj);
            CheckProcess cp = (CheckProcess)obj;
            node.setLabel(cp.getModel().getModelName());
            node = this.findExistingNode(node, parentNode);
            for (CheckModule module : checkProcess.getModules()) {
                this.buildTreeByModule(module, node, cp);
            }
        }
        if (obj instanceof CheckModule) {
            CheckModule module = (CheckModule)obj;
            node = new CheckModuleNode(obj);
            node.setLabel(module.getName());
            node = this.findExistingNode(node, parentNode);
            for (CheckResult result : module.getResults()) {
                this.buildTreeByModule(result, node, checkProcess);
            }
        }
        if (obj instanceof CheckResult) {
            CheckResult result = (CheckResult)obj;
            node = new CheckResultNode(result);
            String id = result.getId() != null ? ((_CincoId)result.getId()).toString() : "null";
            node.setLabel(String.valueOf(id) + ": " + result.getMessage());
            node = this.findExistingNode(node, parentNode);
        }
        return node;
    }

    void refreshTreeNode(CheckProcess<?, ?> checkProcess) {
        List cpByModuleNodes = (List)this.byModuleNodes.get(checkProcess);
        if (!cpByModuleNodes.isEmpty()) {
            this.workbench.async(() -> {
                for (TreeNode byModuleNode : cpByModuleNodes) {
                    if (byModuleNode.getChildren().isEmpty()) {
                        for (CheckModule module : checkProcess.getModules()) {
                            this.buildTreeByModule(module, byModuleNode, checkProcess);
                        }
                    }
                    this.page.getTreeViewer().refresh((Object)byModuleNode);
                }
            });
        } else {
            this.buildTree();
        }
        List cpByIdNodes = (List)this.byIdNodes.get(checkProcess);
        if (!cpByIdNodes.isEmpty()) {
            this.workbench.async(() -> {
                for (TreeNode byIdNode : cpByIdNodes) {
                    if (byIdNode.getChildren().isEmpty()) {
                        for (EntityId id : checkProcess.getCheckInformationMap().keySet()) {
                            this.buildTreeById(id, byIdNode, checkProcess);
                        }
                    }
                    this.page.getTreeViewer().refresh((Object)byIdNode);
                }
            });
        } else {
            this.buildTree();
        }
    }

    void refreshTree() {
        this.workbench.async(() -> this.page.getTreeViewer().refresh(true));
    }

    void resortTree() {
        this.workbench.async(() -> this.page.getTreeViewer().refresh(false));
    }

    void requestTreeResort() {
        this.treeResortRequested = true;
        this.assertTreeRefresherIsAlive();
    }

    void requestTreeNodeRefresh(CheckProcess<?, ?> checkProcess) {
        this.treeNodeRefreshRequests.add(checkProcess);
        this.assertTreeRefresherIsAlive();
    }

    void assertTreeRefresherIsAlive() {
        if (!this.treeRefresher.isStarted()) {
            this.treeRefresher.start();
        } else {
            this.treeRefresher.unpause();
        }
    }

    boolean hasError(CheckProcess<?, ?> checkProcess) {
        for (CheckModule module : checkProcess.getModules()) {
            if (!module.hasResultOfType(CheckResult.CheckResultType.ERROR)) continue;
            return true;
        }
        return false;
    }

    void preChecking() {
        this.foundFirstError = false;
        this.treeResortRequested = false;
    }

    void runCheckProcess(CheckProcess<?, ?> checkProcess) {
        if (this.foundFirstError && this.page.getCheckConfiguration().isStopAtFirstError()) {
            return;
        }
        checkProcess.checkModel();
        this.requestTreeNodeRefresh(checkProcess);
        if (this.hasError(checkProcess)) {
            this.foundFirstError = true;
            this.requestTreeResort();
        }
    }

    void postChecking() {
        this.requestTreeResort();
    }

    class TreeRefresher
    extends ReiteratingThread {
        public TreeRefresher() {
            super(500);
        }

        /*
         * Unable to fully structure code
         */
        protected void work() {
            checkProcess = CheckViewTreeProvider.this.treeNodeRefreshRequests.poll();
            if (checkProcess != null || CheckViewTreeProvider.this.treeResortRequested) ** GOTO lbl7
            this.pause();
            return;
lbl-1000:
            // 1 sources

            {
                CheckViewTreeProvider.this.refreshTreeNode(checkProcess);
                checkProcess = CheckViewTreeProvider.this.treeNodeRefreshRequests.poll();
lbl7:
                // 2 sources

                ** while (checkProcess != null)
            }
lbl8:
            // 1 sources

            if (CheckViewTreeProvider.this.treeResortRequested) {
                CheckViewTreeProvider.this.treeResortRequested = false;
                CheckViewTreeProvider.this.resortTree();
            }
        }
    }

    public static enum ViewType {
        BY_MODULE,
        BY_ID;

    }
}

