/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.pages;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.plugin.mcam.runtime.core.FrameworkExecution;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.PageFactory;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.CheckViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.GraphModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ProjectCheckViewPage
extends CheckViewPage<_CincoId, GraphModel, _CincoAdapter<_CincoId, GraphModel>> {
    private ResourceExtension resourceHelper = new ResourceExtension();
    private String[] tmpNames = new String[]{"temp", "tmp"};
    private IProject iProject = null;
    private List<PageFactory> pageFactories = null;

    public ProjectCheckViewPage(String pageId, List<PageFactory> pageFactories) {
        super(pageId);
        this.pageFactories = pageFactories;
    }

    public List<String> getFileExtensions() {
        ArrayList<String> list = new ArrayList<String>();
        for (PageFactory pageFactory : this.pageFactories) {
            list.addAll(pageFactory.getFileExtensions());
        }
        return list;
    }

    public FrameworkExecution getFrameWorkExecution(IFile iFile) {
        for (PageFactory pageFactory : this.pageFactories) {
            FrameworkExecution fe = pageFactory.getFrameWorkExecution(iFile);
            if (fe == null) continue;
            return fe;
        }
        return null;
    }

    @Override
    public _CincoAdapter getAdapter(IFile iFile, Resource resource) {
        return this.getFrameWorkExecution(iFile).initApiAdapterFromResource(resource, EclipseUtils.getFile(iFile));
    }

    @Override
    public void addCheckProcess(IFile iFile, Resource resource) {
        this.getCheckProcesses().add(this.getFrameWorkExecution(iFile).createCheckPhase(this.getAdapter(iFile, resource)));
    }

    public void addCheckProcesses(IResource iResource) {
        if (iResource instanceof Project) {
            this.iProject = (Project)iResource;
        }
        if (this.ignoreResource(iResource)) {
            return;
        }
        ArrayList<String> fileExtensions = new ArrayList<String>(this.getFileExtensions());
        if (iResource instanceof org.eclipse.core.internal.resources.File && fileExtensions.contains(iResource.getFileExtension())) {
            EObject model = this.loadModel(iResource);
            this.addCheckProcess((IFile)iResource, model.eResource());
        }
        if (iResource instanceof Container) {
            try {
                IResource[] iResourceArray = ((Container)iResource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource subRes = iResourceArray[n2];
                    this.addCheckProcesses(subRes);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean ignoreResource(IResource iResource) {
        for (String string : Arrays.asList(this.tmpNames)) {
            if (!iResource.getName().toLowerCase().contains(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public EObject loadModel(IResource res) {
        File file = new File(res.getLocation().toOSString());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        GraphModel model = ReferenceRegistry.getInstance().getGraphModelFromURI(uri);
        if (model != null) {
            return model;
        }
        Resource resource = resSet.getResource(uri, true);
        model = this.resourceHelper.getGraphModel(resource);
        if (model != null) {
            ReferenceRegistry.getInstance().addElement((EObject)model);
            return model;
        }
        System.out.println("Model " + file.getName() + " not found");
        return null;
    }

    @Override
    public void reload() {
        this.getCheckProcesses().clear();
        this.addCheckProcesses((IResource)this.iProject);
        super.reload();
    }
}

