/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.pages;

import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.TreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.TreeProvider;
import graphmodel.GraphModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class McamPage {
    protected Composite parent;
    protected ViewPart parentViewPart;
    protected TreeViewer treeViewer;
    protected Composite frameComposite;
    protected String pageId;
    protected Bundle bundle = FrameworkUtil.getBundle(this.getClass());
    protected Image iconClearSearch = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
    protected McamFullTextFilter defaultFilterFullText = new McamFullTextFilter();
    protected McamContentProvider defaultContentProvider = new McamContentProvider();

    public McamPage(String id) {
        this.pageId = id;
    }

    public Composite getFrameComposite() {
        return this.frameComposite;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public String getPageId() {
        return this.pageId;
    }

    public McamFullTextFilter getDefaultFilterFullText() {
        return this.defaultFilterFullText;
    }

    public void setDefaultFilterFullText(McamFullTextFilter defaultFilterFullText) {
        this.defaultFilterFullText = defaultFilterFullText;
    }

    public McamContentProvider getDefaultContentProvider() {
        return this.defaultContentProvider;
    }

    public void setDefaultContentProvider(McamContentProvider defaultContentProvider) {
        this.defaultContentProvider = defaultContentProvider;
    }

    protected void loadIcons() throws IOException {
    }

    public void initPage(Composite parent, ViewPart parentViewPart) throws IOException {
        this.parent = parent;
        this.parentViewPart = parentViewPart;
        this.loadIcons();
        this.frameComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        this.frameComposite.setLayout((Layout)gridLayout);
        this.frameComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text searchField = new Text(this.frameComposite, 2052);
        GridData gridData = new GridData(4, 0, true, false);
        searchField.setLayoutData((Object)gridData);
        searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                McamPage.this.treeViewer.removeFilter((ViewerFilter)McamPage.this.defaultFilterFullText);
                McamPage.this.defaultFilterFullText.searchString = text.getText();
                McamPage.this.treeViewer.addFilter((ViewerFilter)McamPage.this.defaultFilterFullText);
                if (text.getText().length() > 0) {
                    McamPage.this.treeViewer.expandAll();
                }
            }
        });
        Button buttonClearSearch = new Button(this.frameComposite, 0);
        buttonClearSearch.setImage(this.iconClearSearch);
        buttonClearSearch.setToolTipText("clear search field");
        buttonClearSearch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                searchField.setText("");
            }
        });
        this.treeViewer = new TreeViewer(this.frameComposite, 768);
        GridData gridDataViewer = new GridData(4, 4, true, true);
        gridDataViewer.horizontalSpan = 4;
        this.treeViewer.getTree().setLayoutData((Object)gridDataViewer);
        this.treeViewer.setContentProvider((IContentProvider)this.defaultContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getDefaultLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)this.getDefaultSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    McamPage.this.highlight(selection.getFirstElement());
                }
            }
        });
        this.treeViewer.setInput((Object)parentViewPart.getViewSite());
        this.frameComposite.pack();
    }

    public void reload() {
        this.getDataProvider().flagDirty();
        Job job = new Job("reloading " + this.getClass().getSimpleName() + " ..."){

            protected IStatus run(IProgressMonitor monitor) {
                McamPage.this.getDataProvider().load(null);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).McamPage.this.treeViewer.refresh(true);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected Object getTreeNodeData(Object obj) {
        if (obj instanceof TreeNode) {
            return ((TreeNode)obj).getData();
        }
        return obj;
    }

    private List<TreeItem> getAllTreeItems(TreeItem item) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            list.add(treeItem);
            list.addAll(this.getAllTreeItems(treeItem));
            ++n2;
        }
        return list;
    }

    public void closeView() {
        this.frameComposite.dispose();
    }

    public void toggleExpand(Object obj) {
        if (obj instanceof TreeNode) {
            ArrayList<TreeItem> list = new ArrayList<TreeItem>();
            TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                list.add(item);
                list.addAll(this.getAllTreeItems(item));
                ++n2;
            }
            for (TreeItem treeItem : list) {
                if (treeItem.getData() != obj) continue;
                if (treeItem.getExpanded()) {
                    this.treeViewer.collapseToLevel(obj, -1);
                } else {
                    this.treeViewer.expandToLevel(obj, 1);
                }
                return;
            }
        }
    }

    public abstract DelegatingStyledCellLabelProvider getDefaultLabelProvider();

    public abstract ViewerSorter getDefaultSorter();

    public abstract void openAndHighlight(Object var1);

    public abstract void highlight(Object var1);

    public abstract _CincoAdapter getAdapter(IFile var1, Resource var2);

    public abstract TreeProvider getDataProvider();

    protected IEditorPart openEditor(GraphModel model) {
        IEditorPart iEditor = null;
        URI uri = EcoreUtil.getURI((EObject)model);
        URI uri2 = model.eResource().getURI();
        IFile iFile = null;
        Path path = null;
        if (uri.toPlatformString(true) != null) {
            path = new Path(uri.toPlatformString(true));
        }
        if (uri.toFileString() != null) {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
            path = new Path(newFile.getFullPath().toOSString());
        }
        if (path != null) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        if (iFile == null) {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri2.toString()));
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            iEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)iFile);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return iEditor;
    }

    private class McamContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private final Object[] EMPTY_ARRAY = new Object[0];

        private McamContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (McamPage.this.getDataProvider() == null) {
                return this.EMPTY_ARRAY;
            }
            McamPage.this.getDataProvider().load(null);
            return this.getChildren(McamPage.this.getDataProvider().getTree());
        }

        public Object getParent(Object child) {
            if (child instanceof TreeNode) {
                return ((TreeNode)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeNode) {
                return ((TreeNode)parent).getChildren().toArray(new TreeNode[0]);
            }
            return this.EMPTY_ARRAY;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }
    }

    private class McamFullTextFilter
    extends ViewerFilter {
        private String searchString;

        private McamFullTextFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString.length() > 0) {
                if (element instanceof TreeNode) {
                    TreeNode node = (TreeNode)element;
                    if (node.getParent() == null) {
                        return false;
                    }
                    if (this.compare(node)) {
                        return true;
                    }
                    if (this.hasMatchedChild(node)) {
                        return true;
                    }
                    if (this.hasMatchedParent(node)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private boolean hasMatchedChild(TreeNode node) {
            for (TreeNode childNode : node.getChildren()) {
                if (this.compare(childNode)) {
                    return true;
                }
                if (!this.hasMatchedChild(childNode)) continue;
                return true;
            }
            return false;
        }

        private boolean hasMatchedParent(TreeNode node) {
            if (node.getParent() == null) {
                return false;
            }
            if (this.compare(node)) {
                return true;
            }
            return this.hasMatchedParent(node.getParent());
        }

        private boolean compare(TreeNode node) {
            String string = McamPage.this.getDefaultLabelProvider().getStyledStringProvider().getStyledText((Object)node).toString();
            return string.toLowerCase().contains(this.searchString.toLowerCase());
        }
    }
}

