/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.pages;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.ChangeDeadlockException;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoMergeStrategy;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.TreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.McamPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.ConflictViewTreeProvider;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import info.scce.mcam.framework.adapter.ModelAdapter;
import info.scce.mcam.framework.modules.ChangeModule;
import info.scce.mcam.framework.processes.MergeInformation;
import info.scce.mcam.framework.processes.MergeProcess;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public abstract class ConflictViewPage<E extends _CincoId, M extends GraphModel, A extends _CincoAdapter<E, M>>
extends McamPage {
    private ConflictViewTreeProvider<E, M, A> data;
    protected IFile iFile;
    protected Resource resource;
    private HashMap<String, Image> icons = new HashMap();
    private ConflictViewLabelProvider labelProvider = new ConflictViewLabelProvider();
    private ConflictViewNameSorter nameSorter = new ConflictViewNameSorter();
    private ConflictViewTypeSorter typeSorter = new ConflictViewTypeSorter();
    private List<ChangeModule<E, A>> changesDone = new ArrayList<ChangeModule<E, A>>();
    protected MergeProcess<E, A> mp = null;
    protected int activeFilter = 0;
    protected int activeSort = 0;
    private ConflictViewTypeFilter changedFilter = new ConflictViewTypeFilter(MergeInformation.MergeType.CHANGED);
    private ConflictViewTypeFilter addedFilter = new ConflictViewTypeFilter(MergeInformation.MergeType.ADDED);
    private ConflictViewTypeFilter deletedFilter = new ConflictViewTypeFilter(MergeInformation.MergeType.DELETED);
    private ConflictViewTypeFilter conflictedFilter = new ConflictViewTypeFilter(MergeInformation.MergeType.CONFLICTED);

    public ConflictViewPage(String pageId, IFile iFile, Resource resource) {
        super(pageId);
        this.iFile = iFile;
        this.resource = resource;
        this.mp = this.createMp();
        this.data = new ConflictViewTreeProvider(this);
    }

    @Override
    public ConflictViewTreeProvider<E, M, A> getDataProvider() {
        return this.data;
    }

    public IFile getiFile() {
        return this.iFile;
    }

    public Resource getResource() {
        return this.resource;
    }

    public MergeProcess<E, A> getMp() {
        return this.mp;
    }

    @Override
    public DelegatingStyledCellLabelProvider getDefaultLabelProvider() {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider);
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public void setActiveFilter(int filter) {
        this.activeFilter = filter;
    }

    public int getActiveFilter() {
        return this.activeFilter;
    }

    public void setActiveSort(int sort) {
        this.activeSort = sort;
    }

    public int getActiveSort() {
        return this.activeSort;
    }

    public ViewerSorter getNameSorter() {
        return this.nameSorter;
    }

    public ViewerSorter getTypeSorter() {
        return this.typeSorter;
    }

    public ViewerFilter getConflictViewTypeFilter(MergeInformation.MergeType type) {
        switch (type) {
            case ADDED: {
                return this.addedFilter;
            }
            case CHANGED: {
                return this.changedFilter;
            }
            case CONFLICTED: {
                return this.conflictedFilter;
            }
            case DELETED: {
                return this.deletedFilter;
            }
        }
        return null;
    }

    @Override
    protected void loadIcons() {
        Bundle bundle = Platform.getBundle((String)"de.jabc.cinco.meta.plugin.mcam.runtime");
        try {
            InputStream boxCheckedImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/box_checked.png"), (boolean)true);
            this.icons.put("boxChecked", new Image((Device)EclipseUtils.getDisplay(), boxCheckedImgStream));
            InputStream boxUncheckedImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/box_unchecked.png"), (boolean)true);
            this.icons.put("boxUnchecked", new Image((Device)EclipseUtils.getDisplay(), boxUncheckedImgStream));
            InputStream warningImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/warning.png"), (boolean)true);
            this.icons.put("warning", new Image((Device)EclipseUtils.getDisplay(), warningImgStream));
            InputStream errorImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/error.png"), (boolean)true);
            this.icons.put("error", new Image((Device)EclipseUtils.getDisplay(), errorImgStream));
            InputStream infoImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/info.png"), (boolean)true);
            this.icons.put("info", new Image((Device)EclipseUtils.getDisplay(), infoImgStream));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void highlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof _CincoId) {
            ((_CincoAdapter)((ConflictViewTreeProvider)this.getDataProvider()).getMergeProcess().getMergeModelAdapter()).highlightElement((_CincoId)obj);
        }
    }

    @Override
    public void initPage(Composite parent, ViewPart parentViewPart) throws IOException {
        super.initPage(parent, parentViewPart);
        if (this.mp == null) {
            return;
        }
        this.runInitialChangeExecution();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object obj = null;
                    if (selection.getFirstElement() instanceof TreeNode) {
                        obj = ((TreeNode)selection.getFirstElement()).getData();
                    }
                    if (obj instanceof _CincoId) {
                        ((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()).highlightElement((_CincoId)obj);
                    }
                    if (obj instanceof ChangeModule) {
                        ChangeModule change = (ChangeModule)obj;
                        if (!ConflictViewPage.this.changesDone.contains(change)) {
                            if (change.canPreExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter())) && change.canExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter())) && change.canPostExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()))) {
                                change.preExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                change.execute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                change.postExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                ConflictViewPage.this.changesDone.add(change);
                            } else {
                                MessageDialog.openError((Shell)ConflictViewPage.this.treeViewer.getTree().getShell(), (String)"Change could not be executed!", (String)("Change could not be executed! \n" + change.toString()));
                            }
                        } else if (ConflictViewPage.this.changesDone.contains(change)) {
                            if (change.canUndoPreExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter())) && change.canUndoExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter())) && change.canUndoPostExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()))) {
                                change.undoPostExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                change.undoExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                change.undoPreExecute((ModelAdapter)((_CincoAdapter)ConflictViewPage.this.mp.getMergeModelAdapter()));
                                ConflictViewPage.this.changesDone.remove(change);
                            } else {
                                MessageDialog.openError((Shell)ConflictViewPage.this.treeViewer.getTree().getShell(), (String)"Change could not be reverted!", (String)("Change could not be reverted! \n" + change.toString()));
                            }
                        }
                    }
                    ConflictViewPage.this.treeViewer.refresh();
                }
            }
        });
    }

    public void runInitialChangeExecution() {
        this.mp.analyzeGraphCompares();
        _CincoMergeStrategy strategy = new _CincoMergeStrategy();
        try {
            this.changesDone = strategy.executeChanges((_CincoAdapter)this.mp.getMergeModelAdapter(), this.mp.getMergeInformationMap().values(), false);
        }
        catch (ChangeDeadlockException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof _CincoId) {
            _CincoId id = (_CincoId)obj;
            IdentifiableElement element = id.getElement();
            if (element instanceof ModelElement) {
                ModelElement me = (ModelElement)element;
                IEditorPart editor = this.openEditor(me.getRootElement());
                IFile iFile = EclipseUtils.getIFile(editor);
                Resource resource = EclipseUtils.getResource(editor);
                _CincoAdapter adapter = this.getAdapter(iFile, resource);
                adapter.highlightElement(adapter.getIdByString(me.getId()));
            }
            if (element instanceof GraphModel) {
                this.openEditor((GraphModel)element);
            }
        }
    }

    protected abstract MergeProcess<E, A> createMp();

    private class ConflictViewLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public Image getImage(Object element) {
            if ((element = ConflictViewPage.this.getTreeNodeData(element)) instanceof _CincoId) {
                _CincoId id = (_CincoId)element;
                if (((MergeInformation)((ConflictViewTreeProvider)ConflictViewPage.this.getDataProvider()).getMergeProcess().getMergeInformationMap().get(id)).getListOfConflictedChangeSets().size() > 0) {
                    return ConflictViewPage.this.icons.get("error");
                }
                return ConflictViewPage.this.icons.get("info");
            }
            if (element instanceof ChangeModule) {
                ChangeModule change = (ChangeModule)element;
                if (ConflictViewPage.this.changesDone.contains(change)) {
                    return ConflictViewPage.this.icons.get("boxChecked");
                }
                return ConflictViewPage.this.icons.get("boxUnchecked");
            }
            if (element instanceof Set) {
                return ConflictViewPage.this.icons.get("warning");
            }
            return null;
        }

        public String getText(Object element) {
            if ((element = ConflictViewPage.this.getTreeNodeData(element)) instanceof _CincoId) {
                return ((_CincoId)element).toString();
            }
            if (element instanceof ChangeModule) {
                ChangeModule change = (ChangeModule)element;
                if (((MergeInformation)((ConflictViewTreeProvider)ConflictViewPage.this.getDataProvider()).getMergeProcess().getMergeInformationMap().get(change.id)).getLocalChanges().contains(change)) {
                    return "(L) " + change.toString();
                }
                if (((MergeInformation)((ConflictViewTreeProvider)ConflictViewPage.this.getDataProvider()).getMergeProcess().getMergeInformationMap().get(change.id)).getRemoteChanges().contains(change)) {
                    return "(R) " + change.toString();
                }
            }
            if (element instanceof Set) {
                for (MergeInformation mergeInfo : ConflictViewPage.this.mp.getMergeInformationMap().values()) {
                    int i = 0;
                    for (Set conflictSet : mergeInfo.getListOfConflictedChangeSets()) {
                        ++i;
                        if (!conflictSet.equals((Set)element)) continue;
                        return "Conflict " + i;
                    }
                }
                return "Conflict";
            }
            return "unknown";
        }

        public StyledString getStyledText(Object arg0) {
            return null;
        }
    }

    private class ConflictViewNameSorter
    extends ViewerSorter {
        private ArrayList<MergeInformation.MergeType> typeSorting = new ArrayList();

        public ConflictViewNameSorter() {
            this.typeSorting.add(MergeInformation.MergeType.CONFLICTED);
            this.typeSorting.add(MergeInformation.MergeType.CHANGED);
            this.typeSorting.add(MergeInformation.MergeType.ADDED);
            this.typeSorting.add(MergeInformation.MergeType.DELETED);
        }

        public int category(Object element) {
            if (element instanceof _CincoId) {
                return 1;
            }
            if (element instanceof Set) {
                return 2;
            }
            return 3;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = ConflictViewPage.this.getTreeNodeData(e1);
            e2 = ConflictViewPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof _CincoId && e2 instanceof _CincoId) {
                _CincoId id1 = (_CincoId)e1;
                _CincoId id2 = (_CincoId)e2;
                Object input = viewer.getInput();
                if (input instanceof MergeProcess) {
                    MergeProcess mp = (MergeProcess)input;
                    MergeInformation.MergeType type1 = ((MergeInformation)mp.getMergeInformationMap().get(id1)).getType();
                    MergeInformation.MergeType type2 = ((MergeInformation)mp.getMergeInformationMap().get(id2)).getType();
                    return this.typeSorting.indexOf(type1) - this.typeSorting.indexOf(type2);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public class ConflictViewTypeFilter
    extends ViewerFilter {
        MergeInformation.MergeType type = MergeInformation.MergeType.UNCHANGED;

        public ConflictViewTypeFilter(MergeInformation.MergeType type) {
            this.type = type;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if ((element = ConflictViewPage.this.getTreeNodeData(element)) instanceof Set || element instanceof ChangeModule) {
                return true;
            }
            if (element instanceof _CincoId) {
                _CincoId id = (_CincoId)element;
                return ((MergeInformation)((ConflictViewTreeProvider)ConflictViewPage.this.getDataProvider()).getMergeProcess().getMergeInformationMap().get(id)).getType().equals((Object)this.type);
            }
            return false;
        }
    }

    public class ConflictViewTypeSorter
    extends ViewerSorter {
        private ArrayList<MergeInformation.MergeType> typeSorting = new ArrayList();

        public ConflictViewTypeSorter() {
            this.typeSorting.add(MergeInformation.MergeType.CONFLICTED);
            this.typeSorting.add(MergeInformation.MergeType.CHANGED);
            this.typeSorting.add(MergeInformation.MergeType.ADDED);
            this.typeSorting.add(MergeInformation.MergeType.DELETED);
        }

        public int category(Object element) {
            if (element instanceof _CincoId) {
                return 1;
            }
            if (element instanceof Set) {
                return 2;
            }
            return 3;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            e1 = ConflictViewPage.this.getTreeNodeData(e1);
            e2 = ConflictViewPage.this.getTreeNodeData(e2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof _CincoId && e2 instanceof _CincoId) {
                _CincoId id1 = (_CincoId)e1;
                _CincoId id2 = (_CincoId)e2;
                Object input = viewer.getInput();
                if (input instanceof MergeProcess) {
                    MergeProcess mp = (MergeProcess)input;
                    MergeInformation.MergeType type1 = ((MergeInformation)mp.getMergeInformationMap().get(id1)).getType();
                    MergeInformation.MergeType type2 = ((MergeInformation)mp.getMergeInformationMap().get(id2)).getType();
                    return this.typeSorting.indexOf(type1) - this.typeSorting.indexOf(type2);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

