/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.pages;

import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoAdapter;
import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.DefaultOkObject;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes.TreeNode;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.McamPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.CheckViewTreeProvider;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import info.scce.mcam.framework.modules.CheckModule;
import info.scce.mcam.framework.processes.CheckInformation;
import info.scce.mcam.framework.processes.CheckProcess;
import info.scce.mcam.framework.processes.CheckResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public abstract class CheckViewPage<E extends _CincoId, M extends GraphModel, A extends _CincoAdapter<E, M>>
extends McamPage {
    private CheckViewTreeProvider<E, M, A> data;
    private List<CheckProcess<?, ?>> checkProcesses = new ArrayList();
    private HashMap<String, Image> icons = new HashMap();
    private CheckViewLabelProvider labelProvider = new CheckViewLabelProvider();
    private CheckViewNameSorter nameSorter = new CheckViewNameSorter();
    private CheckViewResultTypeFilter resultTypeFilter = new CheckViewResultTypeFilter();
    private DefaultOkResultFilter defaultOkResultFilter = new DefaultOkResultFilter();
    private CheckConfiguration checkConfiguration = new CheckConfiguration();

    public CheckViewPage(String pageId) {
        super(pageId);
        this.data = new CheckViewTreeProvider(this, CheckViewTreeProvider.ViewType.BY_ID);
    }

    public List<CheckProcess<?, ?>> getCheckProcesses() {
        return this.checkProcesses;
    }

    @Override
    public CheckViewTreeProvider<E, M, A> getDataProvider() {
        return this.data;
    }

    @Override
    public DelegatingStyledCellLabelProvider getDefaultLabelProvider() {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider);
    }

    public CheckViewLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ViewerSorter getDefaultSorter() {
        return this.nameSorter;
    }

    public CheckViewResultTypeFilter getResultTypeFilter() {
        return this.resultTypeFilter;
    }

    public CheckConfiguration getCheckConfiguration() {
        return this.checkConfiguration;
    }

    @Override
    protected void loadIcons() {
        Bundle bundle = Platform.getBundle((String)"de.jabc.cinco.meta.plugin.mcam.runtime");
        try {
            InputStream entityOkImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/ok.png"), (boolean)true);
            this.icons.put("resultOk", new Image((Device)EclipseUtils.getDisplay(), entityOkImgStream));
            InputStream entityErrorImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/error.png"), (boolean)true);
            this.icons.put("resultError", new Image((Device)EclipseUtils.getDisplay(), entityErrorImgStream));
            InputStream checkWarningImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/warning.png"), (boolean)true);
            this.icons.put("resultWarning", new Image((Device)EclipseUtils.getDisplay(), checkWarningImgStream));
            InputStream checkNotCheckedImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/unchecked.png"), (boolean)true);
            this.icons.put("resultNotChecked", new Image((Device)EclipseUtils.getDisplay(), checkNotCheckedImgStream));
            InputStream checkInfoImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/info.png"), (boolean)true);
            this.icons.put("resultInfo", new Image((Device)EclipseUtils.getDisplay(), checkInfoImgStream));
            InputStream checkFailureImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/failure.png"), (boolean)true);
            this.icons.put("resultFailure", new Image((Device)EclipseUtils.getDisplay(), checkFailureImgStream));
            InputStream checkItemImgStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/item.png"), (boolean)true);
            this.icons.put("item", new Image((Device)EclipseUtils.getDisplay(), checkItemImgStream));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void addCheckProcess(IFile var1, Resource var2);

    @Override
    public void highlight(Object obj) {
        Object element = obj;
        if (obj instanceof TreeNode) {
            element = this.getTreeNodeData(obj);
        }
        if (element instanceof CheckResult) {
            CheckResult result = (CheckResult)element;
            ((_CincoAdapter)result.getModule().getCp().getModel()).highlightElement((_CincoId)result.getId());
        }
        if (element instanceof _CincoId) {
            _CincoId id = (_CincoId)element;
            CheckProcess<?, ?> checkProcess = this.getCheckProcessById(id);
            ((_CincoAdapter)checkProcess.getModel()).highlightElement((_CincoId)element);
        }
    }

    @Override
    public void openAndHighlight(Object obj) {
        if ((obj = this.getTreeNodeData(obj)) instanceof _CincoId) {
            this.openAndHighlight((_CincoId)obj);
        }
        if (obj instanceof CheckResult) {
            this.openAndHighlight((_CincoId)((CheckResult)obj).getId());
        }
        if (obj instanceof CheckProcess) {
            this.openEditor((GraphModel)((_CincoAdapter)((CheckProcess)obj).getModel()).getModel());
        }
    }

    protected void openAndHighlight(_CincoId id) {
        IdentifiableElement element = id.getElement();
        if (element instanceof ModelElement) {
            ModelElement me = (ModelElement)element;
            IEditorPart editor = this.openEditor(me.getRootElement());
            IFile iFile = EclipseUtils.getIFile(editor);
            Resource resource = EclipseUtils.getResource(editor);
            _CincoAdapter adapter = this.getAdapter(iFile, resource);
            adapter.highlightElement(adapter.getIdByString(me.getId()));
        }
        if (element instanceof GraphModel) {
            this.openEditor((GraphModel)element);
        }
    }

    protected CheckProcess<?, ?> getCheckProcessById(_CincoId id) {
        for (CheckProcess<?, ?> checkProcess : this.checkProcesses) {
            if (!checkProcess.getModel().getEntityIds().contains(id)) continue;
            return checkProcess;
        }
        return null;
    }

    protected CheckResult.CheckResultType getResultType(Class<?> moduleClass) {
        CheckResult.CheckResultType type = CheckResult.CheckResultType.NOT_CHECKED;
        for (CheckProcess<?, ?> checkProcess : this.checkProcesses) {
            for (CheckModule module : checkProcess.getModules()) {
                if (!module.getClass().equals(moduleClass) || this.compareResultType(module.getResultType(), type) >= 0) continue;
                type = module.getResultType();
            }
        }
        return type;
    }

    protected CheckResult.CheckResultType getResultType(CheckProcess<?, ?> cp) {
        CheckResult.CheckResultType type = CheckResult.CheckResultType.NOT_CHECKED;
        for (CheckModule module : cp.getModules()) {
            if (this.compareResultType(module.getResultType(), type) >= 0) continue;
            type = module.getResultType();
        }
        return type;
    }

    protected int compareResultType(CheckResult.CheckResultType type1, CheckResult.CheckResultType type2) {
        return CheckResult.CheckResultType.valueOf((String)type1.toString()).ordinal() - CheckResult.CheckResultType.valueOf((String)type2.toString()).ordinal();
    }

    @Override
    public void initPage(Composite parent, ViewPart parentViewPart) throws IOException {
        super.initPage(parent, parentViewPart);
        this.treeViewer.addFilter((ViewerFilter)this.resultTypeFilter);
        this.treeViewer.addFilter((ViewerFilter)this.defaultOkResultFilter);
    }

    public class CheckConfiguration {
        private boolean stopAtFirstError = false;

        public boolean isStopAtFirstError() {
            return this.stopAtFirstError;
        }

        public void switchStopAtFirstError() {
            this.stopAtFirstError = !this.stopAtFirstError;
        }
    }

    public class CheckViewLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private boolean showPerformance = false;

        public boolean isShowPerformance() {
            return this.showPerformance;
        }

        public void setShowPerformance(boolean showPerformance) {
            this.showPerformance = showPerformance;
        }

        public Image getImage(Object obj) {
            Object element = CheckViewPage.this.getTreeNodeData(obj);
            if (element instanceof CheckResult) {
                CheckResult result = (CheckResult)element;
                return this.mapResultTypeToImage(result.getType());
            }
            if (element instanceof CheckModule) {
                CheckModule module = (CheckModule)element;
                return this.mapResultTypeToImage(module.getResultType());
            }
            if (element instanceof _CincoId) {
                CheckProcess<?, ?> cp = CheckViewPage.this.getCheckProcessById((_CincoId)element);
                return this.mapResultTypeToImage(((CheckInformation)cp.getCheckInformationMap().get(element)).getResultType());
            }
            if (element instanceof CheckProcess) {
                CheckProcess cp = (CheckProcess)element;
                return this.mapResultTypeToImage(CheckViewPage.this.getResultType(cp));
            }
            if (element instanceof DefaultOkObject) {
                return CheckViewPage.this.icons.get("resultOk");
            }
            return null;
        }

        private Image mapResultTypeToImage(CheckResult.CheckResultType type) {
            if (type.equals((Object)CheckResult.CheckResultType.PASSED)) {
                return CheckViewPage.this.icons.get("resultOk");
            }
            if (type.equals((Object)CheckResult.CheckResultType.ERROR)) {
                return CheckViewPage.this.icons.get("resultError");
            }
            if (type.equals((Object)CheckResult.CheckResultType.WARNING)) {
                return CheckViewPage.this.icons.get("resultWarning");
            }
            if (type.equals((Object)CheckResult.CheckResultType.NOT_CHECKED)) {
                return CheckViewPage.this.icons.get("resultNotChecked");
            }
            if (type.equals((Object)CheckResult.CheckResultType.INFO)) {
                return CheckViewPage.this.icons.get("resultInfo");
            }
            if (type.equals((Object)CheckResult.CheckResultType.FAILURE)) {
                return CheckViewPage.this.icons.get("resultFailure");
            }
            return null;
        }

        public StyledString getStyledText(Object obj) {
            CheckProcess cp;
            CheckInformation checkInfo;
            StyledString styledString = new StyledString("unknown");
            if (!(obj instanceof TreeNode)) {
                return styledString;
            }
            styledString = new StyledString(((TreeNode)obj).getLabel());
            Object element = CheckViewPage.this.getTreeNodeData(obj);
            if (element instanceof CheckModule) {
                CheckModule module = (CheckModule)element;
                styledString.append(" (" + module.getNumberOf(CheckResult.CheckResultType.ERROR) + "/" + module.getNumberOf(CheckResult.CheckResultType.WARNING) + ") ", StyledString.COUNTER_STYLER);
                if (this.showPerformance) {
                    styledString.append(" [" + module.getExecutionTime() + "ms] ", StyledString.QUALIFIER_STYLER);
                }
            }
            if (element instanceof _CincoId && (checkInfo = (CheckInformation)(cp = CheckViewPage.this.getCheckProcessById((_CincoId)element)).getCheckInformationMap().get(element)) != null) {
                styledString.append(" (" + checkInfo.getNumberOf(CheckResult.CheckResultType.ERROR) + "/" + checkInfo.getNumberOf(CheckResult.CheckResultType.WARNING) + ") ", StyledString.COUNTER_STYLER);
            }
            if (element instanceof CheckProcess) {
                cp = (CheckProcess)element;
                if (this.showPerformance) {
                    styledString.append(" [" + cp.getExecutionTime() + "ms] ", StyledString.QUALIFIER_STYLER);
                }
            }
            if (element instanceof DefaultOkObject) {
                return new StyledString("all checks passed!");
            }
            return styledString;
        }
    }

    private class CheckViewNameSorter
    extends ViewerSorter {
        public int category(Object element) {
            if (element instanceof _CincoId) {
                return 1;
            }
            if (element instanceof CheckResult) {
                return 2;
            }
            if (element instanceof CheckModule) {
                return 2;
            }
            if (element instanceof CheckProcess) {
                return 4;
            }
            return 5;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            if (e1 instanceof String && e2 instanceof String) {
                String s1 = (String)e1;
                String s2 = (String)e2;
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
            if (!(e1 instanceof TreeNode) && !(e2 instanceof TreeNode)) {
                return 0;
            }
            TreeNode node1 = (TreeNode)e1;
            TreeNode node2 = (TreeNode)e2;
            e1 = CheckViewPage.this.getTreeNodeData(node1);
            e2 = CheckViewPage.this.getTreeNodeData(node2);
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof CheckProcess && e2 instanceof CheckProcess) {
                CheckProcess cp1 = (CheckProcess)e1;
                CheckProcess cp2 = (CheckProcess)e2;
                int diff = CheckViewPage.this.compareResultType(CheckViewPage.this.getResultType(cp1), CheckViewPage.this.getResultType(cp2));
                if (diff == 0) {
                    return this.compare(viewer, ((_CincoAdapter)cp1.getModel()).getModelName(), ((_CincoAdapter)cp2.getModel()).getModelName());
                }
                return diff;
            }
            if (e1 instanceof CheckModule && e2 instanceof CheckModule) {
                CheckModule cm1 = (CheckModule)e1;
                CheckModule cm2 = (CheckModule)e2;
                int diff = CheckViewPage.this.compareResultType(cm1.getResultType(), cm2.getResultType());
                if (diff == 0) {
                    return this.compare(viewer, cm1.getName(), cm2.getName());
                }
                return diff;
            }
            if (e1 instanceof CheckResult && e2 instanceof CheckResult) {
                CheckResult result1 = (CheckResult)e1;
                CheckResult result2 = (CheckResult)e2;
                int diff = CheckViewPage.this.compareResultType(result1.getType(), result2.getType());
                if (diff == 0) {
                    return this.compare(viewer, result1.getMessage(), result2.getMessage());
                }
                return diff;
            }
            if (e1 instanceof _CincoId && e2 instanceof _CincoId) {
                CheckResult.CheckResultType type2;
                _CincoId id1 = (_CincoId)e1;
                _CincoId id2 = (_CincoId)e2;
                CheckProcess<?, ?> cp1 = CheckViewPage.this.getCheckProcessById(id1);
                CheckProcess<?, ?> cp2 = CheckViewPage.this.getCheckProcessById(id2);
                CheckResult.CheckResultType type1 = ((CheckInformation)cp1.getCheckInformationMap().get(id1)).getResultType();
                int diff = CheckViewPage.this.compareResultType(type1, type2 = ((CheckInformation)cp2.getCheckInformationMap().get(id2)).getResultType());
                if (diff == 0) {
                    return this.compare(viewer, id1.toString(), id2.toString());
                }
                return diff;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public class CheckViewResultTypeFilter
    extends ViewerFilter {
        private boolean showNonErrors = true;
        private CheckResult.CheckResultType[] non_errors = new CheckResult.CheckResultType[]{CheckResult.CheckResultType.NOT_CHECKED, CheckResult.CheckResultType.INFO, CheckResult.CheckResultType.PASSED, CheckResult.CheckResultType.WARNING};

        public boolean isShowNonErrors() {
            return this.showNonErrors;
        }

        public void switchShowNonErrors() {
            this.showNonErrors = !this.showNonErrors;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (this.display(node.getData())) {
                    return true;
                }
                Iterator<TreeNode> iterator = node.getChildren().iterator();
                if (iterator.hasNext()) {
                    TreeNode childNode = iterator.next();
                    return this.select(viewer, element, childNode);
                }
            }
            return false;
        }

        private boolean display(Object element) {
            if (element instanceof DefaultOkObject) {
                return true;
            }
            if (element instanceof CheckProcess) {
                CheckProcess cp = (CheckProcess)element;
                return this.display(CheckViewPage.this.getResultType(cp));
            }
            if (element instanceof CheckResult) {
                CheckResult result = (CheckResult)element;
                return this.display(result.getType());
            }
            if (element instanceof CheckModule) {
                CheckModule module = (CheckModule)element;
                return this.display(CheckViewPage.this.getResultType(module.getClass()));
            }
            if (element instanceof _CincoId) {
                _CincoId id = (_CincoId)element;
                return this.display(((CheckInformation)CheckViewPage.this.getCheckProcessById(id).getCheckInformationMap().get(id)).getResultType());
            }
            return false;
        }

        private boolean display(CheckResult.CheckResultType type) {
            if (this.showNonErrors) {
                return true;
            }
            return !Arrays.asList(this.non_errors).contains(type);
        }
    }

    public class DefaultOkResultFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            TreeNode node;
            if (element instanceof TreeNode && !((node = (TreeNode)element).getData() instanceof DefaultOkObject)) {
                return true;
            }
            if (!((CheckViewTreeProvider)CheckViewPage.this.getDataProvider()).getActiveView().equals((Object)CheckViewTreeProvider.ViewType.BY_ID)) {
                return false;
            }
            for (CheckProcess<?, ?> checkProcess : CheckViewPage.this.checkProcesses) {
                for (CheckInformation checkInfo : checkProcess.getCheckInformationMap().values()) {
                    if (checkInfo.getResultType().equals((Object)CheckResult.CheckResultType.PASSED)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

