/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class TreeNode {
    protected UUID uuid = null;
    protected String label = null;
    protected Object data = null;
    private TreeNode parent = null;
    private ArrayList<TreeNode> children = new ArrayList();

    public TreeNode(Object data) {
        this.data = data;
        this.uuid = UUID.randomUUID();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<TreeNode> children) {
        this.children = children;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.toString();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract String getId();

    public String getPathIdentifier() {
        String ident = this.getId();
        if (this.parent != null) {
            ident = String.valueOf(this.parent.getPathIdentifier()) + "/" + ident;
        }
        return ident;
    }

    public TreeNode find(String id) {
        if (this.getId() == null || id == null) {
            return null;
        }
        if (id.equals(this.getId())) {
            return this;
        }
        for (TreeNode child : this.children) {
            TreeNode result = child.find(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int hashCode() {
        String pathId = this.getPathIdentifier();
        int prime = 19;
        int result = 1;
        result = 19 * result + (pathId == null ? 0 : pathId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeNode)) {
            return false;
        }
        TreeNode node = (TreeNode)obj;
        return this.getPathIdentifier().equals(node.getPathIdentifier());
    }

    public String toString() {
        String output = "TreeNode of: " + this.data.getClass().getSimpleName() + "\n";
        for (TreeNode treeNode : this.children) {
            output = String.valueOf(output) + " - " + treeNode.toString();
        }
        return output;
    }
}

