/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views;

import de.jabc.cinco.meta.plugin.mcam.runtime.views.PageFactory;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.McamPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class McamView<T extends McamPage>
extends ViewPart
implements IPartListener2 {
    private static final String EXTENSION_ID = "de.jabc.cinco.meta.plugin.mcam.runtime.extensionpoint";
    protected Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
    private Composite parent;
    protected T activePage;
    protected TreeViewer viewer;
    protected IFile activeFile;
    private HashMap<String, T> pageMap = new HashMap();
    private HashMap<String, Integer> pageCountMap = new HashMap();
    protected IAction doubleClickAction;
    protected IAction expandAllAction;
    protected IAction collapseAllAction;
    protected IAction reloadAction;
    protected IAction openModelAction;
    protected Image iconRefresh;
    protected Image iconCollapseAll;
    protected Image iconExpandAll;

    public IFile getActiveFile() {
        return this.activeFile;
    }

    public T getActivePage() {
        return this.activePage;
    }

    public HashMap<String, T> getPageMap() {
        return this.pageMap;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new GridLayout(1, true));
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)this);
        try {
            this.loadIcons();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.makeActions();
        this.contributeToActionBars();
        this.initView(parent);
        this.loadPageByEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
    }

    private void initControls() {
        this.viewer = ((McamPage)this.activePage).getTreeViewer();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                McamView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void loadIcons() throws IOException {
        Bundle bundle = Platform.getBundle((String)"de.jabc.cinco.meta.plugin.mcam.runtime");
        this.iconRefresh = new Image((Device)EclipseUtils.getDisplay(), FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/refresh.gif"), (boolean)true));
        this.iconCollapseAll = new Image((Device)EclipseUtils.getDisplay(), FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/collapseall.png"), (boolean)true));
        this.iconExpandAll = new Image((Device)EclipseUtils.getDisplay(), FileLocator.openStream((Bundle)bundle, (IPath)new Path("icons/expandall.gif"), (boolean)true));
    }

    protected abstract void fillLocalPullDown(IMenuManager var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    protected abstract void fillLocalToolBar(IToolBarManager var1);

    protected abstract void initView(Composite var1);

    protected void makeActions() {
        this.reloadAction = new Action(){

            public void run() {
                if (McamView.this.activePage != null) {
                    ((McamPage)McamView.this.activePage).reload();
                }
                McamView.this.refreshView();
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload");
        this.reloadAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconRefresh));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = McamView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ((McamPage)McamView.this.activePage).toggleExpand(obj);
            }
        };
        this.expandAllAction = new Action(){

            public void run() {
                if (McamView.this.activePage != null) {
                    ((McamPage)McamView.this.activePage).getTreeViewer().expandAll();
                }
            }
        };
        this.expandAllAction.setText("Expand all");
        this.expandAllAction.setToolTipText("Expand all");
        this.expandAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconExpandAll));
        this.collapseAllAction = new Action(){

            public void run() {
                if (McamView.this.activePage != null) {
                    ((McamPage)McamView.this.activePage).getTreeViewer().collapseAll();
                }
            }
        };
        this.collapseAllAction.setText("Collapse all");
        this.collapseAllAction.setToolTipText("Collapse all");
        this.collapseAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconCollapseAll));
        this.openModelAction = new Action(){

            public void run() {
                ISelection selection = McamView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ((McamPage)McamView.this.activePage).openAndHighlight(obj);
            }
        };
        this.openModelAction.setText("show/open model");
        this.openModelAction.setToolTipText("show/open model");
    }

    protected abstract void reloadViewState();

    protected void setActivePage(T activePage) {
        this.activePage = activePage;
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void hookDoubleClickAction() {
        ((McamPage)this.activePage).getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                McamView.this.doubleClickAction.run();
            }
        });
    }

    public void refreshView() {
        if (!this.parent.isDisposed()) {
            this.parent.layout(true, true);
            this.parent.redraw();
            this.parent.update();
        }
    }

    protected void editorChanged() {
        this.refreshView();
    }

    protected void activePageChanged() {
        this.initControls();
        this.reloadViewState();
    }

    public void setFocus() {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.refreshActivePages();
        if (partRef instanceof EditorReference) {
            this.closePage(((EditorReference)partRef).getEditor(true));
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.refreshActivePages();
        Display.getCurrent().asyncExec(() -> {
            if (partRef instanceof EditorReference) {
                this.createPageByEditor(((EditorReference)partRef).getEditor(true));
            }
        });
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.refreshActivePages();
        Display.getCurrent().asyncExec(() -> {
            if (partRef instanceof EditorReference) {
                this.loadPageByEditor(((EditorReference)partRef).getEditor(true));
            }
        });
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    protected void refreshActivePages() {
        this.pageCountMap = new HashMap();
        IEditorReference[] editorRefs = null;
        try {
            editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        }
        catch (NullPointerException e) {
            return;
        }
        if (editorRefs != null) {
            IEditorReference[] iEditorReferenceArray = editorRefs;
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor = ((EditorReference)editorRef).getEditor(true);
                String pageId = this.getPageId((IResource)EclipseUtils.getIFile(editor));
                if (!this.pageCountMap.containsKey(pageId)) {
                    this.pageCountMap.put(pageId, 1);
                } else {
                    int i = this.pageCountMap.get(pageId);
                    this.pageCountMap.put(pageId, ++i);
                }
                ++n2;
            }
        }
    }

    protected void closePage(IEditorPart editor) {
        if (!this.canHandle(editor)) {
            return;
        }
        if (this.parent.isDisposed()) {
            return;
        }
        String pageId = this.getPageId((IResource)EclipseUtils.getIFile(editor));
        if (this.pageMap.keySet().contains(pageId)) {
            if (this.pageCountMap.get(pageId) != null && this.pageCountMap.get(pageId) > 0) {
                return;
            }
            System.out.println("Closing page " + pageId);
            McamPage page = (McamPage)this.pageMap.get(pageId);
            page.closeView();
            this.pageMap.remove(pageId);
            this.pageCountMap.remove(pageId);
            this.activePage = null;
            if (!this.parent.isDisposed()) {
                this.parent.layout(true);
                this.parent.redraw();
                this.parent.update();
            }
        }
    }

    protected void createPageByEditor(IEditorPart editor) {
        if (!this.canHandle(editor)) {
            return;
        }
        if (this.parent.isDisposed()) {
            return;
        }
        IFile file = EclipseUtils.getIFile(editor);
        if (file == null) {
            return;
        }
        String pageId = this.getPageId((IResource)file);
        if (!this.pageMap.keySet().contains(pageId)) {
            System.out.println("Creating page for " + pageId);
            try {
                T newPage = this.createPage(pageId, editor);
                if (newPage == null) {
                    return;
                }
                ((McamPage)newPage).initPage(this.parent, this);
                this.pageMap.put(pageId, newPage);
                this.pageCountMap.put(pageId, 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            int count = this.pageCountMap.get(pageId);
            this.pageCountMap.put(pageId, ++count);
        }
    }

    protected boolean canHandle(IEditorPart editor) {
        List<PageFactory> pageFactories;
        boolean editorWithInput;
        boolean bl = editorWithInput = editor != null && editor.getEditorInput() != null;
        if (editorWithInput && (pageFactories = this.getPageFactories()) != null) {
            return pageFactories.stream().anyMatch(factory -> factory.canHandle(EclipseUtils.getResource(editor)));
        }
        return false;
    }

    protected void loadPageByEditor(IEditorPart editor) {
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setVisible(false);
            if (child.getLayoutData() instanceof GridData) {
                ((GridData)child.getLayoutData()).exclude = true;
            }
            ++n2;
        }
        if (!this.canHandle(editor)) {
            return;
        }
        if (this.parent.isDisposed()) {
            return;
        }
        String pageId = this.getPageId((IResource)EclipseUtils.getIFile(editor));
        if (pageId == null) {
            return;
        }
        if (this.activePage == null || !pageId.equals(((McamPage)this.activePage).getPageId())) {
            System.out.println("Loading pageId = " + pageId);
            if (this.pageMap.get(pageId) == null) {
                this.createPageByEditor(editor);
            }
            this.setActivePage((McamPage)this.pageMap.get(pageId));
            if (this.activePage == null) {
                return;
            }
            this.activePageChanged();
        }
        ((McamPage)this.activePage).getFrameComposite().setVisible(true);
        ((GridData)((McamPage)this.activePage).getFrameComposite().getLayoutData()).exclude = false;
        this.editorChanged();
    }

    public abstract String getPageId(IResource var1);

    public abstract T createPage(String var1, IEditorPart var2);

    protected List<PageFactory> getPageFactories() {
        IConfigurationElement[] configElements;
        System.out.println("MCaM RUNTIME Extension Registry: " + Platform.getExtensionRegistry());
        ArrayList<PageFactory> factories = new ArrayList<PageFactory>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                System.out.println("Create MCaM extension: " + ce);
                Object o = ce.createExecutableExtension("class");
                System.out.println(" > " + o);
                if (o instanceof PageFactory) {
                    factories.add((PageFactory)o);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return factories;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener2)this);
        super.dispose();
    }
}

