/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views;

import de.jabc.cinco.meta.plugin.mcam.runtime.views.McamView;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.PageFactory;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.ConflictViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.ConflictViewTreeProvider;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import info.scce.mcam.framework.processes.MergeInformation;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;

public class ConflictView
extends McamView<ConflictViewPage> {
    public static final String ID = "de.jabc.cinco.meta.plugin.mcam.runtime.views.ConflictView";
    private IAction showByIdViewAction;
    private IAction sortByMergeTypeAction;
    private IAction sortByNameAction;
    private IAction filterNothingAction;
    private IAction filterOnlyConflictedAction;
    private IAction filterOnlyAddedAction;
    private IAction filterOnlyChangedAction;
    private IAction filterOnlyDeletedAction;

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager viewSubmenu = new MenuManager("Views");
        manager.add((IContributionItem)viewSubmenu);
        viewSubmenu.add(this.showByIdViewAction);
        MenuManager filterSubmenu = new MenuManager("Filters");
        manager.add((IContributionItem)filterSubmenu);
        filterSubmenu.add(this.filterNothingAction);
        filterSubmenu.add(this.filterOnlyAddedAction);
        filterSubmenu.add(this.filterOnlyChangedAction);
        filterSubmenu.add(this.filterOnlyConflictedAction);
        filterSubmenu.add(this.filterOnlyDeletedAction);
        MenuManager sortSubmenu = new MenuManager("Sort By");
        manager.add((IContributionItem)sortSubmenu);
        sortSubmenu.add(this.sortByNameAction);
        sortSubmenu.add(this.sortByMergeTypeAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.openModelAction);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.expandAllAction);
        manager.add(this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.showByIdViewAction = new Action(){

            public void run() {
                ((ConflictViewTreeProvider)((ConflictViewPage)ConflictView.this.activePage).getDataProvider()).setActiveView(ConflictViewTreeProvider.ViewType.BY_ID);
                ((ConflictViewPage)ConflictView.this.activePage).getTreeViewer().setLabelProvider((IBaseLabelProvider)((ConflictViewPage)ConflictView.this.activePage).getDefaultLabelProvider());
                EclipseUtils.runBusy(new Runnable(){

                    @Override
                    public void run() {
                        ((ConflictViewPage)(this).ConflictView.this.activePage).reload();
                        ConflictView.this.reloadViewState();
                    }
                });
            }
        };
        this.showByIdViewAction.setText("by entity");
        this.showByIdViewAction.setToolTipText("show results by entity");
        this.showByIdViewAction.setChecked(false);
        this.sortByMergeTypeAction = new Action(){

            public void run() {
                ConflictView.this.updateSorter(ConflictView.this.sortByMergeTypeAction);
            }
        };
        this.sortByMergeTypeAction.setText("sort by merge type");
        this.sortByMergeTypeAction.setToolTipText("sort ids by merge type");
        this.sortByMergeTypeAction.setEnabled(true);
        this.sortByMergeTypeAction.setChecked(false);
        this.sortByNameAction = new Action(){

            public void run() {
                ConflictView.this.updateSorter(ConflictView.this.sortByNameAction);
            }
        };
        this.sortByNameAction.setText("sort by name");
        this.sortByNameAction.setToolTipText("sort ids by name alphabetical");
        this.sortByNameAction.setEnabled(true);
        this.sortByNameAction.setChecked(false);
        this.filterNothingAction = new Action(){

            public void run() {
                ConflictView.this.updateFilter(ConflictView.this.filterNothingAction);
            }
        };
        this.filterNothingAction.setText("show all");
        this.filterNothingAction.setToolTipText("show all ids");
        this.filterNothingAction.setEnabled(true);
        this.filterNothingAction.setChecked(false);
        this.filterOnlyAddedAction = new Action(){

            public void run() {
                ConflictView.this.updateFilter(ConflictView.this.filterOnlyAddedAction);
            }
        };
        this.filterOnlyAddedAction.setText("show added");
        this.filterOnlyAddedAction.setToolTipText("show added ids");
        this.filterOnlyAddedAction.setEnabled(true);
        this.filterOnlyAddedAction.setChecked(false);
        this.filterOnlyChangedAction = new Action(){

            public void run() {
                ConflictView.this.updateFilter(ConflictView.this.filterOnlyChangedAction);
            }
        };
        this.filterOnlyChangedAction.setText("show changed");
        this.filterOnlyChangedAction.setToolTipText("show changed ids");
        this.filterOnlyChangedAction.setEnabled(true);
        this.filterOnlyChangedAction.setChecked(false);
        this.filterOnlyConflictedAction = new Action(){

            public void run() {
                ConflictView.this.updateFilter(ConflictView.this.filterOnlyConflictedAction);
            }
        };
        this.filterOnlyConflictedAction.setText("show conflicted");
        this.filterOnlyConflictedAction.setToolTipText("show conflicted ids");
        this.filterOnlyConflictedAction.setEnabled(true);
        this.filterOnlyConflictedAction.setChecked(false);
        this.filterOnlyDeletedAction = new Action(){

            public void run() {
                ConflictView.this.updateFilter(ConflictView.this.filterOnlyDeletedAction);
            }
        };
        this.filterOnlyDeletedAction.setText("show deleted");
        this.filterOnlyDeletedAction.setToolTipText("show deleted ids");
        this.filterOnlyDeletedAction.setEnabled(true);
        this.filterOnlyDeletedAction.setChecked(false);
    }

    @Override
    protected void reloadViewState() {
        this.showByIdViewAction.setChecked(false);
        switch (((ConflictViewTreeProvider)((ConflictViewPage)this.activePage).getDataProvider()).getActiveView()) {
            case BY_ID: {
                this.showByIdViewAction.setChecked(true);
                break;
            }
        }
        this.restoreActiveFilter(((ConflictViewPage)this.activePage).getActiveFilter());
        this.restoreActiveSorter(((ConflictViewPage)this.activePage).getActiveSort());
        ((ConflictViewPage)this.activePage).getTreeViewer().refresh();
    }

    protected void updateSorter(IAction action) {
        this.sortByNameAction.setChecked(false);
        this.sortByMergeTypeAction.setChecked(false);
        if (action == this.sortByNameAction) {
            this.sortByNameAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveSort(1);
            ((ConflictViewPage)this.activePage).getTreeViewer().setSorter(((ConflictViewPage)this.activePage).getNameSorter());
        }
        if (action == this.sortByMergeTypeAction) {
            this.sortByMergeTypeAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveSort(0);
            ((ConflictViewPage)this.activePage).getTreeViewer().setSorter(((ConflictViewPage)this.activePage).getTypeSorter());
        }
    }

    private void restoreActiveSorter(int sorter) {
        switch (sorter) {
            case 1: {
                this.sortByNameAction.run();
                break;
            }
            default: {
                this.sortByMergeTypeAction.run();
            }
        }
    }

    protected void updateFilter(IAction action) {
        this.filterNothingAction.setChecked(false);
        this.filterOnlyAddedAction.setChecked(false);
        ((ConflictViewPage)this.activePage).getTreeViewer().removeFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.ADDED));
        this.filterOnlyChangedAction.setChecked(false);
        ((ConflictViewPage)this.activePage).getTreeViewer().removeFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.CHANGED));
        this.filterOnlyDeletedAction.setChecked(false);
        ((ConflictViewPage)this.activePage).getTreeViewer().removeFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.DELETED));
        this.filterOnlyConflictedAction.setChecked(false);
        ((ConflictViewPage)this.activePage).getTreeViewer().removeFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.CONFLICTED));
        if (action == this.filterNothingAction) {
            this.filterNothingAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveFilter(0);
        }
        if (action == this.filterOnlyAddedAction) {
            ((ConflictViewPage)this.activePage).getTreeViewer().addFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.ADDED));
            this.filterOnlyAddedAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveFilter(1);
        }
        if (action == this.filterOnlyChangedAction) {
            ((ConflictViewPage)this.activePage).getTreeViewer().addFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.CHANGED));
            this.filterOnlyChangedAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveFilter(2);
        }
        if (action == this.filterOnlyDeletedAction) {
            ((ConflictViewPage)this.activePage).getTreeViewer().addFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.DELETED));
            this.filterOnlyDeletedAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveFilter(3);
        }
        if (action == this.filterOnlyConflictedAction) {
            ((ConflictViewPage)this.activePage).getTreeViewer().addFilter(((ConflictViewPage)this.activePage).getConflictViewTypeFilter(MergeInformation.MergeType.CONFLICTED));
            this.filterOnlyConflictedAction.setChecked(true);
            ((ConflictViewPage)this.activePage).setActiveFilter(4);
        }
    }

    private void restoreActiveFilter(int filter) {
        switch (filter) {
            case 1: {
                this.filterOnlyAddedAction.run();
                break;
            }
            case 2: {
                this.filterOnlyChangedAction.run();
                break;
            }
            case 3: {
                this.filterOnlyDeletedAction.run();
                break;
            }
            case 4: {
                this.filterOnlyConflictedAction.run();
                break;
            }
            default: {
                this.filterNothingAction.run();
            }
        }
    }

    @Override
    public ConflictViewPage<?, ?, ?> createPage(String pageId, IEditorPart editor) {
        List<PageFactory> pfs = this.getPageFactories();
        for (PageFactory pf : pfs) {
            ConflictViewPage<?, ?, ?> page = pf.createConflictViewPage(pageId, editor);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    @Override
    public String getPageId(IResource res) {
        if (!(res instanceof IFile) || res == null) {
            return null;
        }
        IFile file = (IFile)res;
        String path = file.getRawLocation().toOSString();
        File origFile = new File(path);
        return origFile.getAbsolutePath();
    }

    @Override
    protected void initView(Composite parent) {
    }
}

