/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.views;

import de.jabc.cinco.meta.plugin.mcam.runtime.views.McamView;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.PageFactory;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.CheckViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.provider.CheckViewTreeProvider;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.ResourceChangeListener;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;

public class CheckView
extends McamView<CheckViewPage> {
    public static final String ID = "de.jabc.cinco.meta.plugin.mcam.runtime.views.CheckView";
    protected ResourceChangeListener resourceChangeListener;
    private IAction showByModuleViewAction;
    private IAction showByIdViewAction;
    private IAction showNonErrorsAction;
    private IAction showCheckPerformanceAction;
    private IAction stopAtFirstErrorAction;

    @Override
    protected void initView(Composite parent) {
        this.resourceChangeListener = new ResourceChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager filterSubmenu = new MenuManager("Filters");
        filterSubmenu.add(this.showNonErrorsAction);
        MenuManager viewSubmenu = new MenuManager("Views");
        viewSubmenu.add(this.showByModuleViewAction);
        viewSubmenu.add(this.showByIdViewAction);
        manager.add((IContributionItem)filterSubmenu);
        manager.add((IContributionItem)viewSubmenu);
        manager.add(this.showCheckPerformanceAction);
        manager.add(this.stopAtFirstErrorAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.openModelAction);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.expandAllAction);
        manager.add(this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.showByIdViewAction = new Action(){

            public void run() {
                ((CheckViewTreeProvider)((CheckViewPage)CheckView.this.activePage).getDataProvider()).setActiveView(CheckViewTreeProvider.ViewType.BY_ID);
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().setInput((Object)CheckView.this.getViewSite());
                CheckView.this.reloadViewState();
            }
        };
        this.showByIdViewAction.setText("by entity");
        this.showByIdViewAction.setToolTipText("show results by entity");
        this.showByIdViewAction.setChecked(false);
        this.showByModuleViewAction = new Action(){

            public void run() {
                ((CheckViewTreeProvider)((CheckViewPage)CheckView.this.activePage).getDataProvider()).setActiveView(CheckViewTreeProvider.ViewType.BY_MODULE);
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().setInput((Object)CheckView.this.getViewSite());
                CheckView.this.reloadViewState();
            }
        };
        this.showByModuleViewAction.setText("by module");
        this.showByModuleViewAction.setToolTipText("show results by module");
        this.showByModuleViewAction.setChecked(false);
        this.showNonErrorsAction = new Action(){

            public void run() {
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().removeFilter((ViewerFilter)((CheckViewPage)CheckView.this.activePage).getResultTypeFilter());
                ((CheckViewPage)CheckView.this.activePage).getResultTypeFilter().switchShowNonErrors();
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().addFilter((ViewerFilter)((CheckViewPage)CheckView.this.activePage).getResultTypeFilter());
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().setInput((Object)CheckView.this.getViewSite());
                CheckView.this.reloadViewState();
            }
        };
        this.showNonErrorsAction.setText("show non-errors");
        this.showNonErrorsAction.setToolTipText("show warnings and less important entries");
        this.showNonErrorsAction.setChecked(true);
        this.showCheckPerformanceAction = new Action(){

            public void run() {
                ((CheckViewPage)CheckView.this.activePage).getLabelProvider().setShowPerformance(!((CheckViewPage)CheckView.this.activePage).getLabelProvider().isShowPerformance());
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().refresh(true);
                CheckView.this.reloadViewState();
            }
        };
        this.showCheckPerformanceAction.setText("show check perfomance");
        this.showCheckPerformanceAction.setToolTipText("show check perfomance");
        this.showCheckPerformanceAction.setChecked(false);
        this.stopAtFirstErrorAction = new Action(){

            public void run() {
                ((CheckViewPage)CheckView.this.activePage).getCheckConfiguration().switchStopAtFirstError();
                ((CheckViewPage)CheckView.this.activePage).getTreeViewer().refresh(true);
                CheckView.this.reloadViewState();
            }
        };
        this.stopAtFirstErrorAction.setText("stop at first error");
        this.stopAtFirstErrorAction.setToolTipText("stop at first error");
        this.stopAtFirstErrorAction.setChecked(false);
    }

    @Override
    protected void reloadViewState() {
        this.showByIdViewAction.setChecked(false);
        this.showByModuleViewAction.setChecked(false);
        this.showNonErrorsAction.setChecked(((CheckViewPage)this.activePage).getResultTypeFilter().isShowNonErrors());
        this.showCheckPerformanceAction.setChecked(((CheckViewPage)this.activePage).getLabelProvider().isShowPerformance());
        this.stopAtFirstErrorAction.setChecked(((CheckViewPage)this.activePage).getCheckConfiguration().isStopAtFirstError());
        switch (((CheckViewTreeProvider)((CheckViewPage)this.activePage).getDataProvider()).getActiveView()) {
            case BY_ID: {
                this.showByIdViewAction.setChecked(true);
                break;
            }
            case BY_MODULE: {
                this.showByModuleViewAction.setChecked(true);
                break;
            }
        }
    }

    @Override
    public CheckViewPage<?, ?, ?> createPage(String id, IEditorPart editor) {
        List<PageFactory> pfs = this.getPageFactories();
        for (PageFactory pf : pfs) {
            CheckViewPage<?, ?, ?> page = pf.createCheckViewPage(id, editor);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        super.dispose();
    }

    @Override
    public String getPageId(IResource res) {
        if (!(res instanceof IFile) || res == null) {
            return null;
        }
        IFile file = (IFile)res;
        String path = file.getRawLocation().toOSString();
        File origFile = new File(path);
        return origFile.getAbsolutePath();
    }
}

