/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.core;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.ChangeDeadlockException;
import info.scce.mcam.framework.adapter.EntityId;
import info.scce.mcam.framework.adapter.ModelAdapter;
import info.scce.mcam.framework.modules.ChangeModule;
import info.scce.mcam.framework.processes.MergeInformation;
import info.scce.mcam.framework.strategies.merge.MergeStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class _CincoMergeStrategy<E extends EntityId, M extends ModelAdapter<E>>
implements MergeStrategy<E, M> {
    public void execute(M model, Collection<MergeInformation<E, M>> mergeInformations) {
        try {
            this.executeChanges(model, mergeInformations, false);
        }
        catch (ChangeDeadlockException e) {
            System.err.println(e.getMessage());
        }
    }

    private ArrayList<ChangeModule<E, M>> getChangesFromMergeInformationList(Collection<MergeInformation<E, M>> mergeInformations, boolean includeConflicted) {
        ArrayList<ChangeModule<ChangeModule, M>> changes = new ArrayList<ChangeModule<ChangeModule, M>>();
        for (MergeInformation<E, M> mergeInformation : mergeInformations) {
            for (ChangeModule changeModule : mergeInformation.getLocalChanges()) {
                if (mergeInformation.isConflictedChange(changeModule) && !includeConflicted) continue;
                changes.add(changeModule);
            }
            for (ChangeModule changeModule : mergeInformation.getRemoteChanges()) {
                if (mergeInformation.isConflictedChange(changeModule) && !includeConflicted) continue;
                changes.add(changeModule);
            }
        }
        return changes;
    }

    public List<ChangeModule<E, M>> executeChanges(M model, Collection<MergeInformation<E, M>> mergeInformations, boolean includeConflicted) throws ChangeDeadlockException {
        ArrayList<ChangeModule<E, M>> changesToDo = this.getChangesFromMergeInformationList(mergeInformations, includeConflicted);
        this.runPreExecutePhase(model, new ArrayList<ChangeModule<E, M>>(changesToDo));
        this.runExecutePhase(model, new ArrayList<ChangeModule<E, M>>(changesToDo));
        this.runPostExecutePhase(model, new ArrayList<ChangeModule<E, M>>(changesToDo));
        return changesToDo;
    }

    public void runExecutePhase(M model, List<ChangeModule<E, M>> changesToDo) throws ChangeDeadlockException {
        ArrayList<ChangeModule<E, M>> changesDone = new ArrayList<ChangeModule<E, M>>();
        while (!changesToDo.isEmpty()) {
            boolean somethingDone = false;
            for (ChangeModule<E, M> change : changesToDo) {
                if (!change.canExecute(model)) continue;
                change.execute(model);
                changesDone.add(change);
                somethingDone = true;
            }
            changesToDo.removeAll(changesDone);
            if (somethingDone) continue;
            throw new ChangeDeadlockException("All canExecute-Methods fail. Couldn't do anything!");
        }
    }

    public void runPreExecutePhase(M model, List<ChangeModule<E, M>> changesToDo) throws ChangeDeadlockException {
        ArrayList<ChangeModule<E, M>> changesDone = new ArrayList<ChangeModule<E, M>>();
        while (!changesToDo.isEmpty()) {
            boolean somethingDone = false;
            for (ChangeModule<E, M> change : changesToDo) {
                if (!change.canPreExecute(model)) continue;
                change.preExecute(model);
                changesDone.add(change);
                somethingDone = true;
            }
            changesToDo.removeAll(changesDone);
            if (somethingDone) continue;
            throw new ChangeDeadlockException("All canPreExecute-Methods fail. Couldn't do anything!");
        }
    }

    public void runPostExecutePhase(M model, List<ChangeModule<E, M>> changesToDo) throws ChangeDeadlockException {
        ArrayList<ChangeModule<E, M>> changesDone = new ArrayList<ChangeModule<E, M>>();
        while (!changesToDo.isEmpty()) {
            boolean somethingDone = false;
            for (ChangeModule<E, M> change : changesToDo) {
                if (!change.canPostExecute(model)) continue;
                change.postExecute(model);
                changesDone.add(change);
                somethingDone = true;
            }
            changesToDo.removeAll(changesDone);
            if (somethingDone) continue;
            throw new ChangeDeadlockException("All canPostExecute-Methods fail. Couldn't do anything!");
        }
    }
}

