/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.mcam.runtime.core;

import de.jabc.cinco.meta.plugin.mcam.runtime.core._CincoId;
import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import info.scce.mcam.framework.adapter.ModelAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public abstract class _CincoAdapter<T extends _CincoId, M extends GraphModel>
extends CincoRuntimeBaseClass
implements ModelAdapter<T> {
    protected M model = null;
    protected Diagram diagram = null;
    protected Resource resource = null;
    protected String modelName = "";
    protected String path = "";

    public List<T> getEntityIds() {
        ArrayList<T> ids = new ArrayList<T>();
        T id = this.createId((IdentifiableElement)this.getModel());
        ((_CincoId)id).setElement((IdentifiableElement)this.getModel());
        ids.add(id);
        TreeIterator it = this.getModel().getInternalElement_().eAllContents();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ModelElement)) continue;
            ModelElement me = (ModelElement)obj;
            id = this.createId((IdentifiableElement)me);
            ((_CincoId)id).setElement((IdentifiableElement)me);
            String label = this.getLabel(me);
            if (label != null) {
                ((_CincoId)id).setLabel(label);
            }
            ids.add(id);
        }
        return ids;
    }

    public M getModel() {
        if (this.model == null || this.model.eResource() == null) {
            this.readModelFromResource();
        }
        if (this.model == null) {
            throw new RuntimeException("model is null");
        }
        return this.model;
    }

    public Diagram getDiagram() {
        if (this.diagram == null || this.diagram.eResource() == null) {
            this.readDiagramFromResource();
        }
        if (this.diagram == null) {
            throw new RuntimeException("diagram is null");
        }
        return this.diagram;
    }

    public void setModel(M model) {
        this.model = model;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public EObject searchElementById(T id) {
        if (((_CincoId)id).getId().equals(this.getModel().getId())) {
            return this.getModel();
        }
        for (ModelElement el : this._graphModelExtension.find(this.getModel(), ModelElement.class)) {
            if (!el.getId().equals(((_CincoId)id).getId())) continue;
            return el;
        }
        throw new RuntimeException("Could not find element for '" + id + "'");
    }

    public T getIdByString(String idString) {
        for (_CincoId id : this.getEntityIds()) {
            if (!idString.equals(id.getId())) continue;
            return (T)id;
        }
        throw new RuntimeException("Could not find id for '" + idString + "'");
    }

    public String getModelName() {
        return this.modelName;
    }

    public void readModel(Resource resource, File file) {
        this.modelName = file.getName();
        this.path = file.getPath();
        this.resource = resource;
    }

    public void readModel(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        if (this.resource == null) {
            throw new RuntimeException("resource is null");
        }
        return this.resource;
    }

    private void readDiagramFromResource() {
        for (EObject obj : this.getResource().getContents()) {
            if (!"Diagram".equals(obj.eClass().getName())) continue;
            this.diagram = (Diagram)obj;
        }
    }

    public void writeModel(File arg0) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("${GraphModelExtension}", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createFileURI((String)arg0.getAbsolutePath()));
        resource.getContents().add((Object)this.getDiagram());
        resource.getContents().add(this.getModel());
        try {
            resource.save(Collections.EMPTY_MAP);
            this.path = arg0.getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilePath() {
        return this.path;
    }

    protected void readModelFromResource() {
        this.model = this._resourceExtension.getGraphModel(this.getResource());
    }

    protected abstract T createId(IdentifiableElement var1);

    public abstract String getLabel(ModelElement var1);

    public void highlightElement(T id) {
        IdentifiableElement element = ((_CincoId)id).getElement();
        if (element instanceof ModelElement) {
            ((ModelElement)element).highlight();
        }
    }

    public abstract void readModel(File var1);
}

