/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.deployment.view;

import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import info.scce.dime.property.DimeProperties;
import info.scce.dime.ui.deployment.DeploymentStateEnum;
import info.scce.dime.ui.deployment.EnvironmentFactory;
import info.scce.dime.ui.deployment.ProjectFactory;
import info.scce.dime.ui.deployment.handler.ApplicationDeployment;
import info.scce.dime.ui.deployment.handler.DeploymentHandler;
import info.scce.dime.ui.deployment.handler.DeploymentObserverInterface;
import info.scce.dime.ui.deployment.handler.RuntimeEnvironmentDeployment;
import info.scce.dime.ui.deployment.os.DefaultOperatingSystemDetector;
import info.scce.dime.ui.deployment.os.DefaultOperatingSystemName;
import info.scce.dime.ui.deployment.view.Workspace;
import info.scce.dime.ui.deployment.view.WorkspaceListener;
import info.scce.gantry.Environment;
import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class DeploymentView
extends ViewPart
implements DeploymentObserverInterface {
    private final Workspace workspace;
    private DeploymentHandler deploymentHandler;
    private final WorkspaceListener workspaceListener;
    public static final String ID = "info.scce.dime.ui.deployment.view.DeploymentView";
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final String runtimeEnvironmentStart = "Start";
    private final String runtimeEnvironmentStop = "Stop";
    private Button buttonRuntimeEnvironment;
    private Button buttonRedeployApplication;
    private Button buttonPurgeApplication;
    private Label labelRuntimeEnvironmentState;
    private Label labelApplicationState;
    private Image processing = ResourceManager.getPluginImage("info.scce.dime.ui.deployment", "resources/icons/processing.png");
    private Image running = ResourceManager.getPluginImage("info.scce.dime.ui.deployment", "resources/icons/running.png");
    private Image stopped = ResourceManager.getPluginImage("info.scce.dime.ui.deployment", "resources/icons/stopped.png");
    private Image docker = ResourceManager.getPluginImage("info.scce.dime.ui.deployment", "resources/icons/docker.png");
    private Image warning = ResourceManager.getPluginImage("info.scce.dime.ui.deployment", "resources/icons/warning32.png");
    private Label appNameLabel;
    private Label workingDirLabel;
    private Link linkApplication;
    private ScrolledComposite scrolledComposite;
    private RuntimeEnvironmentDeployment runtimeEnvironmentDeployment;
    private ApplicationDeployment applicationDeployment;
    private Environment environment;

    public DeploymentView() {
        this.workspace = new Workspace(new FileExtension(), new WorkspaceExtension());
        this.workspaceListener = new WorkspaceListener(){

            @Override
            void onProjectChanged(IProject project) {
                DeploymentView.this.disposeEnvironment();
                try {
                    try {
                        DeploymentView.this.initEnvironment();
                        DeploymentView.this.startListener();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize environment", e);
                    }
                }
                finally {
                    DeploymentView.this.updateUI();
                }
            }
        };
        this.workspace.registerListener(this.workspaceListener);
    }

    private void initEnvironment() {
        ProjectFactory projectFactory = new ProjectFactory(new DefaultOperatingSystemDetector(new DefaultOperatingSystemName()), this.workspace, "target");
        EnvironmentFactory environmentFactory = new EnvironmentFactory(projectFactory);
        try {
            this.environment = environmentFactory.environment();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create DeplyomentView", e);
        }
        this.runtimeEnvironmentDeployment = new RuntimeEnvironmentDeployment(this, Arrays.asList(this.environment.container("postgres"), this.environment.container("mailcatcher")));
        this.applicationDeployment = new ApplicationDeployment(this, Arrays.asList(this.environment.container("wildfly")));
        this.deploymentHandler = new DeploymentHandler(this, this.runtimeEnvironmentDeployment, this.applicationDeployment);
        this.workspace.loadDimeProperties();
    }

    public void createPartControl(Composite parent) {
        try {
            this.initEnvironment();
            this.environment.checkPreconditions();
        }
        catch (Environment.EnvironmentException e) {
            throw new RuntimeException("The Deployment View is not supported on a runtime environment without Docker", e);
        }
        this.startListener();
        this.drawComponents(parent);
        this.createActions();
        this.setStateRuntimeEnvironmentStopped();
    }

    public void setFocus() {
    }

    @Override
    public void updateRuntimeEnvironment(DeploymentStateEnum state) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            switch (state) {
                case RUNNING: {
                    this.setStateRuntimeEnvrionmentRunning();
                    break;
                }
                case PROCESSING: {
                    this.setStateRuntimeEnvironmentProcessing();
                    break;
                }
                case STOPPED: {
                    this.setStateRuntimeEnvironmentStopped();
                    break;
                }
            }
        });
    }

    @Override
    public void updateApplication(DeploymentStateEnum state) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            switch (state) {
                case RUNNING: {
                    this.setStateApplicationRunning();
                    break;
                }
                case PROCESSING: {
                    this.setStateApplicationProcessing();
                    break;
                }
                case STOPPED: {
                    this.setStateApplicationStopped();
                    break;
                }
            }
        });
    }

    public void disposeEnvironment() {
        this.runtimeEnvironmentDeployment.deleteObserver(this);
        this.runtimeEnvironmentDeployment.quit();
        this.applicationDeployment.deleteObserver(this);
        this.applicationDeployment.quit();
    }

    public void dispose() {
        this.disposeEnvironment();
        this.workspace.unregisterListener(this.workspaceListener);
        this.toolkit.dispose();
        super.dispose();
    }

    public void handlePurgeApplicationSelection() {
        this.deploymentHandler.purgeAndDeploy();
    }

    public void disableButtons() {
        this.setEnable(false, this.buttonPurgeApplication, this.buttonRedeployApplication, this.buttonRuntimeEnvironment);
    }

    public void enableButtons() {
        this.setEnable(true, this.buttonPurgeApplication, this.buttonRedeployApplication, this.buttonRuntimeEnvironment);
    }

    private void drawComponents(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        this.toolkit.adapt((Composite)this.scrolledComposite);
        this.toolkit.paintBordersFor((Composite)this.scrolledComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite container = this.toolkit.createComposite((Composite)this.scrolledComposite, 2048);
        this.toolkit.paintBordersFor(container);
        container.setLayout((Layout)new GridLayout(4, false));
        Label logoLabel = new Label(container, 0x1000020);
        logoLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 2));
        logoLabel.setImage(this.docker);
        this.toolkit.adapt((Control)logoLabel, true, true);
        Label labelRuntimeEnvironment = new Label(container, 0);
        labelRuntimeEnvironment.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelRuntimeEnvironment.setAlignment(131072);
        labelRuntimeEnvironment.setFont(SWTResourceManager.getFont("Noto Sans", 12, 0));
        labelRuntimeEnvironment.setBounds(0, 0, 100, 17);
        this.toolkit.adapt((Control)labelRuntimeEnvironment, true, true);
        labelRuntimeEnvironment.setText("Runtime Environment:");
        this.labelRuntimeEnvironmentState = new Label(container, 0);
        GridData labelRuntimeEnvironmentStateGrid = new GridData(4, 4, true, false, 1, 1);
        labelRuntimeEnvironmentStateGrid.widthHint = 80;
        this.labelRuntimeEnvironmentState.setLayoutData((Object)labelRuntimeEnvironmentStateGrid);
        this.toolkit.adapt((Control)this.labelRuntimeEnvironmentState, true, true);
        this.buttonRuntimeEnvironment = new Button(container, 0);
        this.buttonRuntimeEnvironment.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.buttonRuntimeEnvironment.setBounds(0, 0, 63, 17);
        this.buttonRuntimeEnvironment.setText("Start");
        this.buttonRuntimeEnvironment.setFont(SWTResourceManager.getFont("Noto Sans", 12, 0));
        this.toolkit.adapt((Control)this.buttonRuntimeEnvironment, true, true);
        Label labelApplication = new Label(container, 0);
        labelApplication.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelApplication.setAlignment(131072);
        labelApplication.setBounds(0, 0, 100, 17);
        labelApplication.setFont(SWTResourceManager.getFont("Noto Sans", 12, 0));
        labelApplication.setText("Deployment State:");
        this.toolkit.adapt((Control)labelApplication, true, true);
        this.labelApplicationState = new Label(container, 0);
        GridData labelApplicationStateGrid = new GridData(4, 4, true, false, 1, 1);
        labelApplicationStateGrid.widthHint = 80;
        this.labelApplicationState.setLayoutData((Object)labelApplicationStateGrid);
        this.toolkit.adapt((Control)this.labelApplicationState, true, true);
        this.buttonRedeployApplication = new Button(container, 0);
        this.buttonRedeployApplication.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.buttonRedeployApplication.setBounds(0, 0, 63, 31);
        this.buttonRedeployApplication.setText("Redeploy");
        this.buttonRedeployApplication.setFont(SWTResourceManager.getFont("Noto Sans", 12, 0));
        this.toolkit.adapt((Control)this.buttonRedeployApplication, true, true);
        Label labelDataModel = new Label(container, 0);
        labelDataModel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        labelDataModel.setImage(this.warning);
        labelDataModel.setFont(SWTResourceManager.getFont("Noto Sans", 10, 1));
        labelDataModel.setBounds(0, 0, 0, 17);
        this.toolkit.adapt((Control)labelDataModel, true, true);
        Label labelDataModelState = new Label(container, 64);
        GridData labelDataModelStateGrid = new GridData(4, 0x1000000, true, false, 2, 1);
        labelDataModelStateGrid.widthHint = 80;
        labelDataModelState.setLayoutData((Object)labelDataModelStateGrid);
        labelDataModelState.setBounds(0, 0, 100, 34);
        labelDataModelState.setText("If you have made major changes (e.g deletion of data types) use the \"Purge and Deploy\" action!");
        labelDataModelState.setFont(SWTResourceManager.getFont("Noto Sans", 10, 0));
        this.toolkit.adapt((Control)labelDataModelState, true, true);
        this.buttonPurgeApplication = new Button(container, 0);
        this.buttonPurgeApplication.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.buttonPurgeApplication.setBounds(0, 0, 111, 31);
        this.buttonPurgeApplication.setText("Purge and Deploy");
        this.buttonPurgeApplication.setFont(SWTResourceManager.getFont("Noto Sans", 12, 0));
        this.toolkit.adapt((Control)this.buttonPurgeApplication, true, true);
        Label separator = new Label(container, 266);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        separator.setBounds(0, 0, 0, 3);
        this.toolkit.adapt((Control)separator, true, true);
        this.appNameLabel = new Label(container, 0);
        this.appNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.appNameLabel.setFont(SWTResourceManager.getFont("Noto Sans", 10, 0));
        this.appNameLabel.setText("App: " + this.appName());
        this.appNameLabel.setBounds(0, 0, 0, 17);
        this.toolkit.adapt((Control)this.appNameLabel, true, true);
        this.workingDirLabel = new Label(container, 0);
        this.workingDirLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.workingDirLabel.setFont(SWTResourceManager.getFont("Noto Sans", 10, 0));
        this.workingDirLabel.setText("Working Directory: " + this.targetFolder());
        this.workingDirLabel.setBounds(0, 0, 0, 17);
        this.toolkit.adapt((Control)this.workingDirLabel, true, true);
        this.linkApplication = new Link(container, 0);
        this.linkApplication.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.linkApplication.setFont(SWTResourceManager.getFont("Noto Sans", 10, 0));
        this.linkApplication.setText("URL: <A>" + DimeProperties.getAppURL() + "</A>");
        this.linkApplication.setBounds(0, 0, 0, 17);
        this.toolkit.adapt((Control)this.linkApplication, true, true);
        this.scrolledComposite.setContent((Control)container);
        this.scrolledComposite.setMinSize(container.computeSize(-1, 180));
    }

    private String appName() {
        String appName;
        block3: {
            appName = null;
            try {
                appName = this.workspace.appName();
            }
            catch (Exception e) {
                appName = "<unknown>";
                if (e.getMessage() == null || e.getMessage().trim().isEmpty()) break block3;
                appName = String.valueOf(appName) + " (" + e.getMessage() + ")";
            }
        }
        if (appName == null || appName.trim().isEmpty()) {
            appName = "<unnamed>";
        }
        return appName;
    }

    private String targetFolder() {
        String pathName;
        block3: {
            pathName = null;
            try {
                File targetFolder = this.workspace.targetFolder();
                IPath location = Path.fromOSString((String)targetFolder.getAbsolutePath());
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
                pathName = iFile.getFullPath().toOSString();
            }
            catch (Exception e) {
                pathName = "<unknown>";
                if (e.getMessage() != null && !e.getMessage().isEmpty()) break block3;
                pathName = String.valueOf(pathName) + " (" + e.getMessage() + ")";
            }
        }
        if (pathName == null || pathName.trim().isEmpty()) {
            pathName = "<unknown>";
        }
        return pathName;
    }

    private void startListener() {
        this.runtimeEnvironmentDeployment.start();
        this.applicationDeployment.start();
    }

    private void handleRuntimeEnvSelection() {
        if (this.buttonRuntimeEnvironment.getText().equals("Stop")) {
            this.deploymentHandler.stop();
        } else {
            this.deploymentHandler.start();
        }
    }

    private void handleDeploySelection() {
        this.setEnable(false, this.buttonPurgeApplication, this.buttonRuntimeEnvironment);
        this.deploymentHandler.redeploy();
        this.setEnable(true, this.buttonPurgeApplication, this.buttonRuntimeEnvironment);
    }

    private void setEnable(boolean enbl, Button ... btns) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Button[] buttonArray2 = btns;
            int n = btns.length;
            int n2 = 0;
            while (n2 < n) {
                Button b = buttonArray2[n2];
                b.setEnabled(enbl);
                ++n2;
            }
        });
    }

    private void createActions() {
        this.linkApplication.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonRuntimeEnvironment.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentView.this.handleRuntimeEnvSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonRedeployApplication.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentView.this.handleDeploySelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonPurgeApplication.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentView.this.handlePurgeApplicationSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setStateRuntimeEnvironmentStopped() {
        this.asnyc(() -> {
            this.buttonRuntimeEnvironment.setText("Start");
            this.labelRuntimeEnvironmentState.setImage(this.stopped);
            this.setEnable(false, this.buttonRedeployApplication);
            this.setEnable(true, this.buttonRuntimeEnvironment, this.buttonPurgeApplication);
            this.buttonRuntimeEnvironment.setText("Start");
        });
    }

    private void setStateRuntimeEnvironmentProcessing() {
        this.asnyc(() -> {
            this.labelRuntimeEnvironmentState.setImage(this.processing);
            this.setEnable(false, this.buttonRuntimeEnvironment, this.buttonPurgeApplication, this.buttonRedeployApplication);
        });
    }

    private void setStateRuntimeEnvrionmentRunning() {
        this.asnyc(() -> {
            this.labelRuntimeEnvironmentState.setImage(this.running);
            this.buttonRuntimeEnvironment.setText("Stop");
            this.setEnable(true, this.buttonRuntimeEnvironment, this.buttonRedeployApplication);
        });
    }

    private void setStateApplicationStopped() {
        this.asnyc(() -> {
            this.labelApplicationState.setImage(this.stopped);
            this.linkApplication.setEnabled(false);
        });
    }

    private void setStateApplicationProcessing() {
        this.asnyc(() -> {
            this.labelApplicationState.setImage(this.processing);
            this.linkApplication.setEnabled(false);
        });
    }

    private void setStateApplicationRunning() {
        this.asnyc(() -> {
            this.labelApplicationState.setImage(this.running);
            this.linkApplication.setEnabled(true);
        });
    }

    private void updateUI() {
        this.updateAppNameLabel();
        this.updateWorkingDirLabel();
        this.setStateRuntimeEnvironmentStopped();
        this.setStateApplicationStopped();
    }

    private void updateAppNameLabel() {
        String appName = this.appName();
        this.asnyc(() -> this.appNameLabel.setText("App: " + appName));
    }

    private void updateWorkingDirLabel() {
        String targetFolder = this.targetFolder();
        this.asnyc(() -> this.workingDirLabel.setText("Working Directory: " + targetFolder));
    }

    private void asnyc(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }
}

