/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.deployment.handler.threads;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CModelElement;
import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GeneratorDiscription;
import de.jabc.cinco.meta.plugin.generator.runtime.registry.GraphModelGeneratorRegistry;
import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import graphmodel.GraphModel;
import info.scce.dime.dad.dad.DAD;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AppGenerateThread {
    protected WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    protected FileExtension _fileExtension = new FileExtension();
    protected ResourceExtension _resourceExtension = new ResourceExtension();
    public DAD dad;
    public IStatus dadStatus;
    private String jobName = "Code Generator Job";
    private final String errorPrefix = "Model code generation failed with error:\n";
    private GeneratorDiscription<GraphModel> generatorDescription;

    public IStatus getStatus() {
        return this.dadStatus;
    }

    public void prepare() {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            this.getDADForActiveEditor();
            if (this.dad == null) {
                this.searchForDad();
            }
        });
    }

    public CompoundJob getGeneratorJob() {
        CompoundJob job = JobFactory.job((String)"Code Generation", (boolean)false);
        job.consume(100, "Initializing...").task("Retrieve DAD model", () -> this.prepare()).task("Retrieve generator", this::retrieveGenerator).cancelIf(this::isGeneratorMissing, "Failed to retrieve generator.\n\nEither this type of model is not associated with a generator or something went seriously wrong. In the latter case, try to restart the application.");
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IStatus result = job.getResult();
        if (result.getSeverity() != 0) {
            return null;
        }
        job = JobFactory.job((String)"Code Generation").label("Generating for model " + this.dad.getAppName() + " ...");
        this.generatorDescription.getGenerator().collectTasks((GraphModel)this.dad, this.getOutlet(), job);
        return job;
    }

    private void retrieveGenerator() {
        try {
            Class<?> clazz = this.dad instanceof CModelElement ? this.dad.getClass().getSuperclass() : this.dad.getClass();
            String graphModelClassName = clazz.getName().replace("Impl", "").replace(".impl", "");
            List generatorDescriptions = GraphModelGeneratorRegistry.INSTANCE.getAllGenerators(graphModelClassName);
            if (generatorDescriptions != null && !generatorDescriptions.isEmpty()) {
                this.generatorDescription = (GeneratorDiscription)generatorDescriptions.get(0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve generator.", e);
        }
    }

    private boolean isGeneratorMissing() {
        return this.generatorDescription == null || this.generatorDescription.getGenerator() == null;
    }

    private IPath getOutlet() {
        URI uri = this.dad.eResource().getURI();
        IResource iRes = ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
        if (iRes != null) {
            return iRes.getProject().getLocation().append("target").append("dywa-app");
        }
        return null;
    }

    private void getDADForActiveEditor() {
        DAD eObject;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nWorkbench window is null");
            return;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nPage is null");
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nNo DAD Model found! Open the \"todo.dad\" file!");
            return;
        }
        Resource res = this.getResource(editor);
        if (res != null && (eObject = (DAD)this._resourceExtension.getGraphModel(res, DAD.class)) != null) {
            this.dad = eObject;
            this.dadStatus = Status.OK_STATUS;
            return;
        }
        this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nNo DAD Model found! Open the \"todo.dad\" file!");
    }

    private void searchForDad() {
        List files = this._workspaceExtension.getFiles((IContainer)this._workspaceExtension.getWorkspaceRoot(), f -> f.getName().endsWith(".dad"));
        if (files.size() == 1) {
            IFile dadFile = (IFile)files.get(0);
            DAD dadModel = (DAD)this._fileExtension.getGraphModel(dadFile, DAD.class);
            if (dadModel == null) {
                this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nCould not load DAD model from file :\"" + dadFile + "\"");
            } else {
                this.dadStatus = Status.OK_STATUS;
                this.dad = dadModel;
            }
        } else {
            this.dadStatus = new Status(4, this.jobName, "Model code generation failed with error:\nFound \"" + files.size() + "\" .dad files.");
        }
    }

    private Resource getResource(IEditorPart editor) {
        EditingDomain ed = this.getEditingDomain(editor);
        if (ed != null) {
            return (Resource)ed.getResourceSet().getResources().get(0);
        }
        return null;
    }

    private EditingDomain getEditingDomain(IEditorPart editor) {
        return editor instanceof IEditingDomainProvider ? ((IEditingDomainProvider)editor).getEditingDomain() : (editor instanceof DiagramEditor ? ((DiagramEditor)editor).getEditingDomain() : null);
    }
}

