/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.deployment.handler;

import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.ui.deployment.handler.AbstractDeployment;
import info.scce.dime.ui.deployment.handler.ApplicationDeployment;
import info.scce.dime.ui.deployment.handler.RuntimeEnvironmentDeployment;
import info.scce.dime.ui.deployment.handler.threads.AppGenerateThread;
import info.scce.dime.ui.deployment.view.DeploymentView;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeploymentHandler {
    private final DeploymentView deploymentView;
    private Display display;
    private final AbstractDeployment runtimeEnvironmentDeployment;
    private final AbstractDeployment applicationDeployment;

    public DeploymentHandler(DeploymentView deploymentView, RuntimeEnvironmentDeployment runtimeEnvironmentDeployment, ApplicationDeployment applicationDeployment) {
        this.deploymentView = deploymentView;
        this.runtimeEnvironmentDeployment = runtimeEnvironmentDeployment;
        this.applicationDeployment = applicationDeployment;
    }

    public void start() {
        JobFactory.job((String)"Starting runtime environment", (boolean)false).consume(20).task(() -> this.deploymentView.disableButtons()).task(this::runtimeEnvironmentStart).onFinished(() -> this.showInfoMessage("Runtime environment started", "Runtime environment started.")).onFailed(() -> this.showErrorMessage("Error starting Runtime environment", "Error starting Runtime environment.")).onDone(() -> this.deploymentView.enableButtons()).schedule();
    }

    public void stop() {
        JobFactory.job((String)"Stoping runtime environment", (boolean)false).cancelOnFail(true).consume(20).task(() -> this.deploymentView.disableButtons()).task(this::applicationStop).task(this::runtimeEnvironmentStop).task(this::applicationRemove).task(this::runtimeEnvironmentRemove).onFailedShowMessage("Runtime environment stop failed.").onFinishedShowMessage("Runtime environment stopped successfully").onDone(() -> this.deploymentView.enableButtons()).schedule();
    }

    public void redeploy() {
        JobFactory.job((String)"Redeploy Application", (boolean)false).consume(20).task(() -> this.deploymentView.disableButtons()).task("Stopping web application", this::applicationStop).task("Removing web application", this::applicationRemove).task("Generating model code", this::generateCode).task("Refreshing workspace", this::refreshWorkspace).task("Starting web application", this::applicationStart).onFinished(() -> this.showInfoMessage("Success", "Application build finished. Wait until the app is deployed.")).onCanceledShowMessage("Redeploy canceled.").onFailedShowMessage("Redeploy failed.").onDone(() -> this.deploymentView.enableButtons()).schedule();
    }

    public void purgeAndDeploy() {
        JobFactory.job((String)"Purge and redeploy", (boolean)false).consume(20).task(() -> this.deploymentView.disableButtons()).task("Stopping web application", this::applicationStop).task("Purging web application", this::applicationPurge).task("Stopping runtime", this::runtimeEnvironmentStop).task("Purging runtime", this::runtimeEnvironmentPurge).task("Deleting model code", this::appPurge).task("Starting runtime", this::runtimeEnvironmentStart).task("Generating model code", this::generateCode).task("Refreshing workspace", this::refreshWorkspace).task("Starting web application", this::applicationStart).onFinished(() -> this.showInfoMessage("Success", "Purge and Deploy finished. Wait until the app is deployed.")).onCanceledShowMessage("Purge and Deploy canceled.").onFailedShowMessage("Purge and Deploy failed.").onDone(() -> this.deploymentView.enableButtons()).schedule();
    }

    private void refreshWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException("Failed refreshing orkspace", e);
        }
    }

    private void generateCode() {
        CompoundJob job = new AppGenerateThread().getGeneratorJob();
        job.setUser(false);
        job.schedule();
        try {
            job.join();
            IStatus status = job.getResult();
            if (status.getSeverity() == 4) {
                throw new RuntimeException(status.getException());
            }
            if (status.getSeverity() == 8) {
                throw new RuntimeException("Model generation canceled by user");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void appPurge() {
        CompoundJob job = JobFactory.job((String)"Purging app", (boolean)false);
        job.consume(100, "Initializing...").task("Deleting target folder", () -> {
            AppGenerateThread appGen = new AppGenerateThread();
            appGen.prepare();
            DAD dad = appGen.dad;
            if (dad == null) {
                throw new RuntimeException(appGen.dadStatus.getMessage());
            }
            WorkspaceExtension helper = new WorkspaceExtension();
            IProject project = helper.getProject((EObject)dad);
            if (project == null) {
                throw new RuntimeException("Failed to retrieve project of DAD: " + dad);
            }
            IFolder folder = project.getFolder("target");
            if (folder.exists()) {
                try {
                    folder.delete(true, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }).schedule();
        try {
            job.join();
            IStatus status = job.getResult();
            if (status.getSeverity() == 4) {
                throw new RuntimeException(status.getException());
            }
            if (status.getSeverity() == 8) {
                throw new RuntimeException("App purge canceled by user");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void applicationPurge() {
        this.applicationRemove();
        this.applicationDeployment.removeVolumes();
    }

    private void applicationRemove() {
        this.applicationDeployment.removeContainer();
    }

    private void applicationStop() {
        this.applicationDeployment.stopContainer();
    }

    private void applicationStart() {
        this.applicationDeployment.startContainer();
    }

    private void runtimeEnvironmentPurge() {
        this.runtimeEnvironmentRemove();
        this.runtimeEnvironmentDeployment.removeVolumes();
    }

    private void runtimeEnvironmentRemove() {
        this.runtimeEnvironmentDeployment.removeContainer();
    }

    private void runtimeEnvironmentStop() {
        this.runtimeEnvironmentDeployment.stopContainer();
    }

    private void runtimeEnvironmentStart() {
        this.runtimeEnvironmentDeployment.startContainer();
    }

    private void showInfoMessage(String title, String message) {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        this.display.syncExec(() -> MessageDialog.openInformation((Shell)this.display.getActiveShell(), (String)title, (String)message));
    }

    private void showErrorMessage(String title, String message) {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        this.display.syncExec(() -> MessageDialog.openError((Shell)this.display.getActiveShell(), (String)title, (String)message));
    }
}

