/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.deployment.handler;

import de.jabc.cinco.meta.core.utils.job.ReiteratingThread;
import info.scce.dime.ui.deployment.DeploymentStateEnum;
import info.scce.dime.ui.deployment.handler.DeploymentObserverInterface;
import info.scce.gantry.Container;
import info.scce.gantry.ContainerStatus;
import info.scce.gantry.ContainerStatusEnum;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDeployment
extends ReiteratingThread {
    private boolean starting = false;
    private boolean stopping = false;
    private final List<DeploymentObserverInterface> observers = new ArrayList<DeploymentObserverInterface>();
    private final List<Container> containerList;
    protected DeploymentStateEnum deploymentState = DeploymentStateEnum.STOPPED;

    public AbstractDeployment(List<DeploymentObserverInterface> observers, List<Container> containerList) {
        super(1000);
        this.containerList = containerList;
        this.observers.addAll(observers);
    }

    public void startContainer() {
        this.starting = true;
        try {
            this.prepareImages();
            for (Container container : this.containerList) {
                container.start();
            }
        }
        catch (Container.ContainerException e) {
            throw new RuntimeException("We failed starting the application", e);
        }
        this.starting = false;
    }

    public void stopContainer() {
        this.stopping = true;
        try {
            for (Container container : this.containerList) {
                container.stop();
            }
        }
        catch (Container.ContainerException e) {
            throw new RuntimeException("We failed stopping the runtime", e);
        }
        this.stopping = false;
    }

    public void removeContainer() {
        try {
            for (Container container : this.containerList) {
                container.remove();
            }
        }
        catch (Container.ContainerException e) {
            throw new RuntimeException("We failed stopping the runtime", e);
        }
    }

    public void removeVolumes() {
        try {
            for (Container container : this.containerList) {
                container.removeProvidedVolumes();
            }
        }
        catch (Container.ContainerException e) {
            throw new RuntimeException("We failed stopping the runtime", e);
        }
    }

    public void deleteObserver(DeploymentObserverInterface o) {
        this.observers.remove(o);
    }

    protected void prepare() {
        this.deploymentState = this.deploymentStateEnum();
    }

    protected void work() {
        this.deploymentState = this.deploymentStateEnum();
        this.update();
    }

    protected DeploymentStateEnum deploymentStateEnum() {
        try {
            if (this.isProcessing()) {
                return DeploymentStateEnum.PROCESSING;
            }
            if (this.isRunning()) {
                return DeploymentStateEnum.RUNNING;
            }
            return DeploymentStateEnum.STOPPED;
        }
        catch (Container.ContainerException | ContainerStatus.ContainerStatusException e) {
            throw new RuntimeException("We failed determine the deployment state", e);
        }
    }

    protected abstract void updateObserver(DeploymentObserverInterface var1);

    protected void update() {
        for (DeploymentObserverInterface observer : this.observers) {
            this.updateObserver(observer);
        }
    }

    private boolean isRunning() throws ContainerStatus.ContainerStatusException, Container.ContainerException {
        for (Container container : this.containerList) {
            if (!this.isContainerNotRunning(container)) continue;
            return false;
        }
        return true;
    }

    private boolean isContainerNotRunning(Container container) throws Container.ContainerException, ContainerStatus.ContainerStatusException {
        return !container.containerStatus().status().equals((Object)ContainerStatusEnum.RUNNING);
    }

    private boolean isProcessing() {
        return this.starting || this.stopping;
    }

    private void prepareImages() throws Container.ContainerException {
        for (Container container : this.containerList) {
            container.prepareImage();
        }
    }
}

