/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.search.search.gratext;

import com.google.inject.Inject;
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.Transformer;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalPackage;
import info.scce.dime.search.search.gratext.GratextInternalSearch;
import info.scce.dime.search.search.gratext.SearchGratextResource;
import info.scce.dime.search.search.gratext.generator.SearchGratextTransformer;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

class SearchGratextLinkingService
extends DefaultLinkingService {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    Transformer _transformer;

    SearchGratextLinkingService() {
    }

    private void assertTransformer(EObject model) {
        if (model instanceof GratextInternalSearch) {
            this._transformer = (Transformer)SearchGratextResource.transformers.get((Object)model);
        }
    }

    public Transformer getTransformer() {
        if (this._transformer == null) {
            System.err.println("[LinkingService] WARN: transformer is null - creating decoupled instance");
            this._transformer = new SearchGratextTransformer();
        }
        return this._transformer;
    }

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        QualifiedName qualifiedLinkName;
        EObject model = EcoreUtil.getRootContainer((EObject)context);
        this.assertTransformer(model);
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString == null || crossRefString.isEmpty()) {
            return Collections.emptyList();
        }
        IScope scope = this.getScope(context, ref);
        IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString));
        if (eObjectDescription == null) {
            crossRefString = String.valueOf(crossRefString) + "_INTERNAL";
            qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
            eObjectDescription = scope.getSingleElement(qualifiedLinkName);
        }
        if (eObjectDescription != null) {
            EObject eObj = eObjectDescription.getEObjectOrProxy();
            if (!this.isInternal(requiredType) && this.isInternal(eObjectDescription.getEClass())) {
                return Collections.singletonList(this.createNonInternal(eObj));
            }
            return Collections.singletonList(eObj);
        }
        return Collections.emptyList();
    }

    private EObject createNonInternal(EObject internal) {
        InternalIdentifiableElement ime = (InternalIdentifiableElement)internal;
        Transformer transformer = this.getTransformer();
        return transformer.transform(ime, false).getElement();
    }

    private boolean isInternal(EClass type) {
        EClass internal = InternalPackage.Literals.INTERNAL_IDENTIFIABLE_ELEMENT;
        return internal.isSuperTypeOf(type);
    }
}

