/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry.validation;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public abstract class ValidationResult<MESSAGE, FEATURE> {
    private final MESSAGE message;
    private final FEATURE feature;

    public static <MESSAGE, FEATURE> Error<MESSAGE, FEATURE> newError(MESSAGE message, FEATURE feature) {
        return new Error<MESSAGE, FEATURE>(message, feature);
    }

    public static <MESSAGE, FEATURE> Warning<MESSAGE, FEATURE> newWarning(MESSAGE message, FEATURE feature) {
        return new Warning<MESSAGE, FEATURE>(message, feature);
    }

    public static <MESSAGE, FEATURE> Info<MESSAGE, FEATURE> newInfo(MESSAGE message, FEATURE feature) {
        return new Info<MESSAGE, FEATURE>(message, feature);
    }

    public ValidationResult(MESSAGE message, FEATURE feature) {
        this.message = message;
        this.feature = feature;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.feature == null ? other.feature != null : !this.feature.equals(other.feature));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("message", this.message);
        b.add("feature", this.feature);
        return b.toString();
    }

    @Pure
    public MESSAGE getMessage() {
        return this.message;
    }

    @Pure
    public FEATURE getFeature() {
        return this.feature;
    }

    public static class Error<MESSAGE, FEATURE>
    extends ValidationResult<MESSAGE, FEATURE> {
        public Error(MESSAGE message, FEATURE feature) {
            super(message, feature);
        }
    }

    public static class Info<MESSAGE, FEATURE>
    extends ValidationResult<MESSAGE, FEATURE> {
        public Info(MESSAGE message, FEATURE feature) {
            super(message, feature);
        }
    }

    public static class Warning<MESSAGE, FEATURE>
    extends ValidationResult<MESSAGE, FEATURE> {
        public Warning(MESSAGE message, FEATURE feature) {
            super(message, feature);
        }
    }
}

