/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry.validation;

import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.pluginregistry.validation.AbstractMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.IMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.ValidationResult;
import java.util.ArrayList;
import java.util.function.Consumer;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.Edge;
import mgl.GraphModel;
import mgl.MglPackage;
import mgl.Node;
import mgl.NodeContainer;
import mgl.ReferencedType;
import mgl.UserDefinedType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MetaPluginValidator
extends AbstractMetaPluginValidator {
    private static MetaPluginValidator instance;
    private ArrayList<IMetaPluginValidator> validators = new ArrayList();

    public static MetaPluginValidator getInstance() {
        if (instance == null) {
            MetaPluginValidator _metaPluginValidator;
            instance = _metaPluginValidator = new MetaPluginValidator();
        }
        return instance;
    }

    public boolean putValidator(IMetaPluginValidator validator) {
        return this.validators.add(validator);
    }

    @Check
    public void checkMetaPluginRegisteredForAnnotation(Annotation annotation) {
        boolean _not;
        boolean _metaPluginExists = this.metaPluginExists(annotation);
        boolean bl = _not = !_metaPluginExists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotation \"@");
            String _name = annotation.getName();
            _builder.append(_name);
            _builder.append("\" is unknown. Please Register a suitable MetaPlugin or remove annotation.");
            this.error(_builder.toString(), (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidators(final EObject eObj) {
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkAll(eObj);
            }
        };
        Consumer<ValidationResult> _function_1 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                MetaPluginValidator.this.applyResult(it);
            }
        };
        ListExtensions.map(this.validators, (Functions.Function1)_function).forEach(_function_1);
    }

    @Check(value=CheckType.FAST)
    public void checkOnEditValidators(final EObject eObj) {
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnEdit(eObj);
            }
        };
        Consumer<ValidationResult> _function_1 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                MetaPluginValidator.this.applyResult(it);
            }
        };
        ListExtensions.map(this.validators, (Functions.Function1)_function).forEach(_function_1);
    }

    @Check(value=CheckType.NORMAL)
    public void checkOnSaveValidators(final EObject eObj) {
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnSave(eObj);
            }
        };
        Consumer<ValidationResult> _function_1 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                MetaPluginValidator.this.applyResult(it);
            }
        };
        ListExtensions.map(this.validators, (Functions.Function1)_function).forEach(_function_1);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkOnRequestValidators(final EObject eObj) {
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnRequest(eObj);
            }
        };
        Consumer<ValidationResult> _function_1 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                MetaPluginValidator.this.applyResult(it);
            }
        };
        ListExtensions.map(this.validators, (Functions.Function1)_function).forEach(_function_1);
    }

    private boolean metaPluginExists(Annotation annotation) {
        Integer typeID = this.getTypeId(annotation);
        PluginRegistry pr = PluginRegistry.getInstance();
        return typeID != null && !IterableExtensions.isNullOrEmpty(pr.getSuitableMetaPlugins(annotation.getName(), typeID)) || !IterableExtensions.isNullOrEmpty(pr.getSuitableMetaPlugins(annotation.getName()));
    }

    private Integer getTypeId(Annotation annotation) {
        Integer _switchResult = null;
        Annotatable _parent = annotation.getParent();
        boolean _matched = false;
        if (_parent instanceof NodeContainer) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched && _parent instanceof Node) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched && _parent instanceof Edge) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && _parent instanceof GraphModel) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && _parent instanceof UserDefinedType) {
            _matched = true;
            _switchResult = 5;
        }
        if (!_matched && _parent instanceof ReferencedType) {
            _matched = true;
            _switchResult = 6;
        }
        if (!_matched && _parent instanceof Attribute) {
            _matched = true;
            _switchResult = 7;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

