/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry.validation;

import de.jabc.cinco.meta.core.pluginregistry.CPDAnnotation;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.pluginregistry.validation.AbstractCPDMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.IMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.ValidationResult;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import productDefinition.Annotation;
import productDefinition.ProductDefinitionPackage;

public class CPDMetaPluginValidator
extends AbstractCPDMetaPluginValidator {
    private static CPDMetaPluginValidator instance;

    public static CPDMetaPluginValidator getInstance() {
        if (instance == null) {
            CPDMetaPluginValidator _cPDMetaPluginValidator;
            instance = _cPDMetaPluginValidator = new CPDMetaPluginValidator();
        }
        return instance;
    }

    @Check
    public void checkMetaPluginRegisteredForAnnotation(Annotation annotation) {
        boolean _not;
        boolean _metaPluginExists = this.metaPluginExists(annotation);
        boolean bl = _not = !_metaPluginExists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Annotation \"@");
            String _name = annotation.getName();
            _builder.append(_name);
            _builder.append("\" is unknown. Please register a suitable CPD MetaPlugin or remove annotation.");
            this.error(_builder.toString(), (EObject)annotation, (EStructuralFeature)ProductDefinitionPackage.Literals.ANNOTATION__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidators(final EObject eObj) {
        Functions.Function1<CPDAnnotation, IMetaPluginValidator> _function = new Functions.Function1<CPDAnnotation, IMetaPluginValidator>(){

            public IMetaPluginValidator apply(CPDAnnotation it) {
                return it.getValidator();
            }
        };
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function_1 = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkAll(eObj);
            }
        };
        Consumer<ValidationResult> _function_2 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                CPDMetaPluginValidator.this.applyResult(it);
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.map(PluginRegistry.getInstance().getPluginCPDGenerators(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    @Check(value=CheckType.FAST)
    public void checkOnEditValidators(final EObject eObj) {
        Functions.Function1<CPDAnnotation, IMetaPluginValidator> _function = new Functions.Function1<CPDAnnotation, IMetaPluginValidator>(){

            public IMetaPluginValidator apply(CPDAnnotation it) {
                return it.getValidator();
            }
        };
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function_1 = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnEdit(eObj);
            }
        };
        Consumer<ValidationResult> _function_2 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                CPDMetaPluginValidator.this.applyResult(it);
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.map(PluginRegistry.getInstance().getPluginCPDGenerators(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    @Check(value=CheckType.NORMAL)
    public void checkOnSaveValidators(final EObject eObj) {
        Functions.Function1<CPDAnnotation, IMetaPluginValidator> _function = new Functions.Function1<CPDAnnotation, IMetaPluginValidator>(){

            public IMetaPluginValidator apply(CPDAnnotation it) {
                return it.getValidator();
            }
        };
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function_1 = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnSave(eObj);
            }
        };
        Consumer<ValidationResult> _function_2 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                CPDMetaPluginValidator.this.applyResult(it);
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.map(PluginRegistry.getInstance().getPluginCPDGenerators(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkOnRequestValidators(final EObject eObj) {
        Functions.Function1<CPDAnnotation, IMetaPluginValidator> _function = new Functions.Function1<CPDAnnotation, IMetaPluginValidator>(){

            public IMetaPluginValidator apply(CPDAnnotation it) {
                return it.getValidator();
            }
        };
        Functions.Function1<IMetaPluginValidator, ValidationResult> _function_1 = new Functions.Function1<IMetaPluginValidator, ValidationResult>(){

            public ValidationResult apply(IMetaPluginValidator it) {
                return it.checkOnRequest(eObj);
            }
        };
        Consumer<ValidationResult> _function_2 = new Consumer<ValidationResult>(){

            @Override
            public void accept(ValidationResult it) {
                CPDMetaPluginValidator.this.applyResult(it);
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.map(PluginRegistry.getInstance().getPluginCPDGenerators(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    private boolean metaPluginExists(Annotation annotation) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(PluginRegistry.getInstance().getSuitableCPDMetaPlugins(annotation.getName()));
        return !_isNullOrEmpty;
    }
}

