/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry.impl;

import de.jabc.cinco.meta.core.pluginregistry.IMGLMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistryEntry;
import de.jabc.cinco.meta.core.pluginregistry.proposalprovider.IMetaPluginAcceptor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;

public class PluginRegistryEntryImpl
implements PluginRegistryEntry {
    public static final int GENERAL_ANNOTATION = 0;
    public static final int NODE_ANNOTATION = 1;
    public static final int EDGE_ANNOTATION = 2;
    public static final int GRAPH_MODEL_ANNOTATION = 3;
    public static final int NODE_CONTAINER_ANNOTATION = 4;
    public static final int TYPE_ANNOTATION = 5;
    public static final int PRIME_ANNOTATION = 6;
    public static final int ATTRIBUTE_ANNOTATION = 7;
    private EPackage usedEPackage = null;
    private Set<String> recognizedAnnotations = new HashSet<String>();
    private String genModelPath = null;
    private String nodeContainerSuperType = null;
    private String graphModelSuperType = null;
    private String edgeSuperType = null;
    private String nodeSuperType = null;
    private Set<String> nodeAnnotations = new HashSet<String>();
    private Set<String> edgeAnnotations = new HashSet<String>();
    private Set<String> graphModelAnnotations = new HashSet<String>();
    private Set<String> typeAnnotations = new HashSet<String>();
    private Set<String> nodeContainerAnnotations = new HashSet<String>();
    private Set<String> primeAnnotations = new HashSet<String>();
    private Set<String> attributeAnnotations = new HashSet<String>();
    private IMGLMetaPlugin metaPluginService = null;
    private IMetaPluginAcceptor acceptor;
    private Set<String> mglDependentPlugins = new HashSet<String>();
    private Set<String> usedPlugins = new HashSet<String>();
    private Set<String> mglDependentFragments = new HashSet<String>();
    private Set<String> usedFragments = new HashSet<String>();
    private String name = null;

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService2) {
        this.metaPluginService = metaPluginService2;
        this.name = name;
    }

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService2, Set<String> recognizedAnnotations) {
        this(name, metaPluginService2);
        this.recognizedAnnotations = recognizedAnnotations;
    }

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService, String recognizedAnnotation) {
        this(name, metaPluginService);
        this.recognizedAnnotations.add(recognizedAnnotation);
    }

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService, Set<String> annotations, EPackage ep, String genModelPath) {
        this(name, metaPluginService, annotations);
        this.usedEPackage = ep;
        this.genModelPath = genModelPath;
    }

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService, String annotation, EPackage ep, String genModelPath) {
        this(name, metaPluginService, annotation);
        this.usedEPackage = ep;
        this.genModelPath = genModelPath;
    }

    public PluginRegistryEntryImpl(String name, IMGLMetaPlugin metaPluginService2, Set<String> annotations, EPackage ep, String genModelPath, Set<String> nodeAnnotations, Set<String> edgeAnnotations, Set<String> graphModelAnnotations, Set<String> nodeContainerAnnotations, Set<String> typeAnnotations, Set<String> primeAnnotations, Set<String> attributeAnnotations, Set<String> usedPlugins, Set<String> mglDependentPlugins, Set<String> usedFragments, Set<String> mglDependentFragments) {
        this(name, metaPluginService2, annotations);
        this.usedEPackage = ep;
        this.genModelPath = genModelPath;
        this.nodeAnnotations = nodeAnnotations;
        this.edgeAnnotations = edgeAnnotations;
        this.graphModelAnnotations = graphModelAnnotations;
        this.typeAnnotations = typeAnnotations;
        this.nodeContainerAnnotations = nodeContainerAnnotations;
        this.primeAnnotations = primeAnnotations;
        this.attributeAnnotations = attributeAnnotations;
        this.mglDependentPlugins = mglDependentPlugins;
        this.usedPlugins = usedPlugins;
        this.usedFragments = usedFragments;
        this.mglDependentFragments = mglDependentFragments;
    }

    @Override
    public EPackage getUsedEPackage() {
        return this.usedEPackage;
    }

    @Override
    public void setUsedEPackage(EPackage ePackage, String genModelPath) {
        this.usedEPackage = ePackage;
        this.genModelPath = genModelPath;
    }

    @Override
    public boolean doesRecognizeAnnotation(String annotation) {
        return this.doesRecognizeAnnotation(annotation, this.recognizedAnnotations);
    }

    @Override
    public boolean removeAnnotation(String annotation) {
        return this.recognizedAnnotations.remove(annotation);
    }

    @Override
    public boolean addAnnotation(String annotation) {
        return this.recognizedAnnotations.add(annotation);
    }

    @Override
    public IMGLMetaPlugin getMetaPluginService() {
        return this.metaPluginService;
    }

    @Override
    public Set<String> getRecognizedAnnotations() {
        return this.recognizedAnnotations;
    }

    public Set<String> getRecognizedAnnotations(int annotationType) {
        switch (annotationType) {
            case 0: {
                return this.recognizedAnnotations;
            }
            case 1: {
                return this.nodeAnnotations;
            }
            case 2: {
                return this.edgeAnnotations;
            }
            case 3: {
                return this.graphModelAnnotations;
            }
            case 4: {
                return this.nodeContainerAnnotations;
            }
            case 5: {
                return this.typeAnnotations;
            }
            case 6: {
                return this.primeAnnotations;
            }
            case 7: {
                return this.attributeAnnotations;
            }
        }
        throw new IllegalArgumentException("Unknown Annotation type: " + annotationType + ".");
    }

    @Override
    public String getGenModelPath() {
        return this.genModelPath;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getNodeSuperType() {
        return this.nodeSuperType;
    }

    @Override
    public void setNodeSuperType(String superType) {
        this.nodeSuperType = superType;
    }

    @Override
    public String getEdgeSuperType() {
        return this.edgeSuperType;
    }

    @Override
    public void setEdgeSuperType(String superType) {
        this.edgeSuperType = superType;
    }

    @Override
    public String getGraphModelSuperType() {
        return this.graphModelSuperType;
    }

    @Override
    public void setGraphModelSuperType(String superType) {
        this.graphModelSuperType = superType;
    }

    @Override
    public String getNodeContainerSuperType() {
        return this.nodeContainerSuperType;
    }

    @Override
    public void setNodeContainerSuperType(String superType) {
        this.nodeContainerSuperType = superType;
    }

    public boolean doesRecognizeAnnotation(String annotation, int annotationType) {
        switch (annotationType) {
            case 0: {
                return this.doesRecognizeAnnotation(annotation);
            }
            case 1: {
                return this.doesRecognizeAnnotation(annotation, this.nodeAnnotations);
            }
            case 2: {
                return this.doesRecognizeAnnotation(annotation, this.edgeAnnotations);
            }
            case 3: {
                return this.doesRecognizeAnnotation(annotation, this.graphModelAnnotations);
            }
            case 4: {
                return this.doesRecognizeAnnotation(annotation, this.nodeContainerAnnotations);
            }
            case 5: {
                return this.doesRecognizeAnnotation(annotation, this.typeAnnotations);
            }
            case 6: {
                return this.doesRecognizeAnnotation(annotation, this.primeAnnotations);
            }
            case 7: {
                return this.doesRecognizeAnnotation(annotation, this.attributeAnnotations);
            }
        }
        throw new IllegalArgumentException("Unknown Annotation type: " + annotationType + ".");
    }

    private boolean doesRecognizeAnnotation(String annotation, Set<String> annotations) {
        return annotations.contains(annotation);
    }

    public Set<String> getAllRecognizedAnnotations() {
        HashSet<String> allRecognizedAnnotations = new HashSet<String>();
        int i = 0;
        while (i <= 7) {
            allRecognizedAnnotations.addAll(this.getRecognizedAnnotations(i));
            ++i;
        }
        return allRecognizedAnnotations;
    }

    @Override
    public IMetaPluginAcceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public void setAcceptor(IMetaPluginAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Override
    public Set<String> getUsedPlugins() {
        return this.usedPlugins;
    }

    @Override
    public Set<String> getMGLDependentPlugins() {
        return this.mglDependentPlugins;
    }

    @Override
    public Set<String> getUsedFragments() {
        return this.usedFragments;
    }

    @Override
    public Set<String> getMGLDependentFragments() {
        return this.mglDependentFragments;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

