/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry;

import de.jabc.cinco.meta.core.pluginregistry.CPDAnnotation;
import de.jabc.cinco.meta.core.pluginregistry.IMGLMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistryEntry;
import de.jabc.cinco.meta.core.pluginregistry.impl.PluginRegistryEntryImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;

public class PluginRegistry {
    private static PluginRegistry instance;
    HashMap<EPackage, String> genModelMap = new HashMap();
    private HashMap<String, EPackage> ecoreMap = new HashMap();
    private HashMap<String, IMGLMetaPlugin> pluginGenerators;
    private HashSet<PluginRegistryEntryImpl> metaPlugins = new HashSet();
    private HashMap<String, Set<String>> mglDependentPlugins;
    private HashMap<String, Set<String>> usedPlugins;
    private HashMap<String, Set<String>> mglDependentFragments;
    private HashMap<String, Set<String>> usedFragments;
    private Set<CPDAnnotation> cpdPluginGenerators;

    public HashMap<String, IMGLMetaPlugin> getPluginGenerators() {
        return this.pluginGenerators;
    }

    public void setPluginGenerators(HashMap<String, IMGLMetaPlugin> pluginGenerators) {
        this.pluginGenerators = pluginGenerators;
    }

    public Set<CPDAnnotation> getPluginCPDGenerators() {
        return this.cpdPluginGenerators;
    }

    public void setCPDPluginGenerators(Set<CPDAnnotation> cpdPluginGenerators) {
        this.cpdPluginGenerators = cpdPluginGenerators;
    }

    private PluginRegistry() {
        this.pluginGenerators = new HashMap();
        this.cpdPluginGenerators = new HashSet<CPDAnnotation>();
        EPackage abstractGraphModel = EcoreUtil2.getEPackage((String)"platform:/plugin/de.jabc.cinco.meta.core.mgl.model/model/GraphModel.ecore");
        this.ecoreMap.put("abstractGraphModel", abstractGraphModel);
        this.genModelMap.put(abstractGraphModel, "platform:/plugin/de.jabc.cinco.meta.core.mgl.model/model/GraphModel.genmodel");
        this.mglDependentPlugins = new HashMap();
        this.usedPlugins = new HashMap();
        this.mglDependentFragments = new HashMap();
        this.usedFragments = new HashMap();
    }

    public static PluginRegistry getInstance() {
        if (instance == null) {
            instance = new PluginRegistry();
        }
        return instance;
    }

    public HashMap<String, EPackage> getRegisteredEcoreModels() {
        return this.ecoreMap;
    }

    public HashMap<EPackage, String> getGenModelMap() {
        return this.genModelMap;
    }

    public void registerMetaPlugin(PluginRegistryEntryImpl pEntry) {
        String firstRecognizedAnnotation = (String)pEntry.getAllRecognizedAnnotations().toArray()[0];
        this.metaPlugins.add(pEntry);
        this.genModelMap.put(pEntry.getUsedEPackage(), pEntry.getGenModelPath());
        this.mglDependentPlugins.put(firstRecognizedAnnotation, pEntry.getMGLDependentPlugins());
        this.usedPlugins.put(firstRecognizedAnnotation, pEntry.getUsedPlugins());
        this.mglDependentFragments.put(firstRecognizedAnnotation, pEntry.getMGLDependentFragments());
        this.usedFragments.put(firstRecognizedAnnotation, pEntry.getUsedFragments());
        for (String annotation : pEntry.getAllRecognizedAnnotations()) {
            this.ecoreMap.put(annotation, pEntry.getUsedEPackage());
            this.pluginGenerators.put(annotation, pEntry.getMetaPluginService());
        }
    }

    public void registerCPDMetaPlugin(CPDAnnotation annotation) {
        this.cpdPluginGenerators.add(annotation);
    }

    public Set<PluginRegistryEntry> getSuitableMetaPlugins(String annotation) {
        HashSet<PluginRegistryEntry> set = new HashSet<PluginRegistryEntry>();
        for (PluginRegistryEntry pluginRegistryEntry : this.metaPlugins) {
            if (!pluginRegistryEntry.doesRecognizeAnnotation(annotation)) continue;
            set.add(pluginRegistryEntry);
        }
        return set;
    }

    public Set<CPDAnnotation> getSuitableCPDMetaPlugins(String annotation) {
        return this.cpdPluginGenerators.stream().filter(n -> n.getAnnotationName().equals(annotation)).collect(Collectors.toSet());
    }

    public Set<String> getAnnotations(int annotationType) {
        HashSet<String> annotations = new HashSet<String>();
        for (PluginRegistryEntryImpl entry : this.metaPlugins) {
            annotations.addAll(entry.getRecognizedAnnotations(annotationType));
        }
        return annotations;
    }

    public Set<PluginRegistryEntry> getSuitableMetaPlugins(String annotation, int annotationType) {
        HashSet<PluginRegistryEntry> set = new HashSet<PluginRegistryEntry>();
        for (PluginRegistryEntryImpl p : this.metaPlugins) {
            if (!p.doesRecognizeAnnotation(annotation, annotationType)) continue;
            set.add(p);
        }
        return set;
    }

    public HashMap<String, Set<String>> getMGLDependentPlugins() {
        return this.mglDependentPlugins;
    }

    public HashMap<String, Set<String>> getUsedPlugins() {
        return this.usedPlugins;
    }

    public HashMap<String, Set<String>> getMGLDependentFragments() {
        return this.mglDependentFragments;
    }

    public HashMap<String, Set<String>> getUsedFragments() {
        return this.usedFragments;
    }
}

