/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.pluginregistry;

import de.jabc.cinco.meta.core.pluginregistry.CPDAnnotation;
import de.jabc.cinco.meta.core.pluginregistry.ICPDMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.IMGLMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.pluginregistry.impl.PluginRegistryEntryImpl;
import de.jabc.cinco.meta.core.pluginregistry.proposalprovider.ICPDMetaPluginAcceptor;
import de.jabc.cinco.meta.core.pluginregistry.proposalprovider.IMetaPluginAcceptor;
import de.jabc.cinco.meta.core.pluginregistry.validation.CPDMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.IMetaPluginValidator;
import de.jabc.cinco.meta.core.pluginregistry.validation.MetaPluginValidator;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "de.jabc.cinco.meta.core.pluginregistry";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        IExtension[] extensions;
        IExtension[] cpdextensions;
        EValidator.Registry.INSTANCE.put((Object)EPackage.Registry.INSTANCE.getEPackage("http://www.jabc.de/cinco/meta/core/mgl"), (Object)MetaPluginValidator.getInstance());
        EValidator.Registry.INSTANCE.put((Object)EPackage.Registry.INSTANCE.getEPackage("http://www.jabc.de/meta/productdefinition"), (Object)CPDMetaPluginValidator.getInstance());
        super.start(context);
        plugin = this;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint cpdpoint = registry.getExtensionPoint("de.jabc.cinco.meta.core.pluginregistry.cpdplugin");
        IExtension[] iExtensionArray = cpdextensions = cpdpoint.getExtensions();
        int n = cpdextensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.readCPDExtension(extension);
            ++n2;
        }
        IExtensionPoint point = registry.getExtensionPoint("de.jabc.cinco.meta.core.pluginregistry.metaplugin");
        if (point == null) {
            return;
        }
        IExtension[] iExtensionArray2 = extensions = point.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension extension = iExtensionArray2[n4];
            this.readExtension(extension);
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readExtension(IExtension extension) {
        try {
            String ecorePath = "";
            String genModelPath = "";
            String nodeSuperType = "";
            String edgeSuperType = "";
            String graphModelSuperType = "";
            String nodeContainerSuperType = "";
            HashSet<String> annotations = new HashSet<String>();
            HashSet<String> nodeAnnotations = new HashSet<String>();
            HashSet<String> edgeAnnotations = new HashSet<String>();
            HashSet<String> graphModelAnnotations = new HashSet<String>();
            HashSet<String> nodeContainerAnnotations = new HashSet<String>();
            HashSet<String> typeAnnotations = new HashSet<String>();
            HashSet<String> primeAnnotations = new HashSet<String>();
            HashSet<String> attributeAnnotations = new HashSet<String>();
            HashSet<String> mglDependentPlugins = new HashSet<String>();
            HashSet<String> usedPlugins = new HashSet<String>();
            HashSet<String> usedFragments = new HashSet<String>();
            HashSet<String> mglDependentFragments = new HashSet<String>();
            Object metaPluginService = null;
            EPackage ecore = null;
            IMetaPluginAcceptor metaPluginAcceptor = null;
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String anno;
                Constructor<?> s;
                Object[] params;
                IConfigurationElement elem = iConfigurationElementArray[n2];
                if (elem.getName().equals("metaplugin_description")) {
                    String serviceName = elem.getAttribute("metapluginService");
                    Class<?> serviceClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(serviceName);
                    params = new Class[]{};
                    s = serviceClass.getConstructor((Class<?>[])params);
                    metaPluginService = (IMGLMetaPlugin)s.newInstance(new Object[0]);
                } else if (elem.getName().equals("annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 0)) throw new Exception("Annotation: " + anno + " already exists for general annotations");
                    annotations.add(anno);
                } else if (elem.getName().equals("node-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 1)) throw new Exception("Annotation: " + anno + " already exists for node annotations");
                    nodeAnnotations.add(anno);
                } else if (elem.getName().equals("edge-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 2)) throw new Exception("Annotation: " + anno + " already exists for edge annotations");
                    edgeAnnotations.add(anno);
                } else if (elem.getName().equals("graphmodel-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 3)) throw new Exception("Annotation: " + anno + " already exists for graphmodel annotations");
                    graphModelAnnotations.add(anno);
                } else if (elem.getName().equals("nodecontainer-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 4)) throw new Exception("Annotation: " + anno + " already exists for node container annotations");
                    nodeContainerAnnotations.add(anno);
                } else if (elem.getName().equals("type-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 5)) throw new Exception("Annotation: " + anno + " already exists for type annotations");
                    typeAnnotations.add(anno);
                } else if (elem.getName().equals("prime-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 6)) throw new Exception("Annotation: " + anno + " already exists for type annotations");
                    primeAnnotations.add(anno);
                } else if (elem.getName().equals("attribute-annotation")) {
                    anno = elem.getAttribute("recognized-annotation");
                    if (this.existsAnnotation(anno, 7)) throw new Exception("Annotation: " + anno + " already exists for type annotations");
                    attributeAnnotations.add(anno);
                } else if (elem.getName().equals("used_ecore_model")) {
                    nodeSuperType = elem.getAttribute("Node-Supertype");
                    edgeSuperType = elem.getAttribute("Edge-Supertype");
                    graphModelSuperType = elem.getAttribute("GraphModel-Supertype");
                    nodeContainerSuperType = elem.getAttribute("NodeContainer-Supertype");
                    ecorePath = elem.getAttribute("Used_Ecore-Model");
                    genModelPath = elem.getAttribute("Used_GenModel");
                    ecorePath = String.valueOf(Platform.getBundle((String)extension.getNamespaceIdentifier()).getSymbolicName()) + "/" + ecorePath;
                    genModelPath = String.valueOf(Platform.getBundle((String)extension.getNamespaceIdentifier()).getSymbolicName()) + "/" + genModelPath;
                } else if (elem.getName().equals("validator")) {
                    String validatorName = elem.getAttribute("ValidatorClass");
                    Class<?> validatorClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(validatorName);
                    params = new Class[]{};
                    s = validatorClass.getConstructor((Class<?>[])params);
                    IMetaPluginValidator metaPluginValidator = (IMetaPluginValidator)s.newInstance(params);
                    MetaPluginValidator.getInstance().putValidator(metaPluginValidator);
                } else if (elem.getName().equals("proposalprovider")) {
                    String proposalProviderClassName = elem.getAttribute("MetaPluginAcceptor");
                    Class<?> proposalProviderClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(proposalProviderClassName);
                    params = new Class[]{};
                    Constructor<?> c = proposalProviderClass.getConstructor((Class<?>[])params);
                    metaPluginAcceptor = (IMetaPluginAcceptor)c.newInstance(params);
                } else if (elem.getName().equals("used_plugin")) {
                    String pluginName = elem.getAttribute("plugin_name");
                    if (Boolean.parseBoolean(elem.getAttribute("mgl_dependent"))) {
                        if (Boolean.parseBoolean(elem.getAttribute("is_fragment"))) {
                            mglDependentFragments.add(pluginName);
                        } else {
                            mglDependentPlugins.add(pluginName);
                        }
                    } else if (Boolean.parseBoolean(elem.getAttribute("is_fragment"))) {
                        usedFragments.add(pluginName);
                    } else {
                        usedPlugins.add(pluginName);
                    }
                }
                ++n2;
            }
            PluginRegistryEntryImpl pEntry = new PluginRegistryEntryImpl(metaPluginService.getClass().getName(), (IMGLMetaPlugin)metaPluginService, annotations, ecore, genModelPath, nodeAnnotations, edgeAnnotations, graphModelAnnotations, nodeContainerAnnotations, typeAnnotations, primeAnnotations, attributeAnnotations, usedPlugins, mglDependentPlugins, usedFragments, mglDependentFragments);
            pEntry.setEdgeSuperType(edgeSuperType);
            pEntry.setNodeContainerSuperType(nodeContainerSuperType);
            pEntry.setNodeSuperType(nodeSuperType);
            pEntry.setGraphModelSuperType(graphModelSuperType);
            pEntry.setAcceptor(metaPluginAcceptor);
            PluginRegistry.getInstance().registerMetaPlugin(pEntry);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readCPDExtension(IExtension extension) {
        try {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                if (elem.getName().equals("cpd_metaplugin_description")) {
                    String serviceName = elem.getAttribute("cpdMetapluginService");
                    String annotationName = elem.getAttribute("recognized-annotation");
                    if (serviceName != null && annotationName != null) {
                        String validatorClass;
                        CPDAnnotation annotation = new CPDAnnotation();
                        annotation.setAnnotationName(annotationName);
                        Class<?> serviceClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(serviceName);
                        Class[] params = new Class[]{};
                        Constructor<?> s = serviceClass.getConstructor(params);
                        ICPDMetaPlugin metaPluginService = (ICPDMetaPlugin)s.newInstance(new Object[0]);
                        annotation.setPlugin(metaPluginService);
                        String acceptorname = elem.getAttribute("acceptor");
                        if (acceptorname != null) {
                            Class<?> serviceClass2 = ((Object)((Object)this)).getClass().getClassLoader().loadClass(acceptorname);
                            Class[] params2 = new Class[]{};
                            Constructor<?> s2 = serviceClass2.getConstructor(params2);
                            ICPDMetaPluginAcceptor metaPluginAcceptor = (ICPDMetaPluginAcceptor)s2.newInstance(new Object[0]);
                            annotation.setAcceptor(metaPluginAcceptor);
                        }
                        if ((validatorClass = elem.getAttribute("validatorClass")) != null) {
                            Class<?> serviceClass3 = ((Object)((Object)this)).getClass().getClassLoader().loadClass(validatorClass);
                            Class[] params3 = new Class[]{};
                            Constructor<?> s3 = serviceClass3.getConstructor(params3);
                            IMetaPluginValidator metaPluginValidator = (IMetaPluginValidator)s3.newInstance(new Object[0]);
                            annotation.setValidator(metaPluginValidator);
                        }
                        PluginRegistry.getInstance().registerCPDMetaPlugin(annotation);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean existsAnnotation(String attribute, int annotationType) {
        return !PluginRegistry.getInstance().getSuitableMetaPlugins(attribute, annotationType).isEmpty();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

