/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.objectlang.ui;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import info.scce.dime.objectlang.ObjectLangExtension;
import info.scce.dime.objectlang.objectLang.AttributeValueDef;
import info.scce.dime.objectlang.objectLang.AttributeValueReferenceDef;
import info.scce.dime.objectlang.objectLang.ComplexInputDef;
import info.scce.dime.objectlang.objectLang.InputDef;
import info.scce.dime.objectlang.objectLang.NamedObject;
import info.scce.dime.objectlang.objectLang.ObjectDef;
import info.scce.dime.objectlang.objectLang.ObjectExtend;
import info.scce.dime.objectlang.objectLang.ObjectsModel;
import info.scce.dime.objectlang.objectLang.PrimitiveInputDef;
import info.scce.dime.objectlang.objectLang.ProcessArgumentDef;
import info.scce.dime.objectlang.services.ObjectLangGrammarAccess;
import info.scce.dime.objectlang.ui.AbstractObjectLangUiModule;
import info.scce.dime.objectlang.ui.ObjectLangBuilderParticipant;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.HighlightingStyles;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class ObjectLangUiModule
extends AbstractObjectLangUiModule {
    @Override
    public Class<? extends IXtextBuilderParticipant> bindIXtextBuilderParticipant() {
        return ObjectLangBuilderParticipant.class;
    }

    public Class<? extends IHighlightingConfiguration> bindIHighlightingConfiguration() {
        return MyHighlightingConfiguration.class;
    }

    public Class<? extends ISemanticHighlightingCalculator> bindISemanticHighlightingCalculator() {
        return MySemanticHighlightingCalculator.class;
    }

    public ObjectLangUiModule(AbstractUIPlugin arg0) {
        super(arg0);
    }

    public static class MyHighlightingConfiguration
    extends DefaultHighlightingConfiguration {
        public void configure(IHighlightingConfigurationAcceptor acceptor) {
            acceptor.acceptDefaultHighlighting("keywordPrimitiveInputDefName", "PrimitiveInputDefName", this.primitiveInputDefNameStyle());
            acceptor.acceptDefaultHighlighting("keywordObjectDefName", "ObjectDefName", this.objectDefNameStyle());
            acceptor.acceptDefaultHighlighting("keywordAbstractObjectDefName", "AbstractObjectDefName", this.abstractObjectDefNameStyle());
            super.configure(acceptor);
        }

        public TextStyle objectDefNameStyle() {
            TextStyle _copy = this.defaultTextStyle().copy();
            Procedures.Procedure1<TextStyle> _function = new Procedures.Procedure1<TextStyle>(){

                public void apply(TextStyle it) {
                    RGB _rGB = new RGB(0, 150, 150);
                    it.setColor(_rGB);
                    it.setStyle(1);
                }
            };
            return (TextStyle)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
        }

        public TextStyle abstractObjectDefNameStyle() {
            TextStyle _copy = this.defaultTextStyle().copy();
            Procedures.Procedure1<TextStyle> _function = new Procedures.Procedure1<TextStyle>(){

                public void apply(TextStyle it) {
                    RGB _rGB = new RGB(100, 100, 100);
                    it.setColor(_rGB);
                    it.setStyle(1);
                }
            };
            return (TextStyle)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
        }

        public TextStyle primitiveInputDefNameStyle() {
            TextStyle _copy = this.defaultTextStyle().copy();
            Procedures.Procedure1<TextStyle> _function = new Procedures.Procedure1<TextStyle>(){

                public void apply(TextStyle it) {
                    RGB _rGB = new RGB(60, 90, 150);
                    it.setColor(_rGB);
                    it.setStyle(1);
                }
            };
            return (TextStyle)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
        }
    }

    public static class MyHighlightingStyles
    implements HighlightingStyles {
        public static final String PRIMITIVE_INPUT_NAME_ID = "keywordPrimitiveInputDefName";
        public static final String OBJECT_DEF_NAME_ID = "keywordObjectDefName";
        public static final String ABSTRACT_OBJECT_DEF_NAME_ID = "keywordAbstractObjectDefName";
    }

    public static class MySemanticHighlightingCalculator
    extends DefaultSemanticHighlightingCalculator {
        @Extension
        private ObjectLangExtension _objectLangExtension = new ObjectLangExtension();
        @Inject
        private ObjectLangGrammarAccess ga;

        public boolean highlightElement(EObject model, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
            boolean _xblockexpression = false;
            if (model instanceof ObjectsModel) {
                List namedObjs = IterableExtensions.toList(this.findNamedObjects(model));
                RuleCall _nameIDTerminalRuleCall_1_0 = this.ga.getComplexInputDefAccess().getNameIDTerminalRuleCall_1_0();
                RuleCall _nameIDTerminalRuleCall_1_0_1 = this.ga.getPrimitiveInputDefAccess().getNameIDTerminalRuleCall_1_0();
                RuleCall _nameIDTerminalRuleCall_1_0_0 = this.ga.getObjectDefAccess().getNameIDTerminalRuleCall_1_0_0();
                CrossReference _objSrcObjectDefCrossReference_2_0 = this.ga.getObjectExtendAccess().getObjSrcObjectDefCrossReference_2_0();
                RuleCall _objectCreationParserRuleCall_4 = this.ga.getAttributeValueDefAccess().getObjectCreationParserRuleCall_4();
                CrossReference _valueNamedObjectCrossReference_0 = this.ga.getAttributeValueReferenceDefAccess().getValueNamedObjectCrossReference_0();
                RuleCall _valuesDefAttributeValueReferenceDefParserRuleCall_2_0_1 = this.ga.getComplexListAttributeValuesDefAccess().getValuesDefAttributeValueReferenceDefParserRuleCall_2_0_1();
                RuleCall _valuesDefAttributeValueReferenceDefParserRuleCall_3_1_0_1 = this.ga.getComplexListAttributeValuesDefAccess().getValuesDefAttributeValueReferenceDefParserRuleCall_3_1_0_1();
                RuleCall _valueDefAttributeValueDefParserRuleCall_2_0 = this.ga.getProcessArgumentDefAccess().getValueDefAttributeValueDefParserRuleCall_2_0();
                Set ruleCalls = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new AbstractElement[]{_nameIDTerminalRuleCall_1_0, _nameIDTerminalRuleCall_1_0_1, _nameIDTerminalRuleCall_1_0_0, _objSrcObjectDefCrossReference_2_0, _objectCreationParserRuleCall_4, _valueNamedObjectCrossReference_0, _valuesDefAttributeValueReferenceDefParserRuleCall_2_0_1, _valuesDefAttributeValueReferenceDefParserRuleCall_3_1_0_1, _valueDefAttributeValueDefParserRuleCall_2_0}));
                for (NamedObject candidate : namedObjs) {
                    BidiTreeIterable _asTreeIterable = NodeModelUtils.findActualNodeFor((EObject)candidate).getAsTreeIterable();
                    for (INode n : _asTreeIterable) {
                        boolean _contains = ruleCalls.contains(n.getGrammarElement());
                        if (!_contains) continue;
                        this.accept(acceptor, n);
                    }
                }
            }
            _xblockexpression = super.highlightElement(model, acceptor, cancelIndicator);
            return _xblockexpression;
        }

        public void accept(IHighlightedPositionAcceptor acceptor, INode n) {
            NamedObject objSrc;
            EObject _semanticElement;
            NamedObject _switchResult = null;
            EObject it = _semanticElement = n.getSemanticElement();
            boolean _matched = false;
            if (it instanceof InputDef) {
                _matched = true;
                _switchResult = (NamedObject)it;
            }
            if (!_matched && it instanceof ObjectDef) {
                _matched = true;
                _switchResult = (NamedObject)it;
            }
            if (!_matched && it instanceof AttributeValueReferenceDef) {
                _matched = true;
                _switchResult = ((AttributeValueReferenceDef)it).getValue();
            }
            if (!_matched && it instanceof ObjectExtend) {
                _matched = true;
                _switchResult = ((ObjectExtend)it).getObjSrc();
            }
            if (!_matched && it instanceof ProcessArgumentDef) {
                AttributeValueDef _valueDef;
                _matched = true;
                NamedObject _switchResult_1 = null;
                AttributeValueDef valueDef = _valueDef = ((ProcessArgumentDef)it).getValueDef();
                boolean _matched_1 = false;
                if (valueDef instanceof AttributeValueReferenceDef) {
                    _matched_1 = true;
                    _switchResult_1 = ((AttributeValueReferenceDef)valueDef).getValue();
                }
                _switchResult = _switchResult_1;
            }
            if ((objSrc = _switchResult) instanceof ObjectDef || objSrc instanceof ComplexInputDef) {
                String _xifexpression = null;
                boolean _isAbstract = false;
                if (objSrc != null) {
                    _isAbstract = this._objectLangExtension.isAbstract(objSrc);
                }
                _xifexpression = _isAbstract ? "keywordAbstractObjectDefName" : "keywordObjectDefName";
                String id = _xifexpression;
                acceptor.addPosition(n.getOffset(), n.getLength(), new String[]{id});
            } else if (objSrc instanceof PrimitiveInputDef) {
                String id_1 = "keywordPrimitiveInputDefName";
                acceptor.addPosition(n.getOffset(), n.getLength(), new String[]{"keywordPrimitiveInputDefName"});
            } else if (objSrc != null) {
                EObject _semanticElement_1 = n.getSemanticElement();
                String _plus = "WARN: Colorization may be wrong as semanticElement is not handled: " + _semanticElement_1;
                InputOutput.println((Object)_plus);
                acceptor.addPosition(n.getOffset(), n.getLength(), new String[]{"keywordObjectDefName"});
            }
        }

        public Iterable<NamedObject> findNamedObjects(EObject model) {
            Iterable _filter = Iterables.filter((Iterable)model.eContents(), NamedObject.class);
            Functions.Function1<EObject, Iterable<NamedObject>> _function = new Functions.Function1<EObject, Iterable<NamedObject>>(){

                public Iterable<NamedObject> apply(EObject it) {
                    return this.findNamedObjects(it);
                }
            };
            Iterable _flatMap = IterableExtensions.flatMap((Iterable)model.eContents(), (Functions.Function1)_function);
            return Iterables.concat((Iterable)_filter, (Iterable)_flatMap);
        }
    }
}

