/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.mcam.views;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.FrameworkExecution;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.PageFactory;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.CheckViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.pages.ConflictViewPage;
import de.jabc.cinco.meta.plugin.mcam.runtime.views.utils.EclipseUtils;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.GraphModel;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.mcam.cli.DADExecution;
import info.scce.dime.data.data.Data;
import info.scce.dime.data.mcam.cli.DataExecution;
import info.scce.dime.graphql.api.api.API;
import info.scce.dime.graphql.api.mcam.cli.APIExecution;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.mcam.cli.GraphQLExecution;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.mcam.cli.GUIExecution;
import info.scce.dime.mcam.views.pages.APICheckViewPage;
import info.scce.dime.mcam.views.pages.DADCheckViewPage;
import info.scce.dime.mcam.views.pages.DataCheckViewPage;
import info.scce.dime.mcam.views.pages.GUICheckViewPage;
import info.scce.dime.mcam.views.pages.GraphQLCheckViewPage;
import info.scce.dime.mcam.views.pages.ProcessCheckViewPage;
import info.scce.dime.mcam.views.pages.ProfileCheckViewPage;
import info.scce.dime.mcam.views.pages.SearchCheckViewPage;
import info.scce.dime.process.mcam.cli.ProcessExecution;
import info.scce.dime.process.process.Process;
import info.scce.dime.profile.mcam.cli.ProfileExecution;
import info.scce.dime.profile.profile.Profile;
import info.scce.dime.search.mcam.cli.SearchExecution;
import info.scce.dime.search.search.Search;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorPart;

public class PageFactoryImpl
implements PageFactory {
    private ResourceExtension resourceHelper = new ResourceExtension();

    public boolean canHandle(Resource resource) {
        if (resource == null) {
            return false;
        }
        GraphModel model = this.resourceHelper.getGraphModel(resource);
        if (model == null) {
            return false;
        }
        if (model instanceof Search) {
            return true;
        }
        if (model instanceof Profile) {
            return true;
        }
        if (model instanceof Process) {
            return true;
        }
        if (model instanceof API) {
            return true;
        }
        if (model instanceof GraphQL) {
            return true;
        }
        if (model instanceof GUI) {
            return true;
        }
        if (model instanceof Data) {
            return true;
        }
        return model instanceof DAD;
    }

    public CheckViewPage<?, ?, ?> createCheckViewPage(String id, IEditorPart editor) {
        IFile iFile = EclipseUtils.getIFile((IEditorPart)editor);
        Resource resource = EclipseUtils.getResource((IEditorPart)editor);
        GraphModel model = this.resourceHelper.getGraphModel(resource);
        if (model instanceof Search) {
            SearchCheckViewPage page = new SearchCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof Profile) {
            ProfileCheckViewPage page = new ProfileCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof Process) {
            ProcessCheckViewPage page = new ProcessCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof API) {
            APICheckViewPage page = new APICheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof GraphQL) {
            GraphQLCheckViewPage page = new GraphQLCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof GUI) {
            GUICheckViewPage page = new GUICheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof Data) {
            DataCheckViewPage page = new DataCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        if (model instanceof DAD) {
            DADCheckViewPage page = new DADCheckViewPage(id);
            page.addCheckProcess(iFile, resource);
            return page;
        }
        return null;
    }

    public ConflictViewPage<?, ?, ?> createConflictViewPage(String id, IEditorPart editor) {
        EclipseUtils.getIFile((IEditorPart)editor);
        Resource resource = EclipseUtils.getResource((IEditorPart)editor);
        this.resourceHelper.getGraphModel(resource);
        return null;
    }

    public List<String> getFileExtensions() {
        return Arrays.asList("search", "profile", "process", "api", "gql", "gui", "data", "dad", "");
    }

    public FrameworkExecution getFrameWorkExecution(IFile iFile) {
        SearchExecution fe = null;
        if (iFile.getFileExtension().equals("search")) {
            fe = new SearchExecution();
        }
        if (iFile.getFileExtension().equals("profile")) {
            fe = new ProfileExecution();
        }
        if (iFile.getFileExtension().equals("process")) {
            fe = new ProcessExecution();
        }
        if (iFile.getFileExtension().equals("api")) {
            fe = new APIExecution();
        }
        if (iFile.getFileExtension().equals("gql")) {
            fe = new GraphQLExecution();
        }
        if (iFile.getFileExtension().equals("gui")) {
            fe = new GUIExecution();
        }
        if (iFile.getFileExtension().equals("data")) {
            fe = new DataExecution();
        }
        if (iFile.getFileExtension().equals("dad")) {
            fe = new DADExecution();
        }
        return fe;
    }
}

