/*
 * Decompiled with CFR 0.152.
 */
package style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineStyle implements Enumerator
{
    DASH(4, "DASH", "DASH"),
    DASHDOT(1, "DASHDOT", "DASHDOT"),
    DASHDOTDOT(2, "DASHDOTDOT", "DASHDOTDOT"),
    DOT(3, "DOT", "DOT"),
    SOLID(0, "SOLID", "SOLID"),
    UNSPECIFIED(5, "UNSPECIFIED", "UNSPECIFIED");

    public static final int DASH_VALUE = 4;
    public static final int DASHDOT_VALUE = 1;
    public static final int DASHDOTDOT_VALUE = 2;
    public static final int DOT_VALUE = 3;
    public static final int SOLID_VALUE = 0;
    public static final int UNSPECIFIED_VALUE = 5;
    private static final LineStyle[] VALUES_ARRAY;
    public static final List<LineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineStyle[]{DASH, DASHDOT, DASHDOTDOT, DOT, SOLID, UNSPECIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineStyle get(int value) {
        switch (value) {
            case 4: {
                return DASH;
            }
            case 1: {
                return DASHDOT;
            }
            case 2: {
                return DASHDOTDOT;
            }
            case 3: {
                return DOT;
            }
            case 0: {
                return SOLID;
            }
            case 5: {
                return UNSPECIFIED;
            }
        }
        return null;
    }

    private LineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

