/*
 * Decompiled with CFR 0.152.
 */
package style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HAlignment implements Enumerator
{
    LEFT(1, "LEFT", "LEFT"),
    CENTER(2, "CENTER", "CENTER"),
    RIGHT(3, "RIGHT", "RIGHT"),
    UNDEFINED(0, "UNDEFINED", "UNDEFINED");

    public static final int LEFT_VALUE = 1;
    public static final int CENTER_VALUE = 2;
    public static final int RIGHT_VALUE = 3;
    public static final int UNDEFINED_VALUE = 0;
    private static final HAlignment[] VALUES_ARRAY;
    public static final List<HAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HAlignment[]{LEFT, CENTER, RIGHT, UNDEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HAlignment get(int value) {
        switch (value) {
            case 1: {
                return LEFT;
            }
            case 2: {
                return CENTER;
            }
            case 3: {
                return RIGHT;
            }
            case 0: {
                return UNDEFINED;
            }
        }
        return null;
    }

    private HAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

