/*
 * Decompiled with CFR 0.152.
 */
package style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConnectionType implements Enumerator
{
    FREE_FORM(0, "FreeForm", "FreeForm"),
    CURVED(2, "Curved", "Curved"),
    COMPOSITE(3, "Composite", "Composite");

    public static final int FREE_FORM_VALUE = 0;
    public static final int CURVED_VALUE = 2;
    public static final int COMPOSITE_VALUE = 3;
    private static final ConnectionType[] VALUES_ARRAY;
    public static final List<ConnectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConnectionType[]{FREE_FORM, CURVED, COMPOSITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConnectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectionType get(int value) {
        switch (value) {
            case 0: {
                return FREE_FORM;
            }
            case 2: {
                return CURVED;
            }
            case 3: {
                return COMPOSITE;
            }
        }
        return null;
    }

    private ConnectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

