/*
 * Decompiled with CFR 0.152.
 */
package style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanEnum implements Enumerator
{
    TRUE(1, "true", "true"),
    FALSE(0, "false", "false"),
    UNDEF(-1, "undef", "undef");

    public static final int TRUE_VALUE = 1;
    public static final int FALSE_VALUE = 0;
    public static final int UNDEF_VALUE = -1;
    private static final BooleanEnum[] VALUES_ARRAY;
    public static final List<BooleanEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanEnum[]{TRUE, FALSE, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanEnum get(int value) {
        switch (value) {
            case 1: {
                return TRUE;
            }
            case 0: {
                return FALSE;
            }
            case -1: {
                return UNDEF;
            }
        }
        return null;
    }

    private BooleanEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

