/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.model.preprocessors;

import style.AbsolutPosition;
import style.AbstractShape;
import style.ContainerShape;
import style.NodeStyle;
import style.Point;
import style.Polygon;
import style.Size;
import style.Style;
import style.StyleFactory;
import style.Styles;

public class StylesPreprocessor {
    public static void preprocess(Styles styles) {
        for (Style s : styles.getStyles()) {
            if (!(s instanceof NodeStyle)) continue;
            AbstractShape ms = ((NodeStyle)s).getMainShape();
            StylesPreprocessor.adjustSizes(ms);
            StylesPreprocessor.setPolygonPositions(ms);
        }
    }

    private static void adjustSizes(AbstractShape ms) {
        boolean widthFixed;
        Size size = ms.getSize();
        boolean heightFixed = size != null ? size.isHeightFixed() : false;
        boolean bl = widthFixed = size != null ? size.isWidthFixed() : false;
        if (ms instanceof ContainerShape) {
            for (AbstractShape as : ((ContainerShape)ms).getChildren()) {
                if (heightFixed || widthFixed) {
                    StylesPreprocessor.setSize(as, widthFixed, heightFixed);
                    continue;
                }
                StylesPreprocessor.adjustSizes(as);
            }
        }
    }

    private static void setSize(AbstractShape as, boolean widthFixed, boolean heightFixed) {
        StylesPreprocessor.propagateSizeFix(as, widthFixed, heightFixed);
        StylesPreprocessor.adjustSizes(as);
    }

    private static void propagateSizeFix(AbstractShape as, boolean widthFixed, boolean heightFixed) {
        if (as.getSize() != null) {
            as.getSize().setWidthFixed(widthFixed);
            as.getSize().setHeightFixed(heightFixed);
        }
    }

    private static void setPolygonPositions(AbstractShape ms) {
        Polygon p;
        if (ms instanceof Polygon && (p = (Polygon)ms).getPosition() == null) {
            AbsolutPosition pos = StylesPreprocessor.setPosition(p);
            p.setPosition(pos);
        }
    }

    private static AbsolutPosition setPosition(Polygon p) {
        AbsolutPosition pos = StyleFactory.eINSTANCE.createAbsolutPosition();
        pos.setXPos(((Point)p.getPoints().get(0)).getX());
        pos.setYPos(((Point)p.getPoints().get(0)).getY());
        return pos;
    }
}

