/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.wizard.pages;

import com.google.common.base.Objects;
import info.scce.dime.ui.wizard.NativeFrontendSIBLibraryWizard;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NativeFrontendSIBLibraryWizardPage
extends WizardPage {
    private IContainer container;
    private Text dirText;
    private Text fileNameText;
    private Text jarDirText;
    private Text rootURLText;
    private Button browsFileButton;
    private Button browsJarFileButton;
    private Button isRest;

    public NativeFrontendSIBLibraryWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Create new NFSIB Library diagram");
        this.setMessage("Create a new diagram in an existing or new project");
    }

    public void createControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.addLabel(composite, "Di&rectory: ");
        this.dirText = this.addTextField(composite, false, false);
        this.browsFileButton = this.addButton(composite, "Brows&e...", 8);
        Listener _function = new Listener(){

            public void handleEvent(Event it) {
                boolean _notEquals;
                Shell _shell = NativeFrontendSIBLibraryWizardPage.this.getShell();
                DirectoryDialog dialog = new DirectoryDialog(_shell);
                dialog.setText("Select a directory");
                String rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                dialog.setFilterPath(rootLocation);
                String dirName = dialog.open();
                boolean bl = _notEquals = !Objects.equal((Object)dirName, null);
                if (_notEquals) {
                    NativeFrontendSIBLibraryWizardPage.this.dirText.setText(dirName);
                }
                NativeFrontendSIBLibraryWizardPage.this.dialogChanged();
            }
        };
        this.browsFileButton.addListener(13, _function);
        this.addLabel(composite, "Fi&le name: ");
        this.fileNameText = this.addTextField(composite, true, true);
        this.fileNameText.setText("");
        this.addLabel(composite, "");
        this.isRest = this.addButton(composite, "&Import REST Service from jar", 32);
        Object _layoutData = this.isRest.getLayoutData();
        ((GridData)_layoutData).horizontalSpan = 3;
        Object _layoutData_1 = this.isRest.getLayoutData();
        ((GridData)_layoutData_1).horizontalAlignment = 16384;
        final Group restComposite = new Group(composite, 16);
        final GridData l = new GridData(1808);
        l.horizontalSpan = 3;
        restComposite.setLayoutData((Object)l);
        GridLayout _gridLayout = new GridLayout(3, false);
        restComposite.setLayout((Layout)_gridLayout);
        restComposite.setText("Generate NFSIBs from REST service");
        restComposite.setVisible(false);
        Listener _function_1 = new Listener(){

            public void handleEvent(Event e) {
                l.exclude = !l.exclude;
                restComposite.setVisible(l.exclude);
                composite.redraw();
                NativeFrontendSIBLibraryWizardPage.this.dialogChanged();
            }
        };
        this.isRest.addListener(13, _function_1);
        this.addLabel((Composite)restComposite, "&JAR File");
        this.jarDirText = this.addTextField((Composite)restComposite, false, false);
        this.browsJarFileButton = this.addButton((Composite)restComposite, "Brows&e...", 8);
        Listener _function_2 = new Listener(){

            public void handleEvent(Event it) {
                boolean _notEquals;
                Shell _shell = NativeFrontendSIBLibraryWizardPage.this.getShell();
                FileDialog fileDialog = new FileDialog(_shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.jar"});
                fileDialog.setText("Choose jar file containing REST Service");
                String fileLocation = fileDialog.open();
                boolean bl = _notEquals = !Objects.equal((Object)fileLocation, null);
                if (_notEquals) {
                    NativeFrontendSIBLibraryWizardPage.this.jarDirText.setText(fileLocation);
                }
                NativeFrontendSIBLibraryWizardPage.this.dialogChanged();
            }
        };
        this.browsJarFileButton.addListener(13, _function_2);
        this.addLabel((Composite)restComposite, "R&oot URL");
        this.rootURLText = this.addTextField((Composite)restComposite, true, true);
        Listener _function_3 = new Listener(){

            public void handleEvent(Event it) {
                NativeFrontendSIBLibraryWizardPage.this.dialogChanged();
            }
        };
        this.rootURLText.addListener(2, _function_3);
        Listener _function_4 = new Listener(){

            public void handleEvent(Event it) {
                NativeFrontendSIBLibraryWizardPage.this.dialogChanged();
            }
        };
        this.fileNameText.addListener(2, _function_4);
        IStructuredSelection selection = null;
        IWizard _wizard = this.getWizard();
        if (_wizard instanceof NativeFrontendSIBLibraryWizard) {
            IWizard _wizard_1 = this.getWizard();
            selection = ((NativeFrontendSIBLibraryWizard)_wizard_1).getSelection();
        }
        if (!Objects.equal(selection, null) && selection.getFirstElement() instanceof IContainer) {
            Object _firstElement = selection.getFirstElement();
            this.container = (IContainer)_firstElement;
            this.dirText.setText(this.container.getLocation().toOSString());
        }
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    public Label addLabel(Composite parent, String label) {
        Label labelComponent = new Label(parent, 0);
        GridData _gridData = new GridData(16384, 0x1000000, false, false);
        labelComponent.setLayoutData((Object)_gridData);
        labelComponent.setText(label);
        return labelComponent;
    }

    public Button addButton(Composite parent, String lable, int style) {
        Button button = new Button(parent, style);
        button.setText(lable);
        GridData _gridData = new GridData(0x1000000, 0x1000000, false, false);
        button.setLayoutData((Object)_gridData);
        return button;
    }

    public Text addTextField(Composite parent, boolean editable, boolean enabled) {
        Text textField = new Text(parent, 2048);
        GridData _gridData = new GridData(4, 0x1000000, true, false);
        textField.setLayoutData((Object)_gridData);
        textField.setEditable(editable);
        textField.setEnabled(enabled);
        return textField;
    }

    private String validateModelLocation() {
        String directory = this.dirText.getText();
        boolean _isEmpty = directory.isEmpty();
        if (_isEmpty) {
            return "Select existing project or enter new project name";
        }
        return null;
    }

    private String validateFileName() {
        String fileName = this.fileNameText.getText();
        String fileExtension = "nfsl.process";
        boolean _isEmpty = fileName.isEmpty();
        if (_isEmpty) {
            return "Enter file name";
        }
        if (fileName.contains(".") && !fileName.endsWith("nfsl.process")) {
            return "Wrong file extension";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileExists() {
        String _xifexpression = null;
        boolean _contains = this.fileNameText.getText().contains(".");
        _xifexpression = _contains ? this.fileNameText.getText() : this.fileNameText.getText().concat(".nfsl.process");
        String fileName = _xifexpression;
        try {
            IResource[] _members;
            boolean _equals = Objects.equal((Object)this.container, null);
            if (_equals) {
                return false;
            }
            IResource[] iResourceArray = _members = this.container.members();
            int n = _members.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                boolean _equals_1 = res.getName().equals(fileName);
                if (_equals_1) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof CoreException)) throw Exceptions.sneakyThrow((Throwable)_t);
            CoreException e = (CoreException)_t;
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkIsREST() {
        boolean isGenerateRest;
        boolean _xblockexpression = false;
        _xblockexpression = isGenerateRest = this.isRest.getSelection();
        return _xblockexpression;
    }

    private String checkJarFile() {
        boolean _checkIsREST = this.checkIsREST();
        if (_checkIsREST) {
            String _text = this.jarDirText.getText();
            String _text_1 = this.jarDirText.getText();
            File file = new File(_text_1);
            if (file.exists() && file.canRead()) {
                return null;
            }
            return "Enter JAR File Location";
        }
        return null;
    }

    private String checkRootUrl() {
        boolean _checkIsREST = this.checkIsREST();
        if (_checkIsREST) {
            URI uri;
            block7: {
                block6: {
                    try {
                        String _text = this.rootURLText.getText();
                        new URL(_text);
                        uri = URI.create(this.rootURLText.getText()).normalize();
                        if (!uri.isOpaque() && uri.isAbsolute()) break block6;
                        return "Please enter a valid URL \n (Protocol Missing)";
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            String _message = e.getMessage();
                            String _plus = "Please enter a valid URL\n(" + _message;
                            return String.valueOf(_plus) + ")";
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                String _authority = uri.getAuthority();
                boolean _equals = Objects.equal((Object)_authority, null);
                if (!_equals) break block7;
                return "Please enter a valid URL \n (Authority Missing)";
            }
            this.rootURLText.setText(uri.toURL().toExternalForm());
        }
        return null;
    }

    private void dialogChanged() {
        String _validateModelLocation;
        String _validateFileName;
        boolean _checkFileExists;
        String _checkJarFile;
        this.updateStatus(null);
        String _checkRootUrl = this.checkRootUrl();
        if (_checkRootUrl != null) {
            this.updateStatus(_checkRootUrl);
        }
        if ((_checkJarFile = this.checkJarFile()) != null) {
            this.updateStatus(_checkJarFile);
        }
        if (_checkFileExists = this.checkFileExists()) {
            this.updateStatus("File already exists");
        }
        if ((_validateFileName = this.validateFileName()) != null) {
            this.updateStatus(_validateFileName);
        }
        if ((_validateModelLocation = this.validateModelLocation()) != null) {
            this.updateStatus(_validateModelLocation);
        }
    }

    private void updateStatus(String msg) {
        boolean _notEquals;
        this.setErrorMessage(msg);
        IWizardPage _currentPage = this.getContainer().getCurrentPage();
        boolean bl = _notEquals = !Objects.equal((Object)_currentPage, null);
        if (_notEquals) {
            this.getWizard().getContainer().updateMessage();
            this.getWizard().getContainer().updateButtons();
        }
        String _errorMessage = this.getErrorMessage();
        boolean _equals = Objects.equal((Object)_errorMessage, null);
        this.setPageComplete(_equals);
    }

    public String getDirecory() {
        String _text = null;
        if (this.dirText != null) {
            _text = this.dirText.getText();
        }
        return _text;
    }

    public String getFileName() {
        String _text = null;
        if (this.fileNameText != null) {
            _text = this.fileNameText.getText();
        }
        return _text;
    }

    public File getJarFile() {
        String _text = null;
        if (this.jarDirText != null) {
            _text = this.jarDirText.getText();
        }
        return new File(_text);
    }

    public String getRootURL() {
        String _text = null;
        if (this.rootURLText != null) {
            _text = this.rootURLText.getText();
        }
        return _text;
    }
}

