/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.wizard.pages;

import info.scce.dime.ui.wizard.pages.ProjectDescription;
import info.scce.dime.ui.wizard.pages.RadioGroup;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class MainPage
extends WizardPage {
    private final String EXAMPLE_BUNDLE_ID = "info.scce.dime.examples";
    private final String EXAMPLES_PATH = "/examples/";
    private final String DESC_EXTENSION = ".description";
    private final String DESCRIPTION_DEFAULT = "This wizard will create a new DIME project";
    private Map<String, ProjectDescription> projectDescriptions = new LinkedHashMap<String, ProjectDescription>();
    private Group mainGroup;
    private Group xmplGroup;
    private Button xmplButton;
    private Button mainSelectedButton;
    private Button xmplSelectedButton;
    private Text projectNameField;
    private SelectionListener mainSelectionListener;
    private SelectionListener xmplSelectionListener;

    public MainPage(String pageName) {
        super(pageName);
        this.setTitle("New DIME Application");
        this.setDescription("This wizard will create a new DIME project");
        this.initSelectionListeners();
        this.initPossibleExampleProjects();
    }

    private void initSelectionListeners() {
        this.mainSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    MainPage.this.mainSelectedButton = (Button)e.widget;
                    MainPage.this.updatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.xmplSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    MainPage.this.xmplSelectedButton = (Button)e.widget;
                    MainPage.this.updatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.createProjectNameField(comp);
        this.createSelectNewOrExample(comp);
        this.createSelectExampleProject(comp);
        this.updatePage();
        this.setControl((Control)comp);
    }

    private void createProjectNameField(Composite parent) {
        Composite inner = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        inner.setLayoutData((Object)gridData);
        inner.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(inner, 0);
        label.setText("Project name: ");
        this.projectNameField = new Text(inner, 2052);
        gridData = new GridData(4, 0x1000000, true, false);
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setText("NewApp");
        this.projectNameField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                MainPage.this.updatePage();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createSelectNewOrExample(Composite parent) {
        this.mainGroup = new RadioGroup(parent, this.mainSelectionListener).addButton("Create a new application from scratch").addButton("Initialize the project with an example app").selectChild(0).get();
    }

    private void createSelectExampleProject(Composite parent) {
        this.xmplButton = (Button)this.mainGroup.getChildren()[1];
        Label label = new Label(parent, 0);
        label.setText("Available example apps:");
        this.xmplGroup = new RadioGroup(parent, this.xmplSelectionListener).addButtonForEach(this.getPossibleExampleProjects()).get();
    }

    private void initPossibleExampleProjects() {
        Bundle bundle = Platform.getBundle((String)"info.scce.dime.examples");
        if (bundle != null) {
            try {
                Enumeration entries = bundle.findEntries("/examples/", "*", false);
                while (entries.hasMoreElements()) {
                    URL nextElement = (URL)entries.nextElement();
                    URL fileURL = FileLocator.toFileURL((URL)nextElement);
                    URI uri = URI.createFileURI((String)fileURL.getPath());
                    File f = new File(uri.toFileString());
                    List<String> desc = null;
                    if (!f.isDirectory()) continue;
                    if (this.containsDescription(f)) {
                        desc = this.getProjectDescription(f);
                    }
                    ProjectDescription pd = null;
                    pd = desc != null && desc.size() >= 2 ? new ProjectDescription(f, nextElement, desc.get(0), desc.get(1)) : new ProjectDescription(f, nextElement, f.getName(), "No Description available...");
                    this.projectDescriptions.put(pd.getProjectName(), pd);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Set<String> getPossibleExampleProjects() {
        Set<String> keySet = this.projectDescriptions.keySet();
        Set<String> sortedKeys = keySet.stream().sorted().collect(Collectors.toSet());
        return sortedKeys;
    }

    private List<String> getProjectDescription(File file) {
        File[] files = file.listFiles();
        List<String> desc = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".description")) {
                desc = this.readDescription(f);
            }
            ++n2;
        }
        return desc;
    }

    private List<String> readDescription(File f) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            List<String> lines = Files.readAllLines(f.toPath());
            retval.add(0, lines.remove(0));
            String result = "";
            for (String l : lines) {
                result = String.valueOf(result) + l;
            }
            retval.add(1, result);
            return retval;
        }
        catch (IOException e) {
            e.printStackTrace();
            return retval;
        }
    }

    private boolean containsDescription(File file) {
        File[] files;
        File[] fileArray = files = file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".description")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getProjectName() {
        return this.projectNameField.getText();
    }

    public ProjectDescription getSelectedExampleProject() {
        if (this.xmplSelectedButton != null) {
            return this.projectDescriptions.get(this.xmplSelectedButton.getText());
        }
        return null;
    }

    public String getSelectedExampleProjectName() {
        ProjectDescription pd = this.getSelectedExampleProject();
        if (pd != null) {
            return pd.getProjectName();
        }
        return null;
    }

    public URL getSelectedExampleProjectURL() {
        ProjectDescription pd = this.getSelectedExampleProject();
        if (pd != null) {
            return pd.getProjectURL();
        }
        return null;
    }

    public boolean isCreateExample() {
        return this.mainSelectedButton == this.xmplButton;
    }

    private void updatePage() {
        this.updateEnabledStatus();
        String msg = MainPage.validateProjectName(this.getProjectName());
        this.setPageComplete(msg == null);
        this.setErrorMessage(msg);
        if (msg == null) {
            ProjectDescription pd;
            msg = "This wizard will create a new DIME project";
            if (this.isCreateExample() && (pd = this.getSelectedExampleProject()) != null) {
                msg = pd.getProjectDescription();
            }
            this.setDescription(msg);
        }
    }

    private void updateEnabledStatus() {
        boolean isXmpl = this.isCreateExample();
        Control[] controlArray = this.xmplGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(isXmpl);
            ++n2;
        }
    }

    private static String validateProjectName(String projectName) {
        if (projectName.isEmpty()) {
            return "Enter project name";
        }
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    if (p.getName().equals(projectName)) {
                        return "Project: " + projectName + " already exists";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (projectName.matches(".*[:/\\\\\"&<>\\?#,;].*")) {
            return "The project name contains illegal characters (:/\"&<>?#,;)";
        }
        return null;
    }
}

