/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.ui.wizard;

import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import info.scce.dime.ui.wizard.DotProjectGenerator;
import info.scce.dime.ui.wizard.GitLabCIGenerator;
import info.scce.dime.ui.wizard.SimpleGeneratorInterface;
import info.scce.dime.ui.wizard.pages.MainPage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public class DIMEAppWizard
extends Wizard
implements INewWizard {
    private final String EXAMPLE_BUNDLE_ID = "info.scce.dime.examples";
    private final String EMPTY_PROJECT_PATH = "/emptyproject/";
    private final String COMMONS_PATH = "/commons/";
    MainPage main = new MainPage("New DIME Application");

    public void addPages() {
        this.addPage((IWizardPage)this.main);
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New DIME Application");
    }

    public boolean performFinish() {
        String projectName = this.projectName();
        System.out.println("project.name: " + projectName);
        try {
            URL projectURL = this.projectURL();
            System.out.println("project.url: " + projectURL);
            URL commonsURL = this.projectURL("/commons/");
            System.out.println("commons.url: " + commonsURL);
            IProject project = this.createProject(projectName);
            File projectDirectory = project.getLocation().toFile();
            this.copyFiles(projectDirectory, projectURL, commonsURL);
            this.generateGitLabCI(projectDirectory, "latest");
            this.generateDotProject(projectDirectory, projectName);
            this.refreshProject(project);
        }
        catch (DIMEAppWizardException e) {
            throw new RuntimeException("Failed to create new DIME App");
        }
        return true;
    }

    private void refreshProject(IProject project) throws DIMEAppWizardException {
        try {
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new DIMEAppWizardException("Failed to refresh project", (Exception)((Object)e));
        }
    }

    private URL projectURL() throws DIMEAppWizardException {
        URL projectURL = this.projectURL("/emptyproject/");
        if (this.main.isCreateExample()) {
            projectURL = this.main.getSelectedExampleProjectURL();
        }
        return projectURL;
    }

    private URL projectURL(String path) throws DIMEAppWizardException {
        Bundle bundle = Platform.getBundle((String)"info.scce.dime.examples");
        if (bundle == null) {
            throw new DIMEAppWizardException("Failed to get bundle");
        }
        Enumeration entries = bundle.findEntries(path, "*", false);
        if (!entries.hasMoreElements()) {
            throw new DIMEAppWizardException("No Entries in bundle");
        }
        URL url = (URL)entries.nextElement();
        System.out.println("URL: " + url);
        return url;
    }

    private String projectName() {
        String projectName = this.main.getProjectName();
        if (projectName == null || projectName.isEmpty()) {
            projectName = this.main.getSelectedExampleProjectName();
        }
        if (projectName == null || projectName.isEmpty()) {
            projectName = "NewApp";
        }
        return projectName;
    }

    private IProject createProject(String projectName) throws DIMEAppWizardException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root == null) {
            throw new DIMEAppWizardException("Workspace Root is null...");
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        ArrayList<String> srcFolders = new ArrayList<String>();
        srcFolders.add("src");
        HashSet<String> reqBundle = new HashSet<String>();
        reqBundle.add("org.eclipse.core.runtime");
        IProject project = ProjectCreator.createProject((String)projectName, srcFolders, Collections.emptyList(), reqBundle, Collections.emptyList(), Collections.emptyList(), (IProgressMonitor)monitor, (boolean)true);
        if (project == null) {
            throw new DIMEAppWizardException("Failed to create project");
        }
        return project;
    }

    private void generateDotProject(File destination, String projectName) throws DIMEAppWizardException {
        this.generate(destination, new DotProjectGenerator(projectName), ".project");
    }

    private void generateGitLabCI(File destination, String dimeVersion) throws DIMEAppWizardException {
        this.generate(destination, new GitLabCIGenerator(dimeVersion), ".gitlab-ci.yml");
    }

    private void generate(File destination, SimpleGeneratorInterface generator, String filename) throws DIMEAppWizardException {
        try {
            this.writeFile(new ByteArrayInputStream(generator.generate().toString().getBytes()), new File(destination, filename));
        }
        catch (IOException e) {
            throw new DIMEAppWizardException("Failed to generate " + filename + " file", e);
        }
    }

    private void copyFiles(File destinationFile, URL selectedProjectURL, URL commons) throws DIMEAppWizardException {
        try {
            File sourceFile = this.sourceFile(selectedProjectURL);
            File commonsFile = this.sourceFile(commons);
            this.copy(sourceFile, destinationFile);
            this.copy(commonsFile, destinationFile);
        }
        catch (IOException e) {
            throw new DIMEAppWizardException("Failed to copy static files", e);
        }
    }

    private void writeFile(InputStream fis, File destinationFile) throws IOException {
        int count;
        byte[] buffer = new byte[1000];
        destinationFile.createNewFile();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(destinationFile));
        while ((count = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, count);
        }
        fis.close();
        fos.close();
    }

    private void copy(File sourceFile, File destinationFile) throws IOException {
        if (sourceFile.isDirectory()) {
            destinationFile.mkdir();
            File[] fileArray = sourceFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File newDest = new File(destinationFile, file.getName());
                this.copy(file, newDest);
                ++n2;
            }
        } else if (!destinationFile.exists()) {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(sourceFile));
            this.writeFile(fis, destinationFile);
        }
    }

    private File sourceFile(URL selectedProjectURL) throws IOException {
        URL url = FileLocator.toFileURL((URL)selectedProjectURL);
        URI uri = URI.createFileURI((String)url.getPath());
        return new File(uri.toFileString());
    }

    class DIMEAppWizardException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DIMEAppWizardException(String message, Exception cause) {
            super(message, cause);
        }

        public DIMEAppWizardException(String message) {
            super(message);
        }
    }
}

