/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.generator;

import de.jabc.cinco.meta.core.utils.BuildProperties;
import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mgl.Annotation;
import mgl.GraphModel;
import mgl.MGLModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.util.StringInputStream;
import org.osgi.framework.Bundle;

public class CreateCodeGeneratorPlugin {
    private static final String GENERATOR_RUNTIME_BUNDLE_NAME = "de.jabc.cinco.meta.plugin.generator.runtime";
    private GeneratorUtils generatorUtils = GeneratorUtils.getInstance();

    public void execute(MGLModel mglModel) {
        this.createCodeGeneratorEclipseProject(mglModel);
    }

    public IProject createCodeGeneratorEclipseProject(MGLModel mglModel) {
        for (GraphModel graphModel : mglModel.getGraphModels()) {
            Annotation anno = this.getGeneratableAnnotation(graphModel);
            if (anno == null) continue;
            String bundleName = "";
            boolean localBundle = false;
            String implementingClassName = "";
            if (anno.getValue().size() == 3) {
                bundleName = (String)anno.getValue().get(0);
                localBundle = bundleName.isEmpty();
                implementingClassName = (String)anno.getValue().get(1);
            } else if (anno.getValue().size() == 2) {
                bundleName = "";
                localBundle = true;
                implementingClassName = (String)anno.getValue().get(0);
            }
            String packageName = implementingClassName.replaceAll("\\.[^.]+$", "");
            String className = implementingClassName.replaceAll("^(.+\\.)*", "");
            if (!implementingClassName.equals(String.valueOf(packageName) + "." + className)) {
                System.err.println("Skipping '@generatable' annotation for graph model '" + graphModel.getName() + "', beacuse generator FQN is malformed: " + implementingClassName);
                continue;
            }
            ArrayList<String> srcFolders = new ArrayList<String>();
            srcFolders.add("src");
            HashSet<String> requiredBundles = new HashSet<String>();
            Path graphModelPath = new Path(graphModel.eResource().getURI().toPlatformString(true));
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource graphModelResource = workspaceRoot.findMember((IPath)graphModelPath);
            String symbolicName = graphModelResource != null ? ProjectCreator.getProjectSymbolicName((IProject)graphModelResource.getProject()) : this.getPackage(graphModel);
            if (localBundle) {
                bundleName = symbolicName;
            }
            BundleRegistry.INSTANCE.addBundle(bundleName, false, true);
            BundleRegistry.INSTANCE.addBundle(GENERATOR_RUNTIME_BUNDLE_NAME, false);
            requiredBundles.add(symbolicName);
            requiredBundles.add("org.eclipse.ui");
            requiredBundles.add("org.eclipse.core.runtime");
            requiredBundles.add("org.eclipse.core.resources");
            requiredBundles.add("org.eclipse.ui.navigator");
            requiredBundles.add("org.eclipse.emf.common");
            requiredBundles.add("org.eclipse.emf.ecore");
            requiredBundles.add("org.eclipse.graphiti.ui");
            requiredBundles.add("org.eclipse.ui.workbench");
            requiredBundles.add("de.jabc.cinco.meta.core.mgl.model");
            requiredBundles.add(GENERATOR_RUNTIME_BUNDLE_NAME);
            IProject project = workspaceRoot.getProject(bundleName);
            if (project != null && project.exists()) {
                this.exportPackage(project, bundleName, packageName, className);
            } else {
                try {
                    String modelClassName = graphModel.getName();
                    String modelPackage = this.getPackage(graphModel).concat(".").concat(modelClassName.toLowerCase());
                    this.createGeneratorStubProject(project, packageName, className, modelPackage, modelClassName, graphModel);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (!localBundle) {
                requiredBundles.add(bundleName);
            } else {
                Bundle bundle = Platform.getBundle((String)GENERATOR_RUNTIME_BUNDLE_NAME);
                try {
                    ProjectCreator.addRequiredBundle((IProject)project, (Bundle)bundle);
                }
                catch (IOException | CoreException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            try {
                this.addGeneratorEntry(project, graphModel);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Annotation getGeneratableAnnotation(GraphModel graphModel) {
        for (Annotation anno : graphModel.getAnnotations()) {
            if (!anno.getName().equals("generatable")) continue;
            return anno;
        }
        return null;
    }

    private void addGeneratorEntry(IProject pr, GraphModel graphModel) throws CoreException {
        String bundleName = null;
        String implementingClassName = null;
        String outlet = null;
        ArrayList<String[]> generators = new ArrayList<String[]>();
        for (Annotation anno : graphModel.getAnnotations()) {
            if (!anno.getName().equals("generatable")) continue;
            if (anno.getValue().size() == 3) {
                bundleName = (String)anno.getValue().get(0);
                implementingClassName = (String)anno.getValue().get(1);
                outlet = (String)anno.getValue().get(2);
            } else if (anno.getValue().size() == 2) {
                implementingClassName = (String)anno.getValue().get(0);
                outlet = (String)anno.getValue().get(1);
                bundleName = ProjectCreator.getProjectSymbolicName((IProject)pr);
            }
            String[] a = new String[]{bundleName, implementingClassName, outlet};
            generators.add(a);
        }
        String extension = this.generateExtension(graphModel, generators);
        IFile plFile = pr.getFile("plugin.xml");
        this.addExtension(plFile, extension, graphModel.getName());
    }

    public String removeGeneratorEntries(String pluginxml, String graphmodelName) {
        String regex = "<extension.*?</extension>";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(pluginxml);
        while (matcher.find()) {
            if (!matcher.group().contains(String.format("<!--@MetaPlugin Generatable %s-->", graphmodelName))) continue;
            pluginxml = pluginxml.replace(String.valueOf(matcher.group()) + "\n", "");
        }
        return pluginxml;
    }

    private void addExtension(IFile plFile, String extension, String graphModelName) throws CoreException {
        if (plFile.exists()) {
            InputStream l = plFile.getContents(true);
            String contents = new Scanner(l, "UTF-8").useDelimiter("\\A").next();
            contents = this.removeGeneratorEntries(contents, graphModelName);
            contents = contents.replace("</plugin>", String.valueOf(extension) + "\n" + "</plugin>");
            plFile.setContents((InputStream)new StringInputStream(contents), true, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            String pluginXML = String.format("<plugin>%s\n</plugin>", extension);
            plFile.create((InputStream)new StringInputStream(pluginXML), true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private String generateExtension(GraphModel graphModel, ArrayList<String[]> generators) {
        StringBuilder sb = new StringBuilder();
        sb.append("<extension\npoint=\"de.jabc.cinco.meta.plugin.generator.runtime.registry\">\n" + String.format("<!--@MetaPlugin Generatable %s-->\n", graphModel.getName()) + "<graphmodel\n");
        sb.append(String.format("      class=\"%s\">\n", this.generateFullyQualifiedName(graphModel)));
        sb.append("</graphmodel>\n");
        for (String[] gen : generators) {
            sb.append("<generator\n");
            if (!gen[0].equals("")) {
                sb.append(String.format("bundle_id=\"%s\"\n", gen[0]));
            } else {
                sb.append(String.format("bundle_id=\"%s\"\n", this.getPackage(graphModel)));
            }
            sb.append(String.format("class=\"%s\"\n", gen[1]));
            sb.append(String.format("outlet=\"%s\">\n</generator>\n", gen[2]));
        }
        sb.append("</extension>");
        return sb.toString();
    }

    private String getPackage(GraphModel graphModel) {
        return MGLUtil.mglModel((Object)graphModel).getPackage();
    }

    private Object generateFullyQualifiedName(GraphModel graphModel) {
        String name = graphModel.getName();
        String nameLower = this.generatorUtils.getFileName((MGLModel)graphModel.eContainer()).toLowerCase();
        String packageName = this.getPackage(graphModel);
        String fqName = String.format("%s.%s.%s", packageName, nameLower, name);
        return fqName;
    }

    private IProject createGenerationHandlerProject(List<String> exportedPackages, List<String> additionalNature, String projectName, List<IProject> referencedProjects, List<String> srcFolders, Set<String> requiredBundles) throws IOException, FileNotFoundException, CoreException {
        if (!new Path("/" + projectName).toFile().exists()) {
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject tvProject = ProjectCreator.createProject((String)projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNature, (IProgressMonitor)progressMonitor, (boolean)false);
            String projectPath = tvProject.getLocation().makeAbsolute().toPortableString();
            File maniFile = tvProject.getLocation().append("META-INF/MANIFEST.MF").toFile();
            BufferedWriter bufwr = new BufferedWriter(new FileWriter(maniFile, true));
            bufwr.append("Bundle-Activator: " + projectName + ".Activator\n");
            bufwr.append("Bundle-ActivationPolicy: lazy\n");
            bufwr.flush();
            bufwr.close();
            IFile bpf = (IFile)tvProject.findMember("build.properties");
            BuildProperties buildProperties = BuildProperties.loadBuildProperties((IFile)bpf);
            buildProperties.appendBinIncludes("plugin.xml");
            buildProperties.store(bpf, (IProgressMonitor)progressMonitor);
            return tvProject;
        }
        return null;
    }

    private void exportPackage(IProject pr, String bundleName, String packageName, String className) {
        try {
            File manniFile = pr.getFile("/META-INF/MANIFEST.MF").getLocation().makeAbsolute().toFile();
            Manifest manni = new Manifest(new FileInputStream(manniFile));
            Attributes mainAttr = manni.getMainAttributes();
            String oldValues = mainAttr.getValue("Export-Package");
            if (oldValues == null) {
                oldValues = new String();
            }
            if (!oldValues.contains(packageName)) {
                String newValues = oldValues.isEmpty() ? packageName : oldValues.concat(",").concat(packageName);
                mainAttr.putValue("Export-Package", newValues);
                manni.write(new FileOutputStream(manniFile));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while exporting Package", e);
        }
    }

    private void createGeneratorStubProject(IProject pr, String packageName, String className, String modelPackage, String modelClassName, GraphModel graphModel) throws RuntimeException {
        try {
            String graphModelProjectName = ProjectCreator.getProject((Resource)graphModel.eResource()).getName();
            String projectName = pr.getName();
            HashSet<String> requiredBundles = new HashSet<String>();
            requiredBundles.add("de.jabc.cinco.meta.core.mgl.model");
            requiredBundles.add("org.eclipse.equinox.registry");
            requiredBundles.add(GENERATOR_RUNTIME_BUNDLE_NAME);
            requiredBundles.add(graphModelProjectName);
            ArrayList referencedProjects = new ArrayList();
            ArrayList<String> srcFolders = new ArrayList<String>();
            srcFolders.add("src");
            ArrayList<String> exportedPackages = new ArrayList<String>();
            exportedPackages.add(packageName);
            ArrayList additionalNature = new ArrayList();
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject tvProject = ProjectCreator.createProject((String)projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNature, (IProgressMonitor)progressMonitor, (boolean)false);
            tvProject.refreshLocal(2, (IProgressMonitor)progressMonitor);
            try {
                ProjectCreator.createJavaClass((IProject)pr, (String)packageName, (String)className, (IFolder)tvProject.getFolder("/src/"), (String)this.stubContents(packageName, className, modelPackage, modelClassName), (IProgressMonitor)progressMonitor);
            }
            catch (JavaModelException e) {
                if (e.getJavaModelStatus().getCode() != 977) {
                    throw e;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating Generator Stub Project", e);
        }
    }

    private String stubContents(String packageName, String className, String modelPackage, String modelClassName) {
        String contents = "package %s;\n\nimport org.eclipse.core.runtime.IPath;\nimport %s.%s;\nimport org.eclipse.core.runtime.IProgressMonitor;\nimport de.jabc.cinco.meta.plugin.generator.runtime.IGenerator;\n\n\npublic class %s implements IGenerator<%s>{\n\tpublic void generate(%s model,IPath outlet, IProgressMonitor monitor){\n\n\t}\n\n}\n";
        return String.format(contents, packageName, modelPackage, modelClassName, className, modelClassName, modelClassName);
    }
}

