/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.jabc.cinco.meta.core.ge.style.ui.internal.StyleActivator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import style.Style;

public class StyleHyperLinkHelper
extends HyperlinkHelper {
    @Inject
    Provider<XtextHyperlink> provider;
    @Inject
    IResourceServiceProvider.Registry reg;

    public StyleHyperLinkHelper() {
        StyleActivator.getInstance().getInjector("de.jabc.cinco.meta.core.ge.style.Style").injectMembers((Object)this);
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObjectAtOffsetHelper oHelper = new EObjectAtOffsetHelper();
        EObject object = oHelper.resolveElementAt(resource, offset);
        if (!(object instanceof Style)) {
            return;
        }
        Style style = (Style)object;
        String context = style.getAppearanceProvider();
        String searchClass = context.substring(1, context.length() - 1).trim();
        ICompositeNode styleNode = NodeModelUtils.getNode((EObject)style);
        INode appearanceProviderNode = this.findAppearanceProviderNode(styleNode);
        if (appearanceProviderNode == null) {
            return;
        }
        Region region = new Region(appearanceProviderNode.getOffset(), appearanceProviderNode.getLength());
        String path = this.searchPath(searchClass);
        if (path == null) {
            return;
        }
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        URI normUri = uri.isPlatformResource() ? uri : uriConverter.normalize(uri);
        XtextHyperlink xtextHyperlink = (XtextHyperlink)this.getHyperlinkProvider().get();
        xtextHyperlink.setHyperlinkRegion(region);
        xtextHyperlink.setHyperlinkText(this.getLabelProvider().getText((Object)style.getName()));
        xtextHyperlink.setURI(normUri);
        acceptor.accept((IHyperlink)xtextHyperlink);
    }

    private INode findAppearanceProviderNode(ICompositeNode styleNode) {
        for (INode current : styleNode.getAsTreeIterable()) {
            Keyword kw;
            if (!(current.getGrammarElement() instanceof Keyword) || !"appearanceProvider".equals((kw = (Keyword)current.getGrammarElement()).getValue())) continue;
            return this.findRuleCall(current);
        }
        return null;
    }

    private INode findRuleCall(INode appearanceProviderNode) {
        INode current = appearanceProviderNode;
        while (current.getNextSibling() != null) {
            EObject grammarElement = current.getGrammarElement();
            if (grammarElement instanceof RuleCall) {
                return current;
            }
            current = current.getNextSibling();
        }
        return null;
    }

    private String searchPath(String searchClass) {
        IProject[] projects;
        String path = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            IJavaProject jproject = JavaCore.create((IProject)iProject);
            try {
                IType type = jproject.findType(searchClass);
                if (type != null) {
                    return type.getPath().toString();
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return path;
    }
}

