/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.runtime.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractIDValueConverter;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.conversion.impl.INTValueConverter;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.nodemodel.INode;

@Singleton
public class TerminalConverters
extends AbstractDeclarativeValueConverterService {
    private static final Pattern ID_PATTERN = Pattern.compile("\\p{Alpha}\\w*");
    @Inject
    private AbstractIDValueConverter idValueConverter;
    @Inject
    private INTValueConverter intValueConverter;
    @Inject
    private STRINGValueConverter stringValueConverter;

    @ValueConverter(rule="_EString")
    public IValueConverter<String> EString() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, INode node) {
                if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
                    return (String)TerminalConverters.this.STRING().toValue(string, node);
                }
                return (String)TerminalConverters.this.ID().toValue(string, node);
            }

            protected String internalToString(String value) {
                if (ID_PATTERN.matcher(value).matches()) {
                    return TerminalConverters.this.ID().toString((Object)value);
                }
                return TerminalConverters.this.STRING().toString((Object)value);
            }
        };
    }

    @ValueConverter(rule="_EDate")
    public IValueConverter<Date> EDate() {
        return new AbstractNullSafeConverter<Date>(){
            final String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

            protected String internalToString(Date value) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                return TerminalConverters.this.STRING().toString((Object)fmt.format(value));
            }

            protected Date internalToValue(String string, INode node) throws ValueConverterException {
                string = (String)TerminalConverters.this.STRING().toValue(string, node);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                try {
                    return fmt.parse(string);
                }
                catch (ParseException e) {
                    throw new ValueConverterException("Invalid timestamp format. Use 'HH:mm:ss MM/dd/yyyy'", node, (Exception)e);
                }
            }
        };
    }

    @ValueConverter(rule="_ID")
    public IValueConverter<String> ID() {
        return this.idValueConverter;
    }

    @ValueConverter(rule="_INT")
    public IValueConverter<Integer> INT() {
        return this.intValueConverter;
    }

    @ValueConverter(rule="_STRING")
    public IValueConverter<String> STRING() {
        return this.stringValueConverter;
    }
}

