/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.runtime.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.registry.NonEmptyIdentityRegistry;
import de.jabc.cinco.meta.core.utils.registry.NonEmptyRegistry;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalContainer;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Transformer {
    private Map<InternalIdentifiableElement, InternalIdentifiableElement> counterparts = new IdentityHashMap<InternalIdentifiableElement, InternalIdentifiableElement>();
    private Map<String, InternalIdentifiableElement> baseElements = CollectionLiterals.newHashMap();
    private Map<String, List<Procedures.Procedure1<? super String>>> replacements = new NonEmptyRegistry((Function)new Function<String, List<Procedures.Procedure1<? super String>>>(){

        @Override
        public List<Procedures.Procedure1<? super String>> apply(String it) {
            return CollectionLiterals.newArrayList();
        }
    });
    private Set<InternalIdentifiableElement> resolved = CollectionLiterals.newHashSet();
    private List<InternalEdge> edges = CollectionLiterals.newArrayList();
    private final NonEmptyIdentityRegistry<InternalModelElementContainer, List<InternalModelElement>> nodesInitialOrder = new NonEmptyIdentityRegistry((Function)new Function<InternalModelElementContainer, List<InternalModelElement>>(){

        @Override
        public List<InternalModelElement> apply(InternalModelElementContainer it) {
            return CollectionLiterals.newArrayList();
        }
    });
    private Set<EFactory> modelFactories;
    private Set<EPackage> modelPackages;

    public Transformer(EFactory modelFactory, EPackage modelPackage, EClass modelClass) {
        HashSet<EFactory> _hashSet = new HashSet<EFactory>(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EFactory[]{modelFactory})));
        HashSet<EPackage> _hashSet_1 = new HashSet<EPackage>(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{modelPackage})));
        new Transformer(_hashSet, _hashSet_1, modelClass);
    }

    public Transformer(Set<EFactory> modelFactories, Set<EPackage> modelPackages, EClass modelClass) {
        this.modelFactories = modelFactories;
        this.modelPackages = modelPackages;
    }

    public InternalGraphModel transform(final InternalGraphModel gtxInternal) {
        InternalGraphModel _xblockexpression = null;
        InternalIdentifiableElement baseModel = this.transform((InternalIdentifiableElement)gtxInternal);
        Procedures.Procedure1<InternalGraphModel> _function = new Procedures.Procedure1<InternalGraphModel>(){

            public void apply(final InternalGraphModel it) {
                Functions.Function1<InternalModelElement, Integer> _function = new Functions.Function1<InternalModelElement, Integer>(){

                    public Integer apply(InternalModelElement it) {
                        return Transformer.this.getIndex(it);
                    }
                };
                Consumer<InternalModelElement> _function_1 = new Consumer<InternalModelElement>(){

                    @Override
                    public void accept(InternalModelElement elm) {
                        InternalIdentifiableElement _transform = Transformer.this.transform((InternalIdentifiableElement)elm);
                        InternalModelElement baseElm = (InternalModelElement)_transform;
                        it.getModelElements().add((Object)baseElm);
                    }
                };
                IterableExtensions.sortBy((Iterable)gtxInternal.getModelElements(), (Functions.Function1)_function).forEach(_function_1);
                Transformer.this.transferEdges((List<InternalModelElement>)it.getModelElements());
                it.getModelElements().addAll(Transformer.this.edges);
            }
        };
        _xblockexpression = (InternalGraphModel)ObjectExtensions.operator_doubleArrow((Object)((InternalGraphModel)baseModel), (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public List<InternalModelElement> getNodesInitialOrder(InternalModelElementContainer container) {
        return (List)this.nodesInitialOrder.get((Object)container);
    }

    public void transferEdges(List<InternalModelElement> list) {
        Consumer<InternalModelElement> _function = new Consumer<InternalModelElement>(){

            @Override
            public void accept(InternalModelElement it) {
                if (it instanceof InternalNode) {
                    Transformer.this.transferEdges((InternalNode)it);
                }
            }
        };
        list.forEach(_function);
    }

    public void transferEdges(final InternalNode node) {
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"outgoingEdges");
            }
        };
        Consumer<EReference> _function_1 = new Consumer<EReference>(){

            @Override
            public void accept(EReference ref) {
                Object edges = Transformer.this.transformValue(node.eGet((EStructuralFeature)ref));
                if (edges != null) {
                    Transformer.this.edges.addAll((List)edges);
                }
            }
        };
        IterableExtensions.filter(this.getReferences((EObject)node), (Functions.Function1)_function).forEach(_function_1);
        if (node instanceof InternalContainer) {
            this.transferEdges((List<InternalModelElement>)((InternalContainer)node).getModelElements());
        }
    }

    public InternalIdentifiableElement transform(InternalIdentifiableElement gtxInternal) {
        return this.transform(gtxInternal, true);
    }

    public InternalIdentifiableElement transform(final InternalIdentifiableElement gtxInternal, final boolean resolveReferences) {
        InternalIdentifiableElement _xblockexpression = null;
        InternalIdentifiableElement _elvis = null;
        InternalIdentifiableElement _counterpart = this.getCounterpart((EObject)gtxInternal);
        if (_counterpart != null) {
            _elvis = _counterpart;
        } else {
            InternalIdentifiableElement _baseInternal = this.toBaseInternal(gtxInternal);
            Procedures.Procedure1<InternalIdentifiableElement> _function = new Procedures.Procedure1<InternalIdentifiableElement>(){

                public void apply(InternalIdentifiableElement it) {
                    Transformer.this.transformAttributes(it, gtxInternal);
                    Transformer.this.cache(it, gtxInternal);
                }
            };
            _elvis = (InternalIdentifiableElement)ObjectExtensions.operator_doubleArrow((Object)_baseInternal, (Procedures.Procedure1)_function);
        }
        InternalIdentifiableElement cp = _elvis;
        Procedures.Procedure1<InternalIdentifiableElement> _function_1 = new Procedures.Procedure1<InternalIdentifiableElement>(){

            public void apply(InternalIdentifiableElement it) {
                if (resolveReferences && !Transformer.this.resolved.contains(gtxInternal)) {
                    Transformer.this.resolved.add(gtxInternal);
                    Transformer.this.transformReferences(it, gtxInternal);
                }
            }
        };
        _xblockexpression = (InternalIdentifiableElement)ObjectExtensions.operator_doubleArrow((Object)cp, (Procedures.Procedure1)_function_1);
        return _xblockexpression;
    }

    private InternalIdentifiableElement transformAttributes(InternalIdentifiableElement baseInternal, InternalIdentifiableElement gtxInternal) {
        Procedures.Procedure1<InternalIdentifiableElement> _function = new Procedures.Procedure1<InternalIdentifiableElement>(){

            public void apply(InternalIdentifiableElement it) {
                String _xifexpression = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getId());
                _xifexpression = _isNullOrEmpty ? EcoreUtil.generateUUID() : it.getId();
                String baseId = _xifexpression;
                EcoreUtil.setID((EObject)it.getElement(), (String)baseId);
                EcoreUtil.setID((EObject)it, (String)(String.valueOf(baseId) + "_INTERNAL"));
            }
        };
        return (InternalIdentifiableElement)ObjectExtensions.operator_doubleArrow((Object)baseInternal, (Procedures.Procedure1)_function);
    }

    private void transformReferences(final InternalIdentifiableElement baseInternal, final InternalIdentifiableElement gtxInternal) {
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                String _name = it.getName();
                return !Objects.equal((Object)_name, (Object)"element");
            }
        };
        Consumer<EReference> _function_1 = new Consumer<EReference>(){

            @Override
            public void accept(final EReference ref) {
                Object baseValue;
                Object refValue = gtxInternal.eGet((EStructuralFeature)ref);
                Object _switchResult = null;
                boolean _matched = false;
                if (refValue instanceof IdentifiableElement) {
                    _matched = true;
                    IdentifiableElement _elvis = null;
                    InternalIdentifiableElement _baseElement = Transformer.this.getBaseElement((IdentifiableElement)refValue);
                    IdentifiableElement _element = null;
                    if (_baseElement != null) {
                        _element = _baseElement.getElement();
                    }
                    if (_element != null) {
                        _elvis = _element;
                    } else {
                        IdentifiableElement _xblockexpression = null;
                        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                            public void apply(String theID) {
                                Transformer.this.setFeatureValue(baseInternal, ref, Transformer.this.getBaseElement(theID).getElement());
                            }
                        };
                        Transformer.this.addReplacementRequest(((IdentifiableElement)refValue).getId(), (Procedures.Procedure1<? super String>)_function);
                        _elvis = _xblockexpression = (IdentifiableElement)refValue;
                    }
                    _switchResult = _elvis;
                }
                if (!_matched && refValue instanceof InternalIdentifiableElement) {
                    _matched = true;
                    _switchResult = (InternalIdentifiableElement)refValue;
                }
                if (!_matched) {
                    _switchResult = Transformer.this.transformValue(refValue);
                }
                if ((baseValue = _switchResult) != null) {
                    Transformer.this.setFeatureValue(baseInternal, ref, baseValue);
                }
            }
        };
        IterableExtensions.filter(this.getReferences((EObject)baseInternal), (Functions.Function1)_function).forEach(_function_1);
    }

    private Object transformValue(Object value) {
        Object _switchResult = null;
        boolean _matched = false;
        if (value instanceof InternalGraphModel) {
            _matched = true;
            _switchResult = this.transform((InternalGraphModel)value);
        }
        if (!_matched && value instanceof InternalIdentifiableElement) {
            _matched = true;
            _switchResult = this.transform((InternalIdentifiableElement)value);
        }
        if (!_matched && value instanceof List) {
            _matched = true;
            Functions.Function1<Object, Integer> _function = new Functions.Function1<Object, Integer>(){

                public Integer apply(Object it) {
                    return Transformer.this.getIndex(it);
                }
            };
            Functions.Function1<Object, Object> _function_1 = new Functions.Function1<Object, Object>(){

                public Object apply(Object it) {
                    return Transformer.this.transformValue(it);
                }
            };
            _switchResult = ListExtensions.map((List)IterableExtensions.sortBy((Iterable)((Iterable)value), (Functions.Function1)_function), (Functions.Function1)_function_1);
        }
        if (!_matched && value instanceof EObject) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched && Objects.equal((Object)value, null)) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched) {
            Object _xblockexpression = null;
            this.warn("unmatched value type: " + value);
            _xblockexpression = value;
            _switchResult = _xblockexpression;
        }
        return _switchResult;
    }

    private void setFeatureValue(InternalIdentifiableElement baseInternal, EReference ref, Object value) {
        boolean refDeliver = ref.eDeliver();
        ref.eSetDeliver(false);
        boolean baseDeliver = baseInternal.eDeliver();
        baseInternal.eSetDeliver(false);
        baseInternal.eSet((EStructuralFeature)ref, value);
        baseInternal.eSetDeliver(baseDeliver);
        ref.eSetDeliver(refDeliver);
    }

    protected int _getIndex(Object it) {
        return -1;
    }

    public int getInitialIndex(InternalModelElement elm) {
        int _xifexpression = 0;
        InternalModelElementContainer _container = elm.getContainer();
        boolean _tripleNotEquals = _container != null;
        _xifexpression = _tripleNotEquals ? ((List)this.nodesInitialOrder.get((Object)elm.getContainer())).indexOf(elm) : -1;
        return _xifexpression;
    }

    public InternalIdentifiableElement toBaseInternal(InternalIdentifiableElement internal) {
        EClass _eClass = internal.eClass();
        EList _eSuperTypes = internal.eClass().getESuperTypes();
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(final EClass it) {
                Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                    public Boolean apply(EPackage mp) {
                        return Transformer.this.knows(mp, it);
                    }
                };
                return IterableExtensions.exists(Transformer.this.modelPackages, (Functions.Function1)_function);
            }
        };
        Functions.Function1<EClass, EObject> _function_1 = new Functions.Function1<EClass, EObject>(){

            public EObject apply(final EClass it) {
                Functions.Function1<EFactory, Boolean> _function = new Functions.Function1<EFactory, Boolean>(){

                    public Boolean apply(EFactory mf) {
                        return Transformer.this.checkFactoryCreateMethod(mf, it);
                    }
                };
                EFactory _findFirst = (EFactory)IterableExtensions.findFirst(Transformer.this.modelFactories, (Functions.Function1)_function);
                EObject _create = null;
                if (_findFirst != null) {
                    _create = _findFirst.create(it);
                }
                return _create;
            }
        };
        IdentifiableElement baseNonInternal = (IdentifiableElement)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EClass[]{_eClass})), (Iterable)_eSuperTypes), (Functions.Function1)_function), (Functions.Function1)_function_1), IdentifiableElement.class));
        EList _eAdapters = baseNonInternal.getInternalElement_().eAdapters();
        ArrayList adapters = new ArrayList(_eAdapters);
        baseNonInternal.getInternalElement_().eAdapters().clear();
        IdentifiableElement it = baseNonInternal;
        boolean _matched = false;
        if (it instanceof GraphModel) {
            _matched = true;
            ((GraphModel)it).setInternalElement_((InternalGraphModel)internal);
        }
        if (!_matched && it instanceof ModelElement) {
            _matched = true;
            ((ModelElement)it).setInternalElement_((InternalModelElement)internal);
        }
        if (!_matched && it instanceof Type) {
            _matched = true;
            ((Type)it).setInternalElement_((InternalType)internal);
        }
        for (Adapter adapter : adapters) {
            internal.eAdapters().add((Object)adapter);
        }
        return internal;
    }

    private boolean checkFactoryCreateMethod(EFactory factory, EClass param) {
        try {
            String paramName;
            String factoryCreateClassName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)factory.create(param).getClass().getName().split("\\."))));
            if (factoryCreateClassName != null) {
                boolean _endsWith = factoryCreateClassName.endsWith("Impl");
                if (_endsWith) {
                    int _length = factoryCreateClassName.length();
                    int _minus = _length - 4;
                    factoryCreateClassName = factoryCreateClassName.substring(0, _minus);
                } else {
                    boolean _startsWith = factoryCreateClassName.startsWith("C");
                    if (_startsWith) {
                        factoryCreateClassName = factoryCreateClassName.substring(1);
                    }
                }
            }
            if ((paramName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)param.getName().split("\\."))))) != null && paramName.startsWith("Internal")) {
                paramName = paramName.substring(8);
            }
            return factoryCreateClassName != null && paramName != null && Objects.equal((Object)factoryCreateClassName, (Object)paramName);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private boolean knows(EPackage it, final EClass elmClazz) {
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                String _name_1 = elmClazz.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        };
        return IterableExtensions.exists((Iterable)Iterables.filter((Iterable)it.eContents(), EClass.class), (Functions.Function1)_function);
    }

    private EList<EReference> getReferences(EObject elm) {
        EClass _eClass = null;
        if (elm != null) {
            _eClass = elm.eClass();
        }
        EList _eAllReferences = null;
        if (_eClass != null) {
            _eAllReferences = _eClass.getEAllReferences();
        }
        return _eAllReferences;
    }

    public InternalIdentifiableElement getCounterpart(EObject elm) {
        return this.counterparts.get(elm);
    }

    public InternalIdentifiableElement getBaseElement(IdentifiableElement elm) {
        return this.getBaseElement(elm.getId());
    }

    public InternalIdentifiableElement getBaseElement(String id) {
        return this.baseElements.get(id);
    }

    public void registerBaseElement(final String id, InternalIdentifiableElement baseInternal) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)id);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.baseElements.put(id, baseInternal);
            Consumer<Procedures.Procedure1<? super String>> _function = new Consumer<Procedures.Procedure1<? super String>>(){

                @Override
                public void accept(Procedures.Procedure1<? super String> it) {
                    it.apply((Object)id);
                }
            };
            this.replacements.get(id).forEach(_function);
        }
    }

    public boolean addReplacementRequest(String id, Procedures.Procedure1<? super String> replacement) {
        return this.replacements.get(id).add(replacement);
    }

    private boolean cache(final InternalIdentifiableElement baseInternal, final InternalIdentifiableElement gtxInternal) {
        boolean _xblockexpression = false;
        Procedures.Procedure1<Map<InternalIdentifiableElement, InternalIdentifiableElement>> _function = new Procedures.Procedure1<Map<InternalIdentifiableElement, InternalIdentifiableElement>>(){

            public void apply(Map<InternalIdentifiableElement, InternalIdentifiableElement> it) {
                it.put(baseInternal, gtxInternal);
                it.put(gtxInternal, baseInternal);
            }
        };
        ObjectExtensions.operator_doubleArrow(this.counterparts, (Procedures.Procedure1)_function);
        this.registerBaseElement(gtxInternal.getId(), baseInternal);
        boolean _switchResult = false;
        if (baseInternal instanceof InternalEdge) {
            _switchResult = this.edges.add((InternalEdge)baseInternal);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private void warn(String msg) {
        String _simpleName = this.getClass().getSimpleName();
        String _plus = "[" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "] ";
        String _plus_2 = String.valueOf(_plus_1) + msg;
        System.err.println(_plus_2);
    }

    public int getIndex(Object it) {
        return this._getIndex(it);
    }
}

