/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.runtime.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.CincoProperties;
import de.jabc.cinco.meta.core.utils.registry.NonEmptyRegistry;
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.Transformer;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Node;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalPackage;
import graphmodel.internal._Decoration;
import graphmodel.internal._Point;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Serializer {
    private final NonEmptyRegistry<InternalModelElementContainer, List<InternalNode>> nodesSerializationOrder = new NonEmptyRegistry((Function)new Function<InternalModelElementContainer, List<InternalNode>>(){

        @Override
        public List<InternalNode> apply(InternalModelElementContainer it) {
            Functions.Function1<InternalNode, Integer> _function = new Functions.Function1<InternalNode, Integer>(){

                public Integer apply(InternalNode it) {
                    return Serializer.this.getOrderIndex(it);
                }
            };
            return IterableExtensions.sortBy(Serializer.this.getAllNodes(it), (Functions.Function1)_function);
        }
    });
    private final NonEmptyRegistry<InternalModelElementContainer, List<InternalNode>> nodesLayerOrder = new NonEmptyRegistry((Function)new Function<InternalModelElementContainer, List<InternalNode>>(){

        @Override
        public List<InternalNode> apply(InternalModelElementContainer it) {
            Functions.Function1<InternalNode, Integer> _function = new Functions.Function1<InternalNode, Integer>(){

                public Integer apply(InternalNode it) {
                    return Serializer.this.getLayer(it);
                }
            };
            return IterableExtensions.sortBy(Serializer.this.getAllNodes(it), (Functions.Function1)_function);
        }
    });
    private InternalGraphModel model;
    private Transformer transformer;
    protected boolean sorted;

    public Serializer(InternalGraphModel model, Transformer transformer) {
        this.model = model;
        this.transformer = transformer;
    }

    public String run() {
        return this.template().toString();
    }

    public CharSequence template() {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.name((EObject)this.model);
        _builder.append(_name);
        _builder.append(" ");
        String _nonInternalID = this.getNonInternalID((EObject)this.model);
        _builder.append(_nonInternalID);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        String _attributes = this.attributes((EObject)this.model);
        _builder.append(_attributes, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        String _containments = this.getContainments((InternalIdentifiableElement)this.model);
        _builder.append(_containments, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String toGratext(InternalNode node) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.name((EObject)node);
        _builder.append(_name);
        _builder.append(" ");
        String _nonInternalID = this.getNonInternalID((EObject)node);
        _builder.append(_nonInternalID);
        _builder.append(" ");
        CharSequence _placement = this.placement(node);
        _builder.append((Object)_placement);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _attributes = this.attributes((EObject)node);
        _builder.append(_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _containments = this.getContainments((InternalIdentifiableElement)node);
        _builder.append(_containments, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _edges = this.edges(node);
        _builder.append(_edges, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public String toGratext(InternalEdge edge) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("-");
        String _name = this.name((EObject)edge);
        _builder.append(_name);
        _builder.append("-> ");
        String _id = edge.getTargetElement().getId();
        _builder.append(_id);
        _builder.append(" ");
        CharSequence _route = this.route(edge);
        _builder.append((Object)_route);
        _builder.append(" ");
        String _decorations = this.decorations(edge);
        _builder.append(_decorations);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("id ");
        String _nonInternalID = this.getNonInternalID((EObject)edge);
        _builder.append(_nonInternalID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _attributes = this.attributes((EObject)edge);
        _builder.append(_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence placement(InternalNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("at ");
        int _x = node.getX();
        _builder.append((Object)_x);
        _builder.append(",");
        int _y = node.getY();
        _builder.append((Object)_y);
        _builder.append(" size ");
        int _width = node.getWidth();
        _builder.append((Object)_width);
        _builder.append(",");
        int _height = node.getHeight();
        _builder.append((Object)_height);
        CharSequence _index = this.index(node);
        _builder.append((Object)_index);
        return _builder;
    }

    public CharSequence index(InternalNode node) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        int layerIndex = this.getLayerIndex(node);
        StringConcatenation _xifexpression = null;
        int _serializationIndex = this.getSerializationIndex(node);
        boolean bl = _notEquals = _serializationIndex != layerIndex;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("index ");
            _builder.append((Object)layerIndex, " ");
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String name(EObject obj) {
        String _switchResult = null;
        EObject it = obj;
        boolean _matched = false;
        if (it instanceof InternalIdentifiableElement) {
            _matched = true;
            _switchResult = ((InternalIdentifiableElement)it).eClass().getName().replaceAll("^Gratext", "").replaceAll("^Internal", "");
        }
        if (!_matched) {
            _switchResult = it.eClass().getName();
        }
        return _switchResult;
    }

    public String attributes(EObject obj) {
        return this.toGratext(this.attributes(obj.eClass()), obj);
    }

    public Iterable<EStructuralFeature> attributes(EClass it) {
        Iterable _xblockexpression = null;
        Collection<Object> _xifexpression = null;
        boolean _contains = InternalPackage.eINSTANCE.getEClassifiers().contains((Object)it);
        if (_contains) {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        } else {
            EList _eAttributes = it.getEAttributes();
            EList _eReferences = it.getEReferences();
            Iterable _plus = Iterables.concat((Iterable)_eAttributes, (Iterable)_eReferences);
            Functions.Function1<EClass, Iterable<EStructuralFeature>> _function = new Functions.Function1<EClass, Iterable<EStructuralFeature>>(){

                public Iterable<EStructuralFeature> apply(EClass it) {
                    return Serializer.this.attributes(it);
                }
            };
            Iterable _flatten = Iterables.concat((Iterable)ListExtensions.map((List)it.getESuperTypes(), (Functions.Function1)_function));
            _xifexpression = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_flatten));
        }
        List retval = _xifexpression;
        Iterable _xifexpression_1 = null;
        if (this.sorted) {
            Functions.Function1<EStructuralFeature, Boolean> _function_1 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"libraryComponentUID");
                }
            };
            Iterable _filter = IterableExtensions.filter(retval, (Functions.Function1)_function_1);
            Functions.Function1<EStructuralFeature, Boolean> _function_2 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name_1;
                    boolean _notEquals;
                    boolean _not;
                    boolean _and = false;
                    String _name = it.getName();
                    boolean _startsWith = false;
                    if (_name != null) {
                        _startsWith = _name.startsWith("gratext_");
                    }
                    boolean bl = _not = !_startsWith;
                    _and = !_not ? false : (_notEquals = !Objects.equal((Object)(_name_1 = it.getName()), (Object)"libraryComponentUID"));
                    return _and;
                }
            };
            Functions.Function1<EStructuralFeature, String> _function_3 = new Functions.Function1<EStructuralFeature, String>(){

                public String apply(EStructuralFeature it) {
                    return it.getName();
                }
            };
            List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.filter(retval, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
            _xifexpression_1 = Iterables.concat((Iterable)_filter, (Iterable)_sortBy);
        } else {
            Functions.Function1<EStructuralFeature, Boolean> _function_4 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    boolean _startsWith = false;
                    if (_name != null) {
                        _startsWith = _name.startsWith("gratext_");
                    }
                    return !_startsWith;
                }
            };
            _xifexpression_1 = IterableExtensions.filter(retval, (Functions.Function1)_function_4);
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public <T> List<T> combine(Collection<? extends T> l1, Collection<? extends T> l2, Iterable<? extends T> l3) {
        return Stream.concat(l1.stream(), Stream.concat(l2.stream(), StreamSupport.stream(l3.spliterator(), false))).collect(Collectors.toList());
    }

    public String getContainments(InternalIdentifiableElement it) {
        String _switchResult = null;
        if (it instanceof InternalModelElementContainer) {
            Functions.Function1<InternalNode, String> _function = new Functions.Function1<InternalNode, String>(){

                public String apply(InternalNode it) {
                    return Serializer.this.toGratext(it);
                }
            };
            _switchResult = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)this.nodesSerializationOrder.get((Object)it)), (Functions.Function1)_function), (CharSequence)"\n");
        }
        return _switchResult;
    }

    public int getInitialIndex(InternalNode node) {
        return this.transformer.getInitialIndex((InternalModelElement)node);
    }

    public int getSerializationIndex(InternalNode node) {
        return ((List)this.nodesSerializationOrder.get((Object)node.getContainer())).indexOf(node);
    }

    public int getLayerIndex(InternalNode node) {
        return ((List)this.nodesLayerOrder.get((Object)node.getContainer())).indexOf(node);
    }

    public int getOrderIndex(InternalNode node) {
        int _xblockexpression = 0;
        int index = this.getInitialIndex(node);
        int _xifexpression = 0;
        _xifexpression = index < 0 ? this.getLayer(node) : index;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public int getLayer(InternalNode node) {
        ModelElement _element = node.getElement();
        return ((Node)_element).getLayer();
    }

    public CharSequence route(InternalEdge edge) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        boolean _isEmpty = edge.getBendpoints().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<_Point, CharSequence> _function = new Functions.Function1<_Point, CharSequence>(){

                public CharSequence apply(_Point it) {
                    return Serializer.this.toGratext(it);
                }
            };
            _xifexpression = IterableExtensions.join((Iterable)ListExtensions.map((List)edge.getBendpoints(), (Functions.Function1)_function), (CharSequence)" ");
        }
        String points = _xifexpression;
        StringConcatenation _xifexpression_1 = null;
        if (points != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("via ");
            _builder.append(points);
            _xifexpression_1 = _builder;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public String decorations(InternalEdge edge) {
        EList _decorators = edge.getDecorators();
        List _map = null;
        if (_decorators != null) {
            Functions.Function1<_Decoration, CharSequence> _function = new Functions.Function1<_Decoration, CharSequence>(){

                public CharSequence apply(_Decoration it) {
                    return Serializer.this.toGratext(it);
                }
            };
            _map = ListExtensions.map((List)_decorators, (Functions.Function1)_function);
        }
        return IterableExtensions.join(_map, (CharSequence)" ");
    }

    public CharSequence toGratext(_Point p) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        int _x = p.getX();
        _builder.append((Object)_x);
        _builder.append(",");
        int _y = p.getY();
        _builder.append((Object)_y);
        _builder.append(")");
        return _builder;
    }

    public CharSequence toGratext(_Decoration dec) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("decorate \"");
        String _nameHint = dec.getNameHint();
        _builder.append(_nameHint);
        _builder.append("\" at (");
        int _x = dec.getLocationShift().getX();
        _builder.append((Object)_x);
        _builder.append(",");
        int _y = dec.getLocationShift().getY();
        _builder.append((Object)_y);
        _builder.append(")");
        return _builder;
    }

    public String edges(InternalNode node) {
        Functions.Function1<InternalEdge, String> _function = new Functions.Function1<InternalEdge, String>(){

            public String apply(InternalEdge it) {
                return Serializer.this.toGratext(it);
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)node.getOutgoing(InternalEdge.class), (Functions.Function1)_function), (CharSequence)"\n");
    }

    public String toGratext(Iterable<EStructuralFeature> ftrs, final EObject obj) {
        Object _function;
        Iterable _switchResult = null;
        boolean _matched = false;
        if (obj instanceof InternalModelElement) {
            _matched = true;
            _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    int _featureID = it.getFeatureID();
                    return _featureID != 0;
                }
            };
            _switchResult = IterableExtensions.filter(ftrs, (Functions.Function1)_function);
        }
        if (!_matched) {
            _switchResult = ftrs;
        }
        _function = new Functions.Function1<EStructuralFeature, String>(){

            public String apply(EStructuralFeature it) {
                return Serializer.this.toGratext(it, obj);
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)_switchResult, (Functions.Function1)_function)), (CharSequence)"\n");
    }

    public String toGratext(EStructuralFeature ftr, EObject obj) {
        String _xblockexpression = null;
        Object v = obj.eGet(ftr);
        String _xifexpression = null;
        if (v != null) {
            String _xblockexpression_1 = null;
            Object _switchResult = null;
            boolean _matched = false;
            if (v instanceof List) {
                _matched = true;
                Functions.Function1<Object, Object> _function = new Functions.Function1<Object, Object>(){

                    public Object apply(Object it) {
                        return Serializer.this.toGratextValue(it);
                    }
                };
                String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)v), (Functions.Function1)_function), (CharSequence)", ");
                String _plus = "[ " + _join;
                _switchResult = String.valueOf(_plus) + " ]";
            }
            if (!_matched) {
                _switchResult = this.toGratextValue(v);
            }
            Object value = _switchResult;
            String _xifexpression_1 = null;
            if (value != null) {
                String _name = ftr.getName();
                String _plus = String.valueOf(_name) + " ";
                _xifexpression_1 = String.valueOf(_plus) + value;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Object toGratextValue(Object it) {
        Object _switchResult = null;
        boolean _matched = false;
        if (it instanceof ModelElement) {
            _matched = true;
            InternalModelElement _internalElement_ = ((ModelElement)it).getInternalElement_();
            String _nonInternalID = null;
            if (_internalElement_ != null) {
                _nonInternalID = this.getNonInternalID((EObject)_internalElement_);
            }
            _switchResult = _nonInternalID;
        }
        if (!_matched && it instanceof InternalModelElement) {
            _matched = true;
            _switchResult = this.getNonInternalID((EObject)it);
        }
        if (!_matched && it instanceof Type) {
            _matched = true;
            _switchResult = this.toGratextValue(((Type)it).getInternalElement_());
        }
        if (!_matched && it instanceof String) {
            _matched = true;
            _switchResult = this.escapeString((String)it);
        }
        if (!_matched && it instanceof Date) {
            _matched = true;
            String _format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format((Date)it);
            String _plus = "\"" + _format;
            _switchResult = String.valueOf(_plus) + "\"";
        }
        if (!_matched && it instanceof EObject) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            String _name = this.name((EObject)it);
            _builder.append(_name);
            _builder.append(" ");
            String _nonInternalID = this.getNonInternalID((EObject)it);
            _builder.append(_nonInternalID);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _attributes = this.attributes((EObject)it);
            _builder.append(_attributes, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = it;
        }
        return _switchResult;
    }

    public String escapeString(String it) {
        String _xifexpression = null;
        boolean _isWindows = CincoProperties.isWindows();
        if (_isWindows) {
            String _replace = it.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r\n", "\n").replace("\n", "\\n");
            String _plus = "\"" + _replace;
            _xifexpression = String.valueOf(_plus) + "\"";
        } else {
            String _replace_1 = it.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
            String _plus_1 = "\"" + _replace_1;
            _xifexpression = String.valueOf(_plus_1) + "\"";
        }
        return _xifexpression;
    }

    public String getNonInternalID(EObject it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof IdentifiableElement) {
            _matched = true;
            _switchResult = ((IdentifiableElement)it).getId();
        }
        if (!_matched && it instanceof InternalIdentifiableElement) {
            boolean _isNullOrEmpty;
            boolean _not;
            _matched = true;
            String _xblockexpression = null;
            IdentifiableElement nonInternal = ((InternalIdentifiableElement)it).getElement();
            String _id = null;
            if (nonInternal != null) {
                _id = nonInternal.getId();
            }
            boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_id));
            if (_not) {
                return nonInternal.getId();
            }
            String _id_1 = ((InternalIdentifiableElement)it).getId();
            int _lastIndexOf = 0;
            if (_id_1 != null) {
                _lastIndexOf = _id_1.lastIndexOf("_INTERNAL");
            }
            int index = _lastIndexOf;
            String _xifexpression = null;
            _xifexpression = index > 0 ? ((InternalIdentifiableElement)it).getId().substring(0, index) : ((InternalIdentifiableElement)it).getId();
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched) {
            _switchResult = EcoreUtil.getID((EObject)it);
        }
        return _switchResult;
    }

    public Iterable<InternalNode> getAllNodes(InternalModelElementContainer c) {
        return Iterables.filter((Iterable)c.getModelElements(), InternalNode.class);
    }
}

