/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.runtime.resource;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ui.editor.ResourceContributor;
import de.jabc.cinco.meta.core.ui.editor.ResourceContributorRegistry;
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.Serializer;
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.Transformer;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import graphmodel.GraphModel;
import graphmodel.internal.InternalGraphModel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class GratextResource
extends LazyLinkingResource {
    @Extension
    private final ResourceExtension _resourceExtension = new ResourceExtension();
    private GraphModel model;
    private final HashMap<EObject, ResourceContributor> contributions = CollectionLiterals.newHashMap();
    private Runnable internalStateChangedHandler;
    private Runnable newParseResultHandler;
    private boolean skipInternalStateUpdate;

    public abstract Transformer getTransformer(InternalGraphModel var1);

    public abstract Transformer getLastTransformer(InternalGraphModel var1);

    public abstract void removeTransformer(InternalGraphModel var1);

    public abstract boolean isSortGratext();

    public String serialize() {
        InternalGraphModel _content;
        String _xblockexpression = null;
        InternalGraphModel _elvis = null;
        InternalGraphModel _internalElement_ = null;
        if (this.model != null) {
            _internalElement_ = this.model.getInternalElement_();
        }
        _elvis = _internalElement_ != null ? _internalElement_ : (_content = (InternalGraphModel)this._resourceExtension.getContent((Resource)this, InternalGraphModel.class));
        InternalGraphModel internalModel = _elvis;
        Transformer _lastTransformer = this.getLastTransformer(internalModel);
        Serializer _serializer = new Serializer(internalModel, _lastTransformer);
        Procedures.Procedure1<Serializer> _function = new Procedures.Procedure1<Serializer>(){

            public void apply(Serializer it) {
                it.sorted = GratextResource.this.isSortGratext();
            }
        };
        _xblockexpression = ((Serializer)ObjectExtensions.operator_doubleArrow((Object)_serializer, (Procedures.Procedure1)_function)).run();
        return _xblockexpression;
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) {
        try {
            String _encoding = this.getEncoding();
            OutputStreamWriter _outputStreamWriter = new OutputStreamWriter(outputStream, _encoding);
            Procedures.Procedure1<OutputStreamWriter> _function = new Procedures.Procedure1<OutputStreamWriter>(){

                public void apply(OutputStreamWriter it) {
                    try {
                        it.write(GratextResource.this.serialize());
                        it.flush();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_outputStreamWriter, (Procedures.Procedure1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void clearInternalState() {
        this.unload((EObject[])Conversions.unwrapArray((Object)this.getContents(), EObject.class));
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                GratextResource.this.getContents().clear();
            }
        };
        this._resourceExtension.transact((Resource)this, _function);
        this.clearErrorsAndWarnings();
        this.setParseResult(null);
    }

    public Runnable onInternalStateChanged(Runnable runnable) {
        this.internalStateChangedHandler = runnable;
        return this.internalStateChangedHandler;
    }

    public Runnable onNewParseResult(Runnable runnable) {
        this.newParseResultHandler = runnable;
        return this.newParseResultHandler;
    }

    public EObject getContent(int index) {
        return (EObject)this.getContents().get(index);
    }

    public EObject getEObjectByID(String id) {
        EObject eObject;
        EObject _xblockexpression = null;
        EObject _get = null;
        if (this.intrinsicIDToEObjectMap != null) {
            _get = (EObject)this.intrinsicIDToEObjectMap.get(id);
        }
        if ((eObject = _get) != null) {
            return eObject;
        }
        EObject _elvis = null;
        EObject _eObjectById = this.getEObjectById((TreeIterator<EObject>)this.getAllProperContents(IterableExtensions.toList((Iterable)IterableExtensions.tail((Iterable)this.getContents()))), id);
        if (_eObjectById != null) {
            _elvis = _eObjectById;
        } else {
            boolean _greaterThan;
            EObject _xifexpression = null;
            int _size = this.getContents().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _xifexpression = this.getEObjectById((TreeIterator<EObject>)this.getAllProperContents((EObject)IterableExtensions.head((Iterable)this.getContents())), id);
            }
            _elvis = _xifexpression;
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    private EObject getEObjectById(TreeIterator<EObject> iterator, String id) {
        while (iterator.hasNext()) {
            boolean _equals;
            EObject eObject = (EObject)iterator.next();
            String eObjectId = EcoreUtil.getID((EObject)eObject);
            if (this.intrinsicIDToEObjectMap != null) {
                this.intrinsicIDToEObjectMap.put(eObjectId, eObject);
            }
            if (!(_equals = Objects.equal((Object)eObjectId, (Object)id))) continue;
            return eObject;
        }
        return null;
    }

    public void add(final EObject object) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                GratextResource.this.getContents().add((Object)object);
            }
        };
        this._resourceExtension.transact((Resource)this, _function);
    }

    public void insert(final int index, final EObject object) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                GratextResource.this.getContents().add(index, (Object)object);
            }
        };
        this._resourceExtension.transact((Resource)this, _function);
    }

    public void remove(final EObject ... objects) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                CollectionExtensions.removeAll((Collection)GratextResource.this.getContents(), (Object[])objects);
            }
        };
        this._resourceExtension.transact((Resource)this, _function);
    }

    public void clear() {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new EList[]{GratextResource.this.getContents()});
                Iterator iterator = _newArrayList.iterator();
                while (iterator.hasNext()) {
                    EList cfr_ignored_0 = (EList)iterator.next();
                    GratextResource.this.unload();
                }
                GratextResource.this.getContents().clear();
            }
        };
        this._resourceExtension.transact((Resource)this, _function);
    }

    public void unload(EObject ... objects) {
        Iterable _filterNull = null;
        if ((Iterable)Conversions.doWrapArray((Object)objects) != null) {
            _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)objects)));
        }
        Consumer<EObject> _function = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                GratextResource.this.unload();
            }
        };
        _filterNull.forEach(_function);
    }

    public void update(String newText) {
        this.update(0, this.getParseResult().getRootNode().getText().length(), newText);
    }

    public boolean skipInternalStateUpdate() {
        this.skipInternalStateUpdate = true;
        return true;
    }

    public void updateInternalState(IParseResult oldParseResult, IParseResult newParseResult) {
        EObject oldRoot;
        EObject _rootASTElement = null;
        if (oldParseResult != null) {
            _rootASTElement = oldParseResult.getRootASTElement();
        }
        if ((oldRoot = _rootASTElement) != null && !Objects.equal((Object)oldRoot, (Object)newParseResult.getRootASTElement()) && !this.skipInternalStateUpdate) {
            this.clear();
            this.model = null;
        }
        this.updateInternalState(newParseResult);
    }

    public void updateInternalState(IParseResult newParseResult) {
        this.setParseResult(newParseResult);
        EObject newRoot = newParseResult.getRootASTElement();
        if (newRoot != null) {
            if (!this.skipInternalStateUpdate) {
                if (this.model == null) {
                    this.insert(0, newRoot);
                    this.reattachModificationTracker(newRoot);
                    this.clearErrorsAndWarnings();
                    this.addSyntaxErrors();
                    Runnable _function = new Runnable(){

                        @Override
                        public void run() {
                            GratextResource.this.doLinking();
                            GratextResource.this.transformModel();
                            GratextResource.this.addContributions();
                        }
                    };
                    this._resourceExtension.transact((Resource)this, _function);
                    if (this.internalStateChangedHandler != null) {
                        this.internalStateChangedHandler.run();
                    }
                }
            } else {
                this.skipInternalStateUpdate = false;
            }
        }
        if (this.newParseResultHandler != null) {
            this.newParseResultHandler.run();
        }
    }

    public void transformModel() {
        InternalGraphModel gratextModel = (InternalGraphModel)this._resourceExtension.getContent((Resource)this, InternalGraphModel.class);
        Transformer transformer = this.getTransformer(gratextModel);
        this.model = transformer.transform(gratextModel).getElement();
        InternalEObject internal = ((EObjectImpl)this.model).eInternalContainer();
        this.remove(new EObject[]{gratextModel});
        this.add((EObject)this.model.getInternalElement_());
        this.model.setInternalElement_((InternalGraphModel)internal);
        this.removeTransformer(gratextModel);
    }

    public void addContributions() {
        Set _contributors = ResourceContributorRegistry.getContributors();
        if (_contributors != null) {
            Consumer<ResourceContributor> _function = new Consumer<ResourceContributor>(){

                @Override
                public void accept(final ResourceContributor contributor) {
                    Iterable _contributeToResource = contributor.contributeToResource((Resource)GratextResource.this);
                    if (_contributeToResource != null) {
                        Consumer<EObject> _function = new Consumer<EObject>(){

                            @Override
                            public void accept(EObject contribution) {
                                (this).GratextResource.this.contributions.put(contribution, contributor);
                            }
                        };
                        _contributeToResource.forEach(_function);
                    }
                }
            };
            _contributors.forEach(_function);
        }
    }

    public void resolveLazyCrossReferences(final CancelIndicator mon) {
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                return GratextResource.this.isResolveCrossReferencesRequired(it);
            }
        };
        Consumer<EObject> _function_1 = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                CancelIndicator _elvis = null;
                _elvis = mon != null ? mon : CancelIndicator.NullImpl;
                GratextResource.this.resolveCrossReferences(it, _elvis);
            }
        };
        IterableExtensions.filter((Iterable)this.getContents(), (Functions.Function1)_function).forEach(_function_1);
    }

    public boolean isResolveCrossReferencesRequired(EObject obj) {
        boolean _xblockexpression = false;
        ResourceContributor contributor = this.contributions.get(obj);
        _xblockexpression = contributor == null || contributor.isResolveCrossReferencesRequired(obj);
        return _xblockexpression;
    }

    public void resolveCrossReferences(EObject obj, final CancelIndicator monitor) {
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
            return;
        }
        final InternalEObject iEobj = (InternalEObject)obj;
        EClass cls = iEobj.eClass();
        EList _eAllStructuralFeatures = cls.getEAllStructuralFeatures();
        EClassImpl.FeatureSubsetSupplier sup = (EClassImpl.FeatureSubsetSupplier)_eAllStructuralFeatures;
        EStructuralFeature[] _crossReferences = sup.crossReferences();
        if ((List)Conversions.doWrapArray((Object)_crossReferences) != null) {
            Consumer<EStructuralFeature> _function = new Consumer<EStructuralFeature>(){

                @Override
                public void accept(EStructuralFeature it) {
                    boolean _isCanceled = monitor.isCanceled();
                    if (_isCanceled) {
                        return;
                    }
                    boolean _isPotentialLazyCrossReference = GratextResource.this.isPotentialLazyCrossReference(it);
                    if (_isPotentialLazyCrossReference) {
                        GratextResource.this.doResolveLazyCrossReference(iEobj, it);
                    }
                }
            };
            ((List)Conversions.doWrapArray((Object)_crossReferences)).forEach(_function);
        }
        Consumer<EObject> _function_1 = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                GratextResource.this.resolveCrossReferences(it, monitor);
            }
        };
        EcoreUtil.getAllContents((EObject)iEobj, (boolean)true).forEachRemaining((Consumer)_function_1);
    }
}

