/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.plugin.gratext.runtime.editor;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoDiagramEditor;
import de.jabc.cinco.meta.core.ui.editor.InnerStateAwareness;
import de.jabc.cinco.meta.core.ui.editor.PageAwareEditor;
import de.jabc.cinco.meta.core.ui.editor.PageAwareEditorDescriptor;
import de.jabc.cinco.meta.core.ui.editor.PageAwareEditorInput;
import de.jabc.cinco.meta.plugin.gratext.runtime.editor.PageAwareEditorRegistry;
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.GratextResource;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.LinkedTransferQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class MultiPageGratextEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
IGotoMarker {
    private static WorkbenchExtension workbench = new WorkbenchExtension();
    private XtextEditor sourceEditor;
    private ArrayList<PageAwareEditor> pawEditors = new ArrayList();
    private HashMap<PageAwareEditor, PageAwareEditorDescriptor> pawEditorDescriptors = new HashMap();
    private GratextResource innerState;
    private int currentPage = -1;
    private boolean awaitingResourceUpdate;

    protected Iterable<PageAwareEditorDescriptor> getEditorDescriptors() {
        IFile file = workbench.getFile((IEditorPart)this);
        if (file != null) {
            return (Iterable)PageAwareEditorRegistry.INSTANCE.get((Object)file.getName());
        }
        return new ArrayList<PageAwareEditorDescriptor>();
    }

    protected abstract XtextEditor getSourceEditor();

    protected void createPages() {
        this.createSourceEditorPage();
        this.unregisterEditingDomain();
        this.getEditorDescriptors().forEach(editor -> this.createEditorPage((PageAwareEditorDescriptor)editor));
        this.setTitle();
    }

    private void unregisterEditingDomain() {
        TransactionChangeRecorder recorder;
        EditingDomain domain = this.getEditingDomain();
        if (domain == null) {
            return;
        }
        if (domain instanceof TransactionalEditingDomain) {
            WorkspaceEditingDomainFactory.INSTANCE.unmapResourceSet((TransactionalEditingDomain)domain);
        }
        if (domain instanceof InternalTransactionalEditingDomain && (recorder = ((InternalTransactionalEditingDomain)domain).getChangeRecorder()) != null) {
            domain.getResourceSet().getResources().forEach(res -> EcoreUtil.getAllProperContents(Collections.singleton(res), (boolean)false).forEachRemaining(it -> {
                boolean bl = ((Notifier)it).eAdapters().remove((Object)recorder);
            }));
        }
    }

    protected void createSourceEditorPage() {
        this.sourceEditor = this.getSourceEditor();
        IEditorInput input = this.getEditorInput();
        workbench.sync(() -> {
            try {
                int index = this.addPage((IEditorPart)this.sourceEditor, input);
                this.setPageText(index, "Source");
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested editor", null, (IStatus)e.getStatus());
            }
        });
    }

    protected void createEditorPage(PageAwareEditorDescriptor desc) {
        PageAwareEditor editor = desc.newEditor();
        this.pawEditors.add(editor);
        this.pawEditorDescriptors.put(editor, desc);
        PageAwareEditorInput input = (PageAwareEditorInput)desc.getInputMapper().apply(this.getEditorInput());
        input.setInnerStateSupplier(() -> this.getInnerState());
        int index = Math.max(0, this.getPageCount() - 1);
        String name = desc.getPageName() != null ? desc.getPageName() : editor.getClass().getSimpleName();
        workbench.sync(() -> {
            try {
                this.addPage(index, (IEditorPart)editor, (IEditorInput)input);
                this.setPageText(index, name);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested editor", null, (IStatus)e.getStatus());
            }
        });
    }

    protected void setTitle() {
        try {
            this.setPartName(((IFileEditorInput)this.getEditorInput()).getFile().getProjectRelativePath().removeFileExtension().lastSegment());
        }
        catch (Exception exception) {
            try {
                this.setPartName(this.getEditorInput().getName());
            }
            catch (Exception exception2) {}
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.awaitingResourceUpdate || !UpdatingEditorsRegistry.INSTANCE.isEmpty()) {
            this.showSaveInProgress();
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        if (this.isDirty()) {
            try {
                if (editor != this.sourceEditor && this.innerState != null && this.innerState instanceof GratextResource) {
                    this.innerState.onNewParseResult(() -> {
                        this.awaitingResourceUpdate = false;
                    });
                    this.awaitingResourceUpdate = true;
                }
                if (editor == this.sourceEditor) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (PageAwareEditor pae : this.pawEditors) {
                    if (!(pae instanceof CincoDiagramEditor)) continue;
                    CincoDiagramEditor cde = (CincoDiagramEditor)pae;
                    cde.preSave();
                }
                this.updateInnerState(editor);
                this.sourceEditor.doSave(monitor);
                this.pawEditors.forEach(pawEditor -> pawEditor.handleSaved());
            }
            catch (Exception e) {
                this.handleSaveError(editor, e);
            }
        }
    }

    protected void handleSaveError(IEditorPart editor, Exception e) {
        e.printStackTrace();
        if (this.sourceEditor == this.getActiveEditor() && this.showSourceEditorOnSaveError()) {
            this.setActiveEditor((IEditorPart)this.sourceEditor);
        }
    }

    protected boolean activatePage(IEditorPart editor, IEditorPart prevEditor) {
        if (editor instanceof PageAwareEditor) {
            try {
                ((PageAwareEditor)editor).handlePageActivated(prevEditor);
            }
            catch (Exception e) {
                this.handlePageActivationError(editor, e);
                return false;
            }
        }
        return true;
    }

    protected void handlePageActivationError(IEditorPart pageEditor, Exception e) {
        e.printStackTrace();
        if (this.getActiveEditor() == this.sourceEditor && this.showSourceEditorOnActivationError()) {
            this.switchToEditor((EditorPart)this.sourceEditor);
        }
    }

    protected boolean deactivatePage(IEditorPart editor, IEditorPart nextEditor) {
        if (editor instanceof PageAwareEditor) {
            try {
                ((PageAwareEditor)editor).handlePageDeactivated(nextEditor);
            }
            catch (Exception e) {
                this.handlePageDeactivationError(editor, e);
                return false;
            }
        }
        return true;
    }

    protected void handlePageDeactivationError(IEditorPart pageEditor, Exception e) {
        e.printStackTrace();
        if (this.leavePageOnDeactivationError()) {
            this.switchToEditor((EditorPart)this.sourceEditor);
        }
    }

    protected void updateInnerState(IEditorPart triggerEditor) {
        if (triggerEditor != null && triggerEditor != this.sourceEditor && triggerEditor.isDirty()) {
            XtextDocument doc = (XtextDocument)this.sourceEditor.getDocument();
            String text = this.getInnerState().serialize();
            if (text != null) {
                doc.stopListenerNotification();
                doc.set(text);
                doc.resumeListenerNotification();
            } else {
                System.err.println("[GratextEditor] WARN: Failed to reconcile inner state. Generated source code is null for " + triggerEditor);
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        IEditorPart newEditor = this.getActiveEditor();
        if (this.currentPage != newPageIndex) {
            IEditorPart prevEditor;
            if (newPageIndex != this.getSourceEditorIndex() && this.getInnerState().getParseResult().hasSyntaxErrors()) {
                this.setActiveEditor((IEditorPart)this.sourceEditor);
                this.showEditorContainsSyntaxErrors();
                return;
            }
            IEditorPart iEditorPart = prevEditor = this.currentPage > -1 ? this.getEditor(this.currentPage) : null;
            if (prevEditor != null && prevEditor != this.sourceEditor && prevEditor.isDirty() && !this.proceedAndLooseUndoHistory()) {
                this.setActiveEditor(prevEditor);
                return;
            }
            if (prevEditor != null) {
                this.deactivatePage(prevEditor, newEditor);
                this.updateInnerState(prevEditor);
            }
            this.activatePage(newEditor, prevEditor);
            IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
            if (partService != null) {
                super.pageChange(newPageIndex);
            }
            this.currentPage = newPageIndex;
        }
    }

    protected boolean showSourceEditorOnSaveError() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Saving failed", (String)"Failed to save editor page.\nWould you like to open the source page to fix errors?");
    }

    protected boolean showSourceEditorOnActivationError() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Switching editor page failed", (String)"Failed to activate editor page.\nWould you like to open the source page to fix errors?");
    }

    protected boolean leavePageOnDeactivationError() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Switching editor page failed", (String)"Failed to deactivate editor page.\nLeaving the current page might result in the loss of changes.\nWould you still like to leave this page?");
    }

    protected boolean proceedAndLooseUndoHistory() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Pending model changes", (String)"There are unsaved changes.\nIf you switch editor pages you wont be able to come back and undo any of these changes.\n\nDo you want to proceed?");
    }

    protected void showEditorContainsSyntaxErrors() {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Switching editor page failed", (String)"The source code contains errors.\nPlease resolve them before switching to another editor page.");
    }

    protected void showSaveInProgress() {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Saving editor state canceled", (String)"The preceding saving process has not finished, yet.\nPlease try again later.");
    }

    protected void switchToEditor(EditorPart editor) {
        this.setActiveEditor((IEditorPart)editor);
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.getSourceEditorIndex());
        IDE.gotoMarker((IEditorPart)this.sourceEditor, (IMarker)marker);
    }

    public EditingDomain getEditingDomain() {
        GratextResource state = this.getInnerState();
        if (state != null) {
            return TransactionUtil.getEditingDomain((Resource)state);
        }
        return null;
    }

    protected GratextResource getInnerState() {
        XtextDocument doc;
        int hash;
        int n = hash = this.innerState != null ? ((Object)((Object)this.innerState)).hashCode() : 0;
        if (this.sourceEditor != null && (doc = (XtextDocument)this.sourceEditor.getDocument()) != null) {
            doc.internalModify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    MultiPageGratextEditor.this.innerState = (GratextResource)state;
                }
            });
        }
        if (this.innerState != null) {
            if (hash != 0 && ((Object)((Object)this.innerState)).hashCode() != hash) {
                System.err.println("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] " + "WARN: inner state changed: hash " + hash + " => " + ((Object)((Object)this.innerState)).hashCode());
                this.pawEditors.forEach(InnerStateAwareness::handleNewInnerState);
            }
            if (this.innerState instanceof GratextResource) {
                this.innerState.onInternalStateChanged(() -> this.pawEditors.forEach(editor -> workbench.async(() -> {
                    UpdatingEditorsRegistry.INSTANCE.put((IEditorPart)editor);
                    editor.handleInnerStateChanged();
                    UpdatingEditorsRegistry.INSTANCE.poll();
                })));
            } else {
                System.err.println("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] " + "WARN: inner state should be GratextResource: " + ((Object)((Object)this.innerState)).getClass());
            }
        }
        return this.innerState;
    }

    protected int getSourceEditorIndex() {
        return this.getPageCount() - 1;
    }

    private static class UpdatingEditorsRegistry {
        public static LinkedTransferQueue<IEditorPart> INSTANCE = new LinkedTransferQueue();

        private UpdatingEditorsRegistry() {
        }
    }
}

