/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.validator;

import de.jabc.cinco.meta.core.ui.converter.StringToLongConverter;
import de.jabc.cinco.meta.core.ui.validator.ControlValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class LongValidator
extends ControlValidator<Text, Long> {
    public LongValidator(EObject bo, EStructuralFeature attribute, Text control) {
        super(bo, attribute, control);
    }

    @Override
    public boolean hasValidInput(Text control) {
        try {
            Long.parseLong(control.getText());
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Input must must be an integer between ");
                _builder.append((Object)Long.MIN_VALUE);
                _builder.append(" and ");
                _builder.append((Object)Long.MAX_VALUE);
                _builder.append(".");
                this.validationErrorMessage = _builder.toString();
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    @Override
    public Long getValue(Text control) {
        return new StringToLongConverter().convert(control.getText());
    }
}

