/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.validator;

import de.jabc.cinco.meta.core.ui.converter.StringToDoubleConverter;
import de.jabc.cinco.meta.core.ui.validator.ControlValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DoubleValidator
extends ControlValidator<Text, Double> {
    public DoubleValidator(EObject bo, EStructuralFeature attribute, Text control) {
        super(bo, attribute, control);
    }

    @Override
    public boolean hasValidInput(Text control) {
        try {
            Double.parseDouble(control.getText());
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                this.validationErrorMessage = "Input must must be a decimal.";
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    @Override
    public Double getValue(Text control) {
        return new StringToDoubleConverter().convert(control.getText());
    }
}

