/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.validator;

import de.jabc.cinco.meta.core.ui.properties.CincoPropertyView;
import graphmodel.IdentifiableElement;
import graphmodel.internal.InternalIdentifiableElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class ControlValidator<C extends Control, V>
implements SelectionListener,
ModifyListener {
    protected static final String DEFAULT_VALIDATION_ERROR_MESSAGE = "This input is invalid.";
    protected final IdentifiableElement element;
    protected final String attribute;
    protected final C control;
    protected ControlDecoration decoration;
    protected String validationErrorMessage;

    public ControlValidator(EObject bo, EStructuralFeature attribute, C control) {
        IdentifiableElement _switchResult = null;
        boolean _matched = false;
        if (bo instanceof InternalIdentifiableElement) {
            _matched = true;
            _switchResult = ((InternalIdentifiableElement)bo).getElement();
        }
        if (!_matched && bo instanceof IdentifiableElement) {
            _matched = true;
            _switchResult = (IdentifiableElement)bo;
        }
        this.element = _switchResult;
        this.attribute = attribute.getName();
        this.control = control;
    }

    public void widgetSelected(SelectionEvent event) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent event) {
        this.validate();
    }

    protected void validate() {
        boolean _hasValidInput = this.hasValidInput(this.control);
        if (_hasValidInput) {
            this.validationErrorMessage = (String)CincoPropertyView.canAttributeChange.apply((Object)this.element, (Object)this.attribute, this.getValue(this.control));
            if (this.validationErrorMessage == null) {
                this.hideDecoration();
                return;
            }
        }
        this.showDecoration();
    }

    protected abstract boolean hasValidInput(C var1);

    protected abstract V getValue(C var1);

    protected void setValidationErrorMessage(String message) {
        this.validationErrorMessage = message;
    }

    protected String getValidationErrorMessage() {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.validationErrorMessage);
        _xifexpression = _isNullOrEmpty ? DEFAULT_VALIDATION_ERROR_MESSAGE : this.validationErrorMessage;
        return _xifexpression;
    }

    protected void showDecoration() {
        if (this.decoration == null) {
            ControlDecoration _controlDecoration;
            this.decoration = _controlDecoration = new ControlDecoration(this.control, 16512);
            this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        }
        this.decoration.setDescriptionText(this.getValidationErrorMessage());
        this.decoration.show();
        this.control.redraw();
    }

    protected void hideDecoration() {
        if (this.decoration != null) {
            this.decoration.hide();
        }
        this.control.redraw();
    }
}

