/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.validator;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ui.validator.ControlValidator;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ColorValidator
extends ControlValidator<Text, String> {
    public static final String HEX_PATTERN = "^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$";
    public static final String RGB_PATTERN = "^([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})$";
    public static final String RGBA_PATTERN = "^([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})$";
    public static final String HEX = "hex";
    public static final String RGB = "rgb";
    public static final String RGBA = "rgba";
    private final String colorFormat;

    public ColorValidator(EObject bo, EStructuralFeature attribute, Text control, String colorFormat) {
        super(bo, attribute, control);
        boolean _not;
        boolean _isColorFormat = ColorValidator.isColorFormat(colorFormat);
        boolean bl = _not = !_isColorFormat;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unknown color format \"");
            _builder.append(colorFormat);
            _builder.append("\". Must be \"");
            _builder.append(HEX);
            _builder.append("\", \"");
            _builder.append(RGB);
            _builder.append("\", or \"");
            _builder.append(RGBA);
            _builder.append("\".\"");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.colorFormat = colorFormat;
    }

    @Override
    public boolean hasValidInput(Text control) {
        boolean isValid;
        String colorString = this.getValue(control);
        boolean _switchResult = false;
        String colorFormat = this.colorFormat;
        boolean _matched = false;
        if (Objects.equal((Object)colorFormat, (Object)HEX)) {
            _matched = true;
            _switchResult = ColorValidator.isHex(colorString);
        }
        if (!_matched && Objects.equal((Object)colorFormat, (Object)RGB)) {
            _matched = true;
            _switchResult = ColorValidator.isRGB(colorString);
        }
        if (!_matched && Objects.equal((Object)colorFormat, (Object)RGBA)) {
            _matched = true;
            _switchResult = ColorValidator.isRGBA(colorString);
        }
        if (!_matched) {
            _switchResult = false;
        }
        if (!(isValid = _switchResult)) {
            this.validationErrorMessage = "Color String is malformed.";
        }
        return isValid;
    }

    @Override
    public String getValue(Text control) {
        return control.getText();
    }

    public static boolean isColorFormat(String colorFormat) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{HEX, RGB, RGBA})).contains(colorFormat);
    }

    public static boolean isHex(String colorString) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Pattern p = Pattern.compile(HEX_PATTERN);
        Matcher m = p.matcher(colorString);
        return m.matches();
    }

    public static boolean isRGB(String colorString) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Pattern p = Pattern.compile(RGB_PATTERN);
        Matcher m = p.matcher(colorString);
        boolean _matches = m.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            return false;
        }
        try {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

                public Boolean apply(Integer v) {
                    return new IntegerRange(0, 255).contains(v.intValue());
                }
            };
            return IterableExtensions.forall(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{r, g, b})), (Functions.Function1)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isRGBA(String colorString) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)colorString);
        if (_isNullOrEmpty) {
            return false;
        }
        Pattern p = Pattern.compile(RGBA_PATTERN);
        Matcher m = p.matcher(colorString);
        boolean _matches = m.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            return false;
        }
        try {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            int a = Integer.parseInt(m.group(4));
            Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

                public Boolean apply(Integer v) {
                    return new IntegerRange(0, 255).contains(v.intValue());
                }
            };
            return IterableExtensions.forall(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{r, g, b, a})), (Functions.Function1)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

