/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.templates;

import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.CincoProduct;

public class NewProjectWizardGenerator {
    public static CharSequence generateWizardJavaCode(CincoProduct cp, String pName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(pName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.Collections;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.core.resources.IProject;");
        _builder.newLine();
        _builder.append("import org.eclipse.core.resources.ResourcesPlugin;");
        _builder.newLine();
        _builder.append("import org.eclipse.core.runtime.NullProgressMonitor;");
        _builder.newLine();
        _builder.append("import org.eclipse.jface.viewers.IStructuredSelection;");
        _builder.newLine();
        _builder.append("import org.eclipse.jface.wizard.Wizard;");
        _builder.newLine();
        _builder.append("import org.eclipse.jface.wizard.WizardPage;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.SWT;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.events.KeyEvent;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.events.KeyListener;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.layout.GridData;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.layout.GridLayout;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.widgets.Composite;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.widgets.Label;");
        _builder.newLine();
        _builder.append("import org.eclipse.swt.widgets.Text;");
        _builder.newLine();
        _builder.append("import org.eclipse.ui.IWorkbench;");
        _builder.newLine();
        _builder.append("import org.eclipse.ui.IWorkbenchWizard;");
        _builder.newLine();
        _builder.append("import org.eclipse.ui.PlatformUI;");
        _builder.newLine();
        _builder.append("import org.eclipse.ui.WorkbenchException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        String _name = cp.getName();
        _builder.append(_name);
        _builder.append("ProjectWizard extends Wizard implements IWorkbenchWizard {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CreateNewProjectPage newProjectPage = new CreateNewProjectPage(\"newProjectPage\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void addPages() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addPage(newProjectPage);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.addPages();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean canFinish() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return newProjectPage.isPageComplete();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean performFinish() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String projectName = newProjectPage.getProjectName();");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ProjectCreator.createPlainProject(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("projectName,");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("getNatures(),");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("new NullProgressMonitor(),");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Collections.emptyList(),");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("true");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("IWorkbench workbench = PlatformUI.getWorkbench();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)cp.getDefaultPerspective());
        if (_isNullOrEmpty) {
            _builder.append("\t\t\t");
            _builder.append("workbench.showPerspective(\"");
            _builder.append(pName, "\t\t\t");
            _builder.append(".");
            String _lowerCase = cp.getName().toLowerCase();
            _builder.append(_lowerCase, "\t\t\t");
            _builder.append("perspective\", workbench.getActiveWorkbenchWindow());");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t\t");
            _builder.append("workbench.showPerspective(\"");
            String _defaultPerspective = cp.getDefaultPerspective();
            _builder.append(_defaultPerspective, "\t\t\t");
            _builder.append("\", workbench.getActiveWorkbenchWindow());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("} catch (WorkbenchException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<String> getNatures() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("List<String> natures = new ArrayList<String>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("natures.add(\"org.eclipse.xtext.ui.shared.xtextNature\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return natures;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void init(IWorkbench workbench, IStructuredSelection selection) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("setWindowTitle(\"New ");
        String _name_1 = cp.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(" Project\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private class CreateNewProjectPage extends WizardPage {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private Text txtProjectName;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("protected CreateNewProjectPage(String pageName) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("super(pageName);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setTitle(\"New ");
        String _name_2 = cp.getName();
        _builder.append(_name_2, "\t\t\t");
        _builder.append(" Project\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setDescription(\"Initialize an empty ");
        String _name_3 = cp.getName();
        _builder.append(_name_3, "\t\t\t");
        _builder.append(" project and switch to correct perspective\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("setPageComplete(false);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void createControl(Composite parent) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Composite comp = new Composite(parent, SWT.NONE); ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("comp.setLayout(new GridLayout(2, false));");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Label lblProjectName = new Label(comp, SWT.NONE);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lblProjectName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lblProjectName.setText(\"&Project Name\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("txtProjectName = new Text(comp, SWT.BORDER);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("txtProjectName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("addListeners();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("initContents();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setControl(comp);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private void initContents() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("txtProjectName.setText(\"myProject\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("dialogChanged();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private void addListeners() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("KeyListener pageCompleteValidationListener = new KeyListener() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("public void keyReleased(KeyEvent e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("dialogChanged();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("public void keyPressed(KeyEvent e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("// do nothing. wait for release.");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("txtProjectName.addKeyListener(pageCompleteValidationListener);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private void updateStatus(String msg) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setErrorMessage(msg);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (getContainer().getCurrentPage() != null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("getWizard().getContainer().updateMessage();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("getWizard().getContainer().updateButtons();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("setPageComplete(getErrorMessage() == null);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private void dialogChanged() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("String projectNameError = validateProjectName(txtProjectName.getText());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (projectNameError != null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("updateStatus(projectNameError);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else updateStatus(null);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public String getProjectName() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return txtProjectName.getText();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private String validateProjectName(String projectName) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (projectName.isEmpty())");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return \"Enter project name\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append(".getProjects();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for (IProject p : projects) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (p.getName().equals(projectName))");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("return \"Project: \" + projectName + \" already exists\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (projectName.matches(\".*[:/\\\\\\\\\\\"&<>\\\\?#,;].*\")) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return \"The project name contains illegal characters (:/\\\"&<>?#,;)\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateNewWizardXML(CincoProduct cp, String pName, String idString) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.ui.newWizards\">");
        _builder.newLine();
        _builder.append(idString);
        _builder.newLineIfNotEmpty();
        _builder.append("<wizard");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("category=\"de.jabc.cinco.meta.core.wizards.category.cinco\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class=\"");
        _builder.append(pName, "\t");
        _builder.append(".");
        String _name = cp.getName();
        _builder.append(_name, "\t");
        _builder.append("ProjectWizard\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("id=\"");
        _builder.append(pName, "\t");
        _builder.append(".wizard.");
        String _lowerCase = cp.getName().toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("project\"");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)cp.getImage16());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("icon=");
            String _image16 = cp.getImage16();
            _builder.append(_image16, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("name=\"New ");
        String _name_1 = cp.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" Project\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("project=\"true\">");
        _builder.newLine();
        _builder.append("</wizard>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateNavigatorXML(CincoProduct cp, String pName, String idString) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("point=\"org.eclipse.ui.navigator.navigatorContent\">");
        _builder.newLine();
        _builder.append(idString);
        _builder.append("\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("<commonWizard");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("menuGroupId=\"mgl\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("type=\"new\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("wizardId=\"");
        _builder.append(pName, "\t");
        _builder.append(".wizard.");
        String _lowerCase = cp.getName().toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("project\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<enablement></enablement>");
        _builder.newLine();
        _builder.append("</commonWizard>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        return _builder;
    }
}

