/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class InputComboBoxDialog
extends Dialog {
    private Object value;
    private Combo combo;
    private ComboViewer comboViewer;
    private IContentProvider cProvider = new ArrayContentProvider();
    private ILabelProvider lProvider = new LabelProvider();
    private List<?> input = new ArrayList();

    protected InputComboBoxDialog(Shell parentShell) {
        super(parentShell);
    }

    public InputComboBoxDialog(Shell parentShell, List<?> input) {
        super(parentShell);
        if (input != null) {
            this.input = input;
        }
    }

    public InputComboBoxDialog(Shell parentShell, IContentProvider cProvider, ILabelProvider lProvider, List<?> input) {
        super(parentShell);
        if (cProvider != null) {
            this.cProvider = cProvider;
        }
        if (lProvider != null) {
            this.lProvider = lProvider;
        }
        if (input != null) {
            this.input = input;
        }
    }

    public InputComboBoxDialog(Shell parentShell, IContentProvider cProvider, ILabelProvider lProvider, List<?> input, Object selectedElement) {
        super(parentShell);
        if (cProvider != null) {
            this.cProvider = cProvider;
        }
        if (lProvider != null) {
            this.lProvider = lProvider;
        }
        if (input != null) {
            this.input = input;
        }
        this.value = selectedElement;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select a value");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayoutData((Object)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(comp, 0);
        label.setText("Select a value: ");
        this.combo = new Combo(comp, 8);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.comboViewer = new ComboViewer(this.combo);
        this.comboViewer.setContentProvider(this.cProvider);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.lProvider);
        this.comboViewer.setInput(this.input);
        if (this.value != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection(this.value));
        }
        return comp;
    }

    public Object getValue() {
        return this.value;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.comboViewer.getStructuredSelection().getFirstElement() : null;
        super.buttonPressed(buttonId);
    }
}

