/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ui.utils.CincoPropertyUtils;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalType;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.xtend2.lib.StringConcatenation;

public class TreePropertyViewLabelProvider
extends LabelProvider {
    private final Map<Class<? extends EObject>, EStructuralFeature> typeLabelMap;

    public TreePropertyViewLabelProvider(Map<Class<? extends EObject>, EStructuralFeature> typeLabelMap) {
        this.typeLabelMap = typeLabelMap;
    }

    public String getText(Object object) {
        String _switchResult = null;
        boolean _matched = false;
        if (object instanceof ModelElement) {
            _matched = true;
            _switchResult = ((ModelElement)object).getInternalElement_().getElement().eClass().getName();
        }
        if (!_matched && object instanceof InternalIdentifiableElement) {
            _matched = true;
            _switchResult = ((InternalIdentifiableElement)object).getElement().eClass().getName();
        }
        if (!_matched && object instanceof Type) {
            _matched = true;
            _switchResult = this.getTypeLabel((Type)object);
        }
        if (!_matched && object instanceof EObject) {
            _matched = true;
            _switchResult = this.getReferenceName((EObject)object);
        }
        if (!_matched) {
            _switchResult = super.getText(object);
        }
        return _switchResult;
    }

    private String getTypeLabel(Type object) {
        Object _eGet;
        InternalType internalType = object.getInternalElement_();
        EStructuralFeature attribute = CincoPropertyUtils.getLabeledFeature(internalType.getClass(), this.typeLabelMap);
        if (attribute == null) {
            return this.getReferenceName((EObject)object);
        }
        Object it = _eGet = internalType.eGet(attribute);
        boolean _matched = false;
        if (it instanceof String) {
            boolean _not;
            boolean _isEmpty = ((String)it).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _matched = true;
                return (String)it;
            }
        }
        if (!_matched && it instanceof Enum) {
            _matched = true;
            return ((Enum)it).toString();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<<");
        String _name = attribute.getName();
        _builder.append(_name);
        _builder.append(">>");
        return _builder.toString();
    }

    private String getReferenceName(EObject object) {
        EObject eContainer = object.eContainer();
        EList _eAllReferences = eContainer.eClass().getEAllReferences();
        for (EReference ref : _eAllReferences) {
            boolean _contains;
            Object _eGet;
            Object it = _eGet = eContainer.eGet((EStructuralFeature)ref, true);
            boolean _matched = false;
            if (it instanceof List && (_contains = ((List)it).contains(object))) {
                _matched = true;
                return ref.getName();
            }
            if (_matched || !Objects.equal((Object)it, (Object)object)) continue;
            _matched = true;
            return ref.getName();
        }
        return null;
    }
}

