/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Type;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PossibleValues<T> {
    public static final String NULL_LABEL = "";
    public static final String NAME_ATTRIBUTE = "name";
    private final Map<T, String> map;

    public PossibleValues(Map<T, String> possibleValuesMap) {
        this.map = this.fixLabels(possibleValuesMap);
    }

    public T getValue(final String searchLabel) {
        Functions.Function2 _function = new Functions.Function2<T, String, Boolean>(){

            public Boolean apply(T value, String valueLabel) {
                return Objects.equal((Object)valueLabel, (Object)searchLabel);
            }
        };
        return (T)IterableExtensions.head(MapExtensions.filter(this.map, (Functions.Function2)_function).keySet());
    }

    public String getLabel(T searchValue) {
        return this.map.get(searchValue);
    }

    public T[] getValues() {
        return (Object[])Conversions.unwrapArray(this.map.keySet(), Object.class);
    }

    public String[] getLabels() {
        return (String[])Conversions.unwrapArray(this.map.values(), String.class);
    }

    public boolean existsValue(T searchValue) {
        return this.map.containsKey(searchValue);
    }

    public boolean existsLabel(String searchLabel) {
        return this.map.containsValue(searchLabel);
    }

    public void addNull() {
        this.map.put(null, NULL_LABEL);
    }

    public static <F> PossibleValues<Object> fromAttribute(EObject bo, EAttribute attribute, Map<F, String> map) {
        final Class attributeClass = attribute.getEAttributeType().getInstanceClass();
        Set<Map.Entry<F, String>> _entrySet = null;
        if (map != null) {
            _entrySet = map.entrySet();
        }
        Iterable _filter = null;
        if (_entrySet != null) {
            Functions.Function1 _function = new Functions.Function1<Map.Entry<F, String>, Boolean>(){

                public Boolean apply(Map.Entry<F, String> it) {
                    return it.getKey() == null || PossibleValues.canCastTo(it.getKey().getClass(), attributeClass);
                }
            };
            _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        }
        Map _map = null;
        if (_filter != null) {
            Functions.Function1 _function_1 = new Functions.Function1<Map.Entry<F, String>, Object>(){

                public Object apply(Map.Entry<F, String> it) {
                    return PossibleValues.castTo(it.getKey(), attributeClass);
                }
            };
            Functions.Function1 _function_2 = new Functions.Function1<Map.Entry<F, String>, String>(){

                public String apply(Map.Entry<F, String> it) {
                    return it.getValue();
                }
            };
            _map = IterableExtensions.toMap((Iterable)_filter, (Functions.Function1)_function_1, (Functions.Function1)_function_2);
        }
        Map possibleValuesMap = _map;
        return new PossibleValues<Object>(possibleValuesMap);
    }

    private static Class<?> wrapped(Class<?> primitiveType) {
        Class _switchResult = null;
        boolean _matched = false;
        if (Objects.equal(primitiveType, Byte.TYPE)) {
            _matched = true;
            _switchResult = Byte.class;
        }
        if (!_matched && Objects.equal(primitiveType, Short.TYPE)) {
            _matched = true;
            _switchResult = Short.class;
        }
        if (!_matched && Objects.equal(primitiveType, Integer.TYPE)) {
            _matched = true;
            _switchResult = Integer.class;
        }
        if (!_matched && Objects.equal(primitiveType, Long.TYPE)) {
            _matched = true;
            _switchResult = Long.class;
        }
        if (!_matched && Objects.equal(primitiveType, Float.TYPE)) {
            _matched = true;
            _switchResult = Float.class;
        }
        if (!_matched && Objects.equal(primitiveType, Double.TYPE)) {
            _matched = true;
            _switchResult = Double.class;
        }
        if (!_matched && Objects.equal(primitiveType, Character.TYPE)) {
            _matched = true;
            _switchResult = Character.class;
        }
        if (!_matched && Objects.equal(primitiveType, Boolean.TYPE)) {
            _matched = true;
            _switchResult = Boolean.class;
        }
        if (!_matched && Objects.equal(primitiveType, Void.TYPE)) {
            _matched = true;
            _switchResult = Void.class;
        }
        if (!_matched && Objects.equal(primitiveType, null)) {
            _matched = true;
            throw new NullPointerException();
        }
        if (!_matched) {
            _switchResult = primitiveType;
        }
        return _switchResult;
    }

    private static <F, T> boolean canCastTo(Class<F> fromClass, Class<T> toClass) {
        return PossibleValues.wrapped(toClass).isAssignableFrom(PossibleValues.wrapped(fromClass));
    }

    private static <F, T> T castTo(F object, Class<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            Comparable<Byte> _switchResult = null;
            boolean _matched = false;
            if (Objects.equal(type, Byte.TYPE)) {
                _matched = true;
                _switchResult = (byte)0;
            }
            if (!_matched && Objects.equal(type, Short.TYPE)) {
                _matched = true;
                _switchResult = (short)0;
            }
            if (!_matched && Objects.equal(type, Integer.TYPE)) {
                _matched = true;
                _switchResult = 0;
            }
            if (!_matched && Objects.equal(type, Long.TYPE)) {
                _matched = true;
                _switchResult = 0L;
            }
            if (!_matched && Objects.equal(type, Float.TYPE)) {
                _matched = true;
                _switchResult = Float.valueOf(0.0f);
            }
            if (!_matched && Objects.equal(type, Double.TYPE)) {
                _matched = true;
                _switchResult = 0.0;
            }
            if (!_matched && Objects.equal(type, Character.TYPE)) {
                _matched = true;
                _switchResult = Character.valueOf('\u0000');
            }
            if (!_matched && Objects.equal(type, Boolean.TYPE)) {
                _matched = true;
                _switchResult = false;
            }
            if (!_matched) {
                _switchResult = null;
            }
            return (T)_switchResult;
        }
        boolean _canCastTo = PossibleValues.canCastTo(object.getClass(), type);
        if (_canCastTo) {
            return (T)object;
        }
        throw new ClassCastException();
    }

    public static PossibleValues<Enumerator> fromEnum(EEnum eEnum) {
        Functions.Function1<EEnumLiteral, Enumerator> _function = new Functions.Function1<EEnumLiteral, Enumerator>(){

            public Enumerator apply(EEnumLiteral it) {
                return it.getInstance();
            }
        };
        Functions.Function1<EEnumLiteral, String> _function_1 = new Functions.Function1<EEnumLiteral, String>(){

            public String apply(EEnumLiteral it) {
                return it.getLiteral();
            }
        };
        Map possibleValuesMap = IterableExtensions.toMap((Iterable)eEnum.getELiterals(), (Functions.Function1)_function, (Functions.Function1)_function_1);
        return new PossibleValues<Enumerator>(possibleValuesMap);
    }

    public static <F> PossibleValues<ModelElement> fromReference(EObject bo, EReference reference, Map<F, String> map) {
        Map possibleValuesMap = null;
        if (map == null) {
            Class _instanceClass;
            Class referenceClass = _instanceClass = reference.getEReferenceType().getInstanceClass();
            List values = PossibleValues.getAllModelElements(bo, referenceClass);
            Functions.Function1<ModelElement, String> _function = new Functions.Function1<ModelElement, String>(){

                public String apply(ModelElement it) {
                    return PossibleValues.getName(it);
                }
            };
            Functions.Function1<ModelElement, ModelElement> _function_1 = new Functions.Function1<ModelElement, ModelElement>(){

                public ModelElement apply(ModelElement it) {
                    return it;
                }
            };
            Functions.Function1<ModelElement, String> _function_2 = new Functions.Function1<ModelElement, String>(){

                public String apply(ModelElement it) {
                    return PossibleValues.getName(it);
                }
            };
            possibleValuesMap = IterableExtensions.toMap((Iterable)IterableExtensions.sortBy(values, (Functions.Function1)_function), (Functions.Function1)_function_1, (Functions.Function1)_function_2);
        } else {
            Functions.Function1 _function_3 = new Functions.Function1<Map.Entry<F, String>, Boolean>(){

                public Boolean apply(Map.Entry<F, String> it) {
                    Object _key = it.getKey();
                    return _key instanceof ModelElement;
                }
            };
            Functions.Function1 _function_4 = new Functions.Function1<Map.Entry<F, String>, ModelElement>(){

                public ModelElement apply(Map.Entry<F, String> it) {
                    Object _key = it.getKey();
                    return (ModelElement)_key;
                }
            };
            Functions.Function1 _function_5 = new Functions.Function1<Map.Entry<F, String>, String>(){

                public String apply(Map.Entry<F, String> it) {
                    return it.getValue();
                }
            };
            possibleValuesMap = IterableExtensions.toMap((Iterable)IterableExtensions.filter(map.entrySet(), (Functions.Function1)_function_3), (Functions.Function1)_function_4, (Functions.Function1)_function_5);
        }
        PossibleValues<ModelElement> possibleValues = new PossibleValues<ModelElement>(possibleValuesMap);
        possibleValues.addNull();
        return possibleValues;
    }

    public static <E extends ModelElement> List<E> getAllModelElements(EObject bo, Class<E> searchClass) {
        GraphModel _switchResult = null;
        boolean _matched = false;
        if (bo instanceof GraphModel) {
            _matched = true;
            _switchResult = (GraphModel)bo;
        }
        if (!_matched && bo instanceof InternalGraphModel) {
            _matched = true;
            _switchResult = ((InternalGraphModel)bo).getElement();
        }
        if (!_matched && bo instanceof ModelElement) {
            _matched = true;
            _switchResult = ((ModelElement)bo).getRootElement();
        }
        if (!_matched && bo instanceof InternalModelElement) {
            _matched = true;
            _switchResult = ((InternalModelElement)bo).getRootElement().getElement();
        }
        if (!_matched && bo instanceof Type) {
            _matched = true;
            _switchResult = new GraphModelExtension().getRootElement((Type)bo);
        }
        if (!_matched && bo instanceof InternalType) {
            _matched = true;
            _switchResult = new GraphModelExtension().getRootElement(((InternalType)bo).getElement());
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Parameter \"bo\" has unknown type \"");
            String _name = bo.getClass().getName();
            _builder.append(_name);
            _builder.append("\".");
            throw new IllegalArgumentException(_builder.toString());
        }
        GraphModel graphModel = _switchResult;
        return IterableExtensions.toList(PossibleValues.getAllModelElementsRecursive((ModelElementContainer)graphModel, searchClass));
    }

    private static <E extends ModelElement> Iterable<E> getAllModelElementsRecursive(ModelElementContainer container, final Class<E> searchClass) {
        EList modelElements = container.getModelElements(searchClass);
        Functions.Function1 _function = new Functions.Function1<Container, Iterable<E>>(){

            public Iterable<E> apply(Container con) {
                return PossibleValues.getAllModelElementsRecursive((ModelElementContainer)con, searchClass);
            }
        };
        Iterable childModelElements = IterableExtensions.flatMap((Iterable)container.getAllContainers(), (Functions.Function1)_function);
        return Iterables.concat((Iterable)modelElements, (Iterable)childModelElements);
    }

    private static String getName(Object object) {
        Object it = object;
        boolean _matched = false;
        if (Objects.equal((Object)it, null)) {
            _matched = true;
            return NULL_LABEL;
        }
        if (!_matched && it instanceof ModelElement) {
            Object nameFeatureValue;
            _matched = true;
            EStructuralFeature nameFeature = ((ModelElement)it).getInternalElement_().eClass().getEStructuralFeature(NAME_ATTRIBUTE);
            if (nameFeature != null && (nameFeatureValue = ((ModelElement)it).getInternalElement_().eGet(nameFeature)) instanceof String) {
                boolean _not;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((String)nameFeatureValue));
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    return (String)nameFeatureValue;
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            String _name = ((ModelElement)it).eClass().getName();
            _builder.append(_name);
            _builder.append(" (");
            String _id = ((ModelElement)it).getId();
            _builder.append(_id);
            _builder.append(")");
            return _builder.toString();
        }
        if (!_matched && it instanceof IdentifiableElement) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            String _name = ((IdentifiableElement)it).eClass().getName();
            _builder.append(_name);
            _builder.append(" (");
            String _id = ((IdentifiableElement)it).getId();
            _builder.append(_id);
            _builder.append(")");
            return _builder.toString();
        }
        return it.toString();
    }

    private Map<T, String> fixLabels(Map<T, String> possibleValues) {
        if (possibleValues == null || possibleValues.isEmpty()) {
            return CollectionLiterals.newHashMap();
        }
        final LinkedHashMap valueToLabel = CollectionLiterals.newLinkedHashMap();
        final LinkedHashMap labelToDuplicate = CollectionLiterals.newLinkedHashMap();
        final LinkedHashMap labelToCount = CollectionLiterals.newLinkedHashMap();
        BiConsumer _function = new BiConsumer<T, String>(){

            @Override
            public void accept(T value, String label) {
                String _switchResult = null;
                boolean _matched = false;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)label);
                if (_isNullOrEmpty) {
                    _matched = true;
                    _switchResult = PossibleValues.getName(value);
                }
                if (!_matched && Objects.equal((Object)label, (Object)PossibleValues.NULL_LABEL)) {
                    _matched = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("\"");
                    _builder.append(label);
                    _builder.append("\"");
                    _switchResult = _builder.toString();
                }
                if (!_matched) {
                    _switchResult = label;
                }
                String checkedLabel = _switchResult;
                valueToLabel.put(value, checkedLabel);
                boolean _containsKey = labelToDuplicate.containsKey(checkedLabel);
                if (_containsKey) {
                    labelToDuplicate.put(checkedLabel, true);
                } else {
                    labelToDuplicate.put(checkedLabel, false);
                }
            }
        };
        possibleValues.forEach(_function);
        BiConsumer _function_1 = new BiConsumer<T, String>(){

            @Override
            public void accept(T value, String label) {
                Boolean duplicate = (Boolean)labelToDuplicate.get(label);
                if (duplicate.booleanValue()) {
                    Integer _orDefault = labelToCount.getOrDefault(label, 0);
                    int count = _orDefault + 1;
                    labelToCount.put(label, count);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(label);
                    _builder.append(" (");
                    _builder.append((Object)count);
                    _builder.append(")");
                    valueToLabel.put(value, _builder.toString());
                }
            }
        };
        valueToLabel.forEach(_function_1);
        return valueToLabel;
    }

    public String toString() {
        Functions.Function1 _function = new Functions.Function1<Map.Entry<T, String>, CharSequence>(){

            public CharSequence apply(Map.Entry<T, String> it) {
                StringConcatenation _builder = new StringConcatenation();
                Object _key = it.getKey();
                _builder.append(_key);
                _builder.append(" <-> \"");
                String _value = it.getValue();
                _builder.append(_value);
                _builder.append("\"");
                return _builder.toString();
            }
        };
        return IterableExtensions.join(this.map.entrySet(), (CharSequence)"{\n\t", (CharSequence)",\n\t", (CharSequence)"\n}", (Functions.Function1)_function);
    }
}

