/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties;

import com.google.common.base.Objects;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.swt.widgets.DateTime;

public class DateTimeProperty
extends WidgetValueProperty<DateTime, Date> {
    private final DateTime dateControl;
    private final DateTime timeControl;

    public DateTimeProperty(DateTime dateControl, DateTime timeControl) {
        super(new int[]{16});
        this.dateControl = dateControl;
        this.timeControl = timeControl;
    }

    public Object getValueType() {
        return Date.class;
    }

    public Date doGetValue(DateTime source) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (source == this.dateControl || Objects.equal((Object)source, (Object)this.timeControl)) {
            calendar.set(1, this.dateControl.getYear());
            calendar.set(2, this.dateControl.getMonth());
            calendar.set(5, this.dateControl.getDay());
            calendar.set(11, this.timeControl.getHours());
            calendar.set(12, this.timeControl.getMinutes());
            calendar.set(13, this.timeControl.getSeconds());
        } else if ((source.getStyle() & 0x80) != 0) {
            calendar.set(11, source.getHours());
            calendar.set(12, source.getMinutes());
            calendar.set(13, source.getSeconds());
        } else {
            calendar.set(1, source.getYear());
            calendar.set(2, source.getMonth());
            calendar.set(5, source.getDay());
        }
        return calendar.getTime();
    }

    public void doSetValue(DateTime source, Date value) {
        if (value == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        if (source == this.dateControl || Objects.equal((Object)source, (Object)this.timeControl)) {
            this.dateControl.setYear(calendar.get(1));
            this.dateControl.setMonth(calendar.get(2));
            this.dateControl.setDay(calendar.get(5));
            this.timeControl.setHours(calendar.get(11));
            this.timeControl.setMinutes(calendar.get(12));
            this.timeControl.setSeconds(calendar.get(13));
        } else if ((source.getStyle() & 0x80) != 0) {
            source.setHours(calendar.get(11));
            source.setMinutes(calendar.get(12));
            source.setSeconds(calendar.get(13));
        } else {
            source.setYear(calendar.get(1));
            source.setMonth(calendar.get(2));
            source.setDay(calendar.get(5));
        }
    }

    public <M extends DateTime> IObservableValue<Date> observeDetail(IObservableValue<M> master) {
        return super.observeDetail(master);
    }

    public <M extends DateTime> IObservableList<Date> observeDetail(IObservableList<M> master) {
        return super.observeDetail(master);
    }

    public <M extends DateTime> IObservableMap<M, Date> observeDetail(IObservableSet<M> master) {
        return super.observeDetail(master);
    }

    public <K, V extends DateTime> IObservableMap<K, Date> observeDetail(IObservableMap<K, V> master) {
        return super.observeDetail(master);
    }
}

