/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties;

import com.google.inject.Injector;
import de.jabc.cinco.meta.core.ui.action.AddAttributeAction;
import de.jabc.cinco.meta.core.ui.action.AddReferenceAction;
import de.jabc.cinco.meta.core.ui.action.EditAttributeAction;
import de.jabc.cinco.meta.core.ui.action.EditReferenceAction;
import de.jabc.cinco.meta.core.ui.action.RemoveAttributeAction;
import de.jabc.cinco.meta.core.ui.action.RemoveReferenceAction;
import de.jabc.cinco.meta.core.ui.converter.ByteToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.CharacterToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.ColorToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.DoubleToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.FloatToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.IntegerToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.LongToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.ShortToStringConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToByteConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToCharacterConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToColorConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToDoubleConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToFloatConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToIntegerConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToLongConverter;
import de.jabc.cinco.meta.core.ui.converter.StringToShortConverter;
import de.jabc.cinco.meta.core.ui.listener.BrowseSelectionListener;
import de.jabc.cinco.meta.core.ui.listener.CincoTreeMenuListener;
import de.jabc.cinco.meta.core.ui.properties.AttributeChangeEventStrategy;
import de.jabc.cinco.meta.core.ui.properties.CincoResourceProvider;
import de.jabc.cinco.meta.core.ui.properties.CincoTreeFactory;
import de.jabc.cinco.meta.core.ui.properties.CincoTreeStructureAdvisor;
import de.jabc.cinco.meta.core.ui.properties.ComboProperty;
import de.jabc.cinco.meta.core.ui.properties.DateTimeProperty;
import de.jabc.cinco.meta.core.ui.properties.PossibleValues;
import de.jabc.cinco.meta.core.ui.properties.PossibleValuesLabelProvider;
import de.jabc.cinco.meta.core.ui.properties.TreePropertyViewLabelProvider;
import de.jabc.cinco.meta.core.ui.utils.CincoPropertyUtils;
import de.jabc.cinco.meta.core.ui.validator.BooleanValidator;
import de.jabc.cinco.meta.core.ui.validator.ByteValidator;
import de.jabc.cinco.meta.core.ui.validator.CharacterValidator;
import de.jabc.cinco.meta.core.ui.validator.ColorValidator;
import de.jabc.cinco.meta.core.ui.validator.DateValidator;
import de.jabc.cinco.meta.core.ui.validator.DoubleValidator;
import de.jabc.cinco.meta.core.ui.validator.FloatValidator;
import de.jabc.cinco.meta.core.ui.validator.GrammarValidator;
import de.jabc.cinco.meta.core.ui.validator.IntegerValidator;
import de.jabc.cinco.meta.core.ui.validator.LongValidator;
import de.jabc.cinco.meta.core.ui.validator.ObjectValidator;
import de.jabc.cinco.meta.core.ui.validator.PossibleValuesValidator;
import de.jabc.cinco.meta.core.ui.validator.ShortValidator;
import de.jabc.cinco.meta.core.ui.validator.StringValidator;
import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Type;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.platform.GraphitiConnectionEditPart;
import org.eclipse.graphiti.ui.platform.GraphitiShapeEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.osgi.framework.Bundle;

public class CincoPropertyView
extends ViewPart
implements ISelectionListener {
    private static final int MIN_MULTILINE_HEIGHT = 100;
    private static WorkbenchExtension workbench = new WorkbenchExtension();
    private static Map<Class<? extends EObject>, IEMFListProperty> emfListPropertiesMap = new HashMap<Class<? extends EObject>, IEMFListProperty>();
    private static Map<Class<? extends EObject>, List<EStructuralFeature>> attributesMap = new HashMap<Class<? extends EObject>, List<EStructuralFeature>>();
    private static Map<Class<? extends EObject>, List<EStructuralFeature>> referencesMap = new HashMap<Class<? extends EObject>, List<EStructuralFeature>>();
    private static Map<Class<? extends EObject>, EStructuralFeature> typeLabels = new HashMap<Class<? extends EObject>, EStructuralFeature>();
    private static Map<EStructuralFeature, Map<? extends Object, String>> possibleValuesMap = new HashMap<EStructuralFeature, Map<? extends Object, String>>();
    private static Map<EStructuralFeature, Injector> grammarAttributes = new HashMap<EStructuralFeature, Injector>();
    private static Map<EStructuralFeature, List<String>> fileExtensionFilters = new HashMap<EStructuralFeature, List<String>>();
    private static Map<EStructuralFeature, String> colorParameters = new HashMap<EStructuralFeature, String>();
    private static Set<EStructuralFeature> multiLineAttributes = new HashSet<EStructuralFeature>();
    private static Set<EStructuralFeature> readOnlyAttributes = new HashSet<EStructuralFeature>();
    private static Set<EStructuralFeature> fileAttributes = new HashSet<EStructuralFeature>();
    private static Set<EStructuralFeature> colorAttributes = new HashSet<EStructuralFeature>();
    private static Set<EClass> disableCreate = new HashSet<EClass>();
    private static Set<EClass> disableDelete = new HashSet<EClass>();
    public static Set<Consumer<EObject>> postSelects = new HashSet<Consumer<EObject>>();
    public static Set<Consumer<EObject>> possibleValueRefreshs = new HashSet<Consumer<EObject>>();
    public static Functions.Function3<EObject, String, Object, String> canAttributeChange = (bo, attrName, value) -> null;
    public static Procedures.Procedure3<EObject, String, Object> preAttributeChange = (bo, attrName, value) -> {};
    private static CincoPropertyView instance;
    private Composite parent;
    private ScrolledComposite simpleViewComposite;
    private Composite treeViewComposite;
    private TransactionalEditingDomain domain;
    private EMFDataBindingContext context = new EMFDataBindingContext();
    private Object lastSelectedObject;
    private PictogramElement lastSelectedPictogramElement;

    public CincoPropertyView() {
        if (instance != null) {
            CincoPropertyView.removeSelectionListener(instance);
        }
        instance = this;
        CincoPropertyView.assertSelectionListener();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        PictogramElement pe = null;
        if (element instanceof GraphitiShapeEditPart) {
            pe = ((GraphitiShapeEditPart)element).getPictogramElement();
        } else if (element instanceof GraphitiConnectionEditPart) {
            pe = ((GraphitiConnectionEditPart)element).getPictogramElement();
        }
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
        if (bo != null) {
            for (Consumer<EObject> possibleValueRefresh : possibleValueRefreshs) {
                possibleValueRefresh.accept(bo);
            }
            this.init_PropertyView(bo);
        } else {
            this.clearPage();
        }
        DiagramBehavior diagramBehavior = null;
        DiagramEditor editor = workbench.getActiveDiagramEditor();
        if (editor != null) {
            diagramBehavior = editor.getDiagramBehavior();
        }
        if (diagramBehavior instanceof DiagramBehavior) {
            DiagramBehavior db = diagramBehavior;
            if (pe instanceof ConnectionDecorator && !pe.equals(this.lastSelectedPictogramElement)) {
                Connection connection = ((ConnectionDecorator)pe).getConnection();
                this.lastSelectedPictogramElement = pe;
                db.getDiagramContainer().selectPictogramElements(new PictogramElement[]{pe, connection});
            }
            this.lastSelectedPictogramElement = pe;
        }
        if (bo != null) {
            for (Consumer<EObject> postSelect : postSelects) {
                postSelect.accept(bo);
            }
        }
    }

    private void clearPage() {
        if (this.parent != null) {
            this.disposeChildren(this.parent);
        }
    }

    public static void assertSelectionListener() {
        if (instance == null) {
            instance = new CincoPropertyView();
        }
        CincoPropertyView.addSelectionListener(instance);
    }

    public static void removeSelectionListener(ISelectionListener listener) {
        try {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            activePage.removeSelectionListener(listener);
        }
        catch (Exception e) {
            System.out.println("Not In Graphical Model.");
            return;
        }
    }

    public static void addSelectionListener(ISelectionListener listener) {
        try {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            activePage.addSelectionListener(listener);
        }
        catch (Exception e) {
            System.out.println("Not In Graphical Model.");
            return;
        }
    }

    public static void init_EStructuralFeatures(Class<? extends EObject> clazz, EStructuralFeature ... features) {
        List<EStructuralFeature> featureList = Arrays.asList(features);
        List attributeList = featureList.stream().filter(f -> f instanceof EAttribute || f instanceof EReference && !((EReference)f).isContainment()).collect(Collectors.toList());
        List<EStructuralFeature> referenceList = featureList.stream().filter(f -> f instanceof EReference && ((EReference)f).isContainment()).collect(Collectors.toList());
        CincoPropertyView.init_ListPorperties(clazz, referenceList.toArray(new EStructuralFeature[0]));
        if (referencesMap.get(clazz) == null) {
            referencesMap.put(clazz, referenceList);
        }
        if (attributesMap.get(clazz) == null) {
            attributesMap.put(clazz, attributeList);
        }
    }

    public static void init_ListPorperties(Class<? extends EObject> clazz, EStructuralFeature ... features) {
        if (emfListPropertiesMap.get(clazz) == null) {
            emfListPropertiesMap.put(clazz, EMFProperties.multiList((EStructuralFeature[])features));
        }
    }

    public static void init_MultiLineAttributes(EStructuralFeature ... features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            multiLineAttributes.add(f);
            ++n2;
        }
    }

    public static void init_ReadOnlyAttributes(EStructuralFeature ... features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            readOnlyAttributes.add(f);
            ++n2;
        }
    }

    public static void init_FileAttributes(EStructuralFeature ... features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            fileAttributes.add(f);
            ++n2;
        }
    }

    public static void init_FileAttributesExtensionFilters(EStructuralFeature feature, String ... extensions) {
        fileExtensionFilters.put(feature, Arrays.asList(extensions));
    }

    public static void init_ColorAttributes(EStructuralFeature ... features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            colorAttributes.add(f);
            ++n2;
        }
    }

    public static void init_ColorAttributesParameter(EStructuralFeature feature, String parameter) {
        colorParameters.put(feature, parameter);
    }

    public static void init_GrammarEditor(EStructuralFeature feature, Injector injector) {
        grammarAttributes.put(feature, injector);
    }

    public static void init_DisableCreate(EClass ... eClasses) {
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            disableCreate.add(eClass);
            ++n2;
        }
    }

    public static void init_DisableDelete(EClass ... eClasses) {
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            disableDelete.add(eClass);
            ++n2;
        }
    }

    public static void init_TypeLabel(Class<? extends EObject> clazz, EStructuralFeature feature) {
        typeLabels.put(clazz, feature);
    }

    public void init_PropertyView(EObject bo) {
        if (this.parent == null) {
            return;
        }
        if (bo instanceof IdentifiableElement) {
            bo = ((IdentifiableElement)bo).getInternalElement_();
        }
        if (bo == null || bo.equals(this.lastSelectedObject)) {
            return;
        }
        this.disposeChildren(this.parent);
        this.context = new EMFDataBindingContext();
        this.parent.setLayout((Layout)new GridLayout(2, false));
        this.treeViewComposite = new Composite(this.parent, 2048);
        this.treeViewComposite.setLayout((Layout)new GridLayout(1, false));
        this.treeViewComposite.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.simpleViewComposite = new ScrolledComposite(this.parent, 2816);
        this.simpleViewComposite.setLayout((Layout)new GridLayout(1, false));
        this.simpleViewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreePropertyView(bo);
        this.createSimplePropertyView(bo);
        this.treeViewComposite.pack();
        this.simpleViewComposite.pack();
        this.treeViewComposite.layout(true);
        this.simpleViewComposite.layout(true);
        this.parent.layout(true);
        this.lastSelectedObject = bo;
    }

    public static void refreshPossibleValues(EStructuralFeature feature, Map<? extends Object, String> values) {
        possibleValuesMap.put(feature, values);
    }

    public static Map<? extends Object, String> getPossibleValues(EStructuralFeature feature) {
        return possibleValuesMap.get(feature);
    }

    public void createTreePropertyView(EObject bo) {
        Tree tree = new Tree(this.treeViewComposite, 4);
        GridData data = new GridData(16384, 4, false, true);
        data.widthHint = 255;
        tree.setLayoutData((Object)data);
        TreeViewer viewer = new TreeViewer(tree);
        ObservableListTreeContentProvider cp = new ObservableListTreeContentProvider((IObservableFactory)new CincoTreeFactory(bo, emfListPropertiesMap), (TreeStructureAdvisor)new CincoTreeStructureAdvisor(referencesMap));
        viewer.setContentProvider((IContentProvider)cp);
        viewer.setLabelProvider((IBaseLabelProvider)new TreePropertyViewLabelProvider(typeLabels));
        List<EStructuralFeature> inputList = CincoPropertyUtils.getAllEStructuralFeatures(bo.getClass(), referencesMap);
        IEMFEditListProperty input = EMFEditProperties.multiList((EditingDomain)this.domain, (EStructuralFeature[])inputList.toArray(new EStructuralFeature[0]));
        viewer.setInput((Object)input.observe((Object)bo));
        viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof Type) {
                    InternalType internalElement = ((Type)obj).getInternalElement_();
                    for (Consumer<EObject> possibleValueRefresh : possibleValueRefreshs) {
                        possibleValueRefresh.accept((EObject)obj);
                    }
                    this.createSimplePropertyView((EObject)internalElement);
                } else if (obj instanceof EObject) {
                    this.createSimplePropertyView((EObject)obj);
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new CincoTreeMenuListener((StructuredViewer)viewer, referencesMap, disableCreate, disableDelete));
        viewer.getControl().setMenu(menuManager.createContextMenu((Control)tree));
        viewer.getTree().setSelection(viewer.getTree().getItem(0));
        viewer.expandAll();
    }

    private void createUIAndBindings(EObject bo, Composite comp) {
        Resource resource = bo.eResource();
        if (resource == null) {
            if (bo instanceof InternalType) {
                resource = ((InternalType)bo).getElement().eResource();
            } else if (bo instanceof Type) {
                resource = ((Type)bo).getInternalElement_().eResource();
            }
        }
        this.domain = new ResourceExtension().getEditingDomain(resource);
        List<EStructuralFeature> attributes = CincoPropertyUtils.getAllEStructuralFeatures(bo.getClass(), attributesMap);
        if (attributes.isEmpty()) {
            Label label = new Label(comp, 0);
            label.setText("No properties available ...");
        } else {
            for (EStructuralFeature attr : attributes) {
                if (attr.getUpperBound() == 1) {
                    this.createSingleAttributeProperty(bo, comp, attr);
                    continue;
                }
                if (attr.getUpperBound() == -1 || attr.getUpperBound() > 1) {
                    this.createMultiAttributeProperty(bo, comp, attr);
                    continue;
                }
                System.err.println("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Upper bound of attribute '" + attr.getName() + "' is " + attr.getUpperBound());
            }
        }
    }

    private void setLayoutData(Control control, boolean fillHorizontal, boolean centerVertical, boolean grabExcessHorizontal, boolean grabExcessVertical, int spanHorizontal, int verticalSpan) {
        GridData gridData = new GridData(fillHorizontal ? 4 : 16384, centerVertical ? 0x1000000 : 128, grabExcessHorizontal, grabExcessVertical, spanHorizontal, verticalSpan);
        control.setLayoutData((Object)gridData);
    }

    private void setLayoutData(Label label) {
        this.setLayoutData(label, false);
    }

    private void setLayoutData(Label label, boolean multiline) {
        GridData gridData = new GridData(128, multiline ? 128 : 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gridData);
    }

    private void setLayoutData(Text text) {
        GridData gridData;
        if ((text.getStyle() & 2) == 0) {
            gridData = new GridData(4, 0x1000000, true, false, 3, 1);
        } else {
            gridData = new GridData(4, 4, true, true, 3, 1);
            gridData.minimumHeight = 100;
        }
        text.setLayoutData((Object)gridData);
    }

    private void setLayoutData(Combo combo) {
        GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
        combo.setLayoutData((Object)gridData);
    }

    private void setLayoutData(Button button) {
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        button.setLayoutData((Object)gridData);
    }

    private void setLayoutData(EmbeddedEditor editor) {
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.minimumHeight = 100;
        editor.getViewer().getControl().setLayoutData((Object)gridData);
    }

    private void setLayoutData(Table table) {
        GridData gridData = new GridData(4, 4, true, true, 2, 3);
        gridData.minimumHeight = 100;
        table.setLayoutData((Object)gridData);
    }

    protected void createSimplePropertyView(EObject bo) {
        if (this.simpleViewComposite == null) {
            throw new RuntimeException("NPE: Composite for the simple property view is null");
        }
        this.disposeChildren((Composite)this.simpleViewComposite);
        Composite comp = new Composite((Composite)this.simpleViewComposite, 0);
        comp.setLayout((Layout)new GridLayout(4, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createUIAndBindings(bo, comp);
        this.simpleViewComposite.setContent((Control)comp);
        this.simpleViewComposite.setExpandHorizontal(true);
        this.simpleViewComposite.setExpandVertical(true);
        this.simpleViewComposite.setAlwaysShowScrollBars(true);
        this.simpleViewComposite.layout(true, true);
        this.simpleViewComposite.setMinSize(comp.computeSize(-1, -1));
    }

    private void createSingleAttributeProperty(EObject bo, Composite comp, EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            this.createSingleAttributeProperty(bo, comp, (EAttribute)feature);
        } else if (feature instanceof EReference) {
            this.createSingleAttributeProperty(bo, comp, (EReference)feature);
        }
    }

    private void createSingleAttributeProperty(EObject bo, Composite comp, EReference ref) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(ref.getName()) + ": ");
        Combo combo = new Combo(comp, 2060);
        this.setLayoutData(combo);
        PossibleValues<ModelElement> modelElementPossibleValues = PossibleValues.fromReference(bo, ref, possibleValuesMap.get(ref));
        combo.setItems(modelElementPossibleValues.getLabels());
        combo.addSelectionListener(new PossibleValuesValidator<ModelElement>(bo, (EStructuralFeature)ref, combo, modelElementPossibleValues));
        ISWTObservableValue targetProperty = new ComboProperty<ModelElement>(modelElementPossibleValues).observe((Widget)combo);
        IObservableValue modelProperty = EMFEditObservables.observeValue((EditingDomain)this.domain, (EObject)bo, (EStructuralFeature)ref);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)ref);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, updateStrategy, null);
        combo.setEnabled(!readOnlyAttributes.contains(ref));
    }

    public static List<Object> getInput(EObject bo, Class<?> searchFor) {
        GraphModel gm;
        ArrayList<Object> result = new ArrayList<Object>();
        if (bo instanceof ModelElement) {
            bo = ((ModelElement)bo).getInternalElement_();
        }
        if (bo instanceof InternalModelElement) {
            gm = ((InternalModelElement)bo).getRootElement().getElement();
            CincoPropertyView.getAllModelElements((ModelElementContainer)gm, result, searchFor);
        }
        if (bo instanceof InternalType) {
            gm = new GraphModelExtension().getRootElement(((InternalType)bo).getElement());
            CincoPropertyView.getAllModelElements((ModelElementContainer)gm, result, searchFor);
        }
        return result;
    }

    private static void getAllModelElements(ModelElementContainer container, List<Object> result, Class<?> searchFor) {
        Class<?> modelElementClass = searchFor;
        EList modelElements = container.getModelElements(modelElementClass);
        result.addAll((Collection<Object>)modelElements);
        for (Container c : container.getAllContainers()) {
            CincoPropertyView.getAllModelElements((ModelElementContainer)c, result, searchFor);
        }
    }

    private void createSingleAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        block35: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block34: {
                                if (!(attr.getEAttributeType() instanceof EEnum)) break block34;
                                this.createEnumAttributeProperty(bo, comp, attr);
                                break block35;
                            }
                            if (!fileAttributes.contains(attr)) break block36;
                            this.createFileAttributeProperty(bo, comp, attr);
                            break block35;
                        }
                        if (!colorAttributes.contains(attr)) break block37;
                        this.createColorAttributeProperty(bo, comp, attr);
                        break block35;
                    }
                    if (!possibleValuesMap.containsKey(attr)) break block38;
                    this.createPossibleValuesAttributeProperty(bo, comp, attr);
                    break block35;
                }
                if (!grammarAttributes.containsKey(attr)) break block39;
                this.createGrammarAttributeProperty(bo, comp, attr);
                break block35;
            }
            switch (attr.getEAttributeType().getName()) {
                case "EDate": {
                    this.createDateAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EBoolean": {
                    this.createBooleanAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EByte": {
                    this.createByteAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EShort": {
                    this.createShortAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EInt": {
                    this.createIntAttributeProperty(bo, comp, attr);
                    break;
                }
                case "ELong": {
                    this.createLongAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EFloat": {
                    this.createFloatAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EDouble": {
                    this.createDoubleAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EChar": {
                    this.createCharAttributeProperty(bo, comp, attr);
                    break;
                }
                case "EString": {
                    this.createStringAttributeProperty(bo, comp, attr);
                    break;
                }
                default: {
                    this.createDefaultAttributeProperty(bo, comp, attr);
                }
            }
        }
    }

    private void createEnumAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Combo combo = new Combo(comp, 2060);
        this.setLayoutData(combo);
        EEnum eEnum = (EEnum)attr.getEAttributeType();
        PossibleValues<Enumerator> enumPossibleValues = PossibleValues.fromEnum(eEnum);
        combo.setItems(enumPossibleValues.getLabels());
        combo.addSelectionListener(new PossibleValuesValidator<Enumerator>(bo, (EStructuralFeature)attr, combo, enumPossibleValues));
        ISWTObservableValue targetProperty = new ComboProperty<Enumerator>(enumPossibleValues).observe((Widget)combo);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, updateStrategy, null);
        combo.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createFileAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData((Control)text, true, true, true, false, 2, 1);
        text.setEnabled(false);
        Button button = new Button(comp, 2056);
        this.setLayoutData(button);
        button.setText("Browse ...");
        button.addSelectionListener((SelectionListener)new BrowseSelectionListener(comp.getShell(), text, fileExtensionFilters.get(attr)));
        text.addModifyListener((ModifyListener)new StringValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16, 24}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, updateStrategy, null);
        button.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createColorAttributeProperty(EObject bo, final Composite comp, final EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        final Text text = new Text(comp, 2048);
        this.setLayoutData((Control)text, true, true, true, false, 2, 1);
        text.setEnabled(false);
        Button button = new Button(comp, 2056);
        this.setLayoutData(button);
        try {
            Bundle bundle = Platform.getBundle((String)"de.jabc.cinco.meta.core.ui");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/color_picker.png"), null);
            if (url == null) {
                throw new NullPointerException("Cannot find color picker icon.");
            }
            Image image = ImageDescriptor.createFromURL((URL)url).createImage();
            if (image == null) {
                throw new NullPointerException("Cannot create color picker icon.");
            }
            button.setImage(image);
            button.setText("Pick ...");
        }
        catch (Exception e) {
            e.printStackTrace();
            button.setText("Pick Color ...");
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color color = new StringToColorConverter().convert(text.getText());
                ColorDialog dialog = new ColorDialog(comp.getShell());
                if (color != null) {
                    dialog.setRGB(color.getRGB());
                }
                dialog.setText("Pick a color");
                RGB rgb = dialog.open();
                if (rgb == null) {
                    return;
                }
                if (color != null) {
                    color.dispose();
                }
                color = new Color((Device)comp.getShell().getDisplay(), rgb);
                String stringValue = new ColorToStringConverter(colorParameters.get(attr)).convert(color);
                text.setText(stringValue);
            }
        });
        text.addModifyListener(event -> {
            Color oldBackground = button.getBackground();
            Color newBackground = new StringToColorConverter().convert(text.getText());
            button.setBackground(newBackground);
            if (oldBackground != null) {
                oldBackground.dispose();
            }
            Color oldForeground = button.getForeground();
            Color newForeground = this.getContrastingColor(newBackground);
            button.setForeground(newForeground);
            if (oldForeground != null) {
                oldForeground.dispose();
            }
        });
        text.addModifyListener((ModifyListener)new ColorValidator(bo, (EStructuralFeature)attr, text, colorParameters.get(attr)));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16, 24}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, null);
        button.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private Color getContrastingColor(Color color) {
        double b;
        double g;
        if (color == null) {
            return null;
        }
        double r = this.getRelativeLuminanceValue(color.getRed());
        double relativeLuminance = 0.2126 * r + 0.7152 * (g = this.getRelativeLuminanceValue(color.getGreen())) + 0.0722 * (b = this.getRelativeLuminanceValue(color.getBlue()));
        if (relativeLuminance < 0.5) {
            return new Color((Device)Display.getCurrent(), 255, 255, 255);
        }
        return new Color((Device)Display.getCurrent(), 0, 0, 0);
    }

    private double getRelativeLuminanceValue(int value) {
        if (value <= 10) {
            return (double)value / 3294.6;
        }
        return Math.pow(((double)value + 14.025) / 269.025, 2.4);
    }

    private void createPossibleValuesAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Combo combo = new Combo(comp, 2060);
        this.setLayoutData(combo);
        PossibleValues<Object> possibleValues = PossibleValues.fromAttribute(bo, attr, possibleValuesMap.get(attr));
        combo.setItems(possibleValues.getLabels());
        combo.addSelectionListener(new PossibleValuesValidator<Object>(bo, (EStructuralFeature)attr, combo, possibleValues));
        ISWTObservableValue targetProperty = new ComboProperty<Object>(possibleValues).observe((Widget)combo);
        IObservableValue modelProperty = EMFEditObservables.observeValue((EditingDomain)this.domain, (EObject)bo, (EStructuralFeature)attr);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, updateStrategy, null);
        combo.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createGrammarAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData((Control)label, false, false, false, false, 1, 1);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Injector injector = grammarAttributes.get(attr);
        CincoResourceProvider provider = (CincoResourceProvider)injector.getInstance(CincoResourceProvider.class);
        EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        EmbeddedEditor editor = factory.newEditor((IEditedResourceProvider)provider).showErrorAndWarningAnnotations().withParent(comp);
        editor.createPartialEditor();
        this.setLayoutData(editor);
        StyledText text = editor.getViewer().getTextWidget();
        text.setFont(JFaceResources.getTextFont());
        text.addModifyListener((ModifyListener)new GrammarValidator(bo, (EStructuralFeature)attr, editor));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelPorperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelPorperty, updateStrategy, null);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createDateAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        DateTime date = new DateTime(comp, 32);
        this.setLayoutData((Control)date, false, true, false, false, 1, 1);
        DateTime time = new DateTime(comp, 128);
        this.setLayoutData((Control)time, false, true, true, false, 2, 1);
        DateValidator validator = new DateValidator(bo, (EStructuralFeature)attr, date, time);
        date.addSelectionListener((SelectionListener)validator);
        time.addSelectionListener((SelectionListener)validator);
        DateTimeProperty targetProperty = new DateTimeProperty(date, time);
        ISWTObservableValue targetPropertyDate = targetProperty.observe((Widget)date);
        ISWTObservableValue targetPropertyTime = targetProperty.observe((Widget)time);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy updateStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetPropertyDate, modelProperty, updateStrategy, null);
        this.context.bindValue((IObservableValue)targetPropertyTime, modelProperty, updateStrategy, null);
        date.setEnabled(!readOnlyAttributes.contains(attr));
        time.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createBooleanAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Button checkbox = new Button(comp, 32);
        this.setLayoutData((Control)checkbox, false, true, false, false, 3, 1);
        checkbox.addSelectionListener((SelectionListener)new BooleanValidator(bo, (EStructuralFeature)attr, checkbox));
        ISWTObservableValue targetProperty = WidgetProperties.buttonSelection().observe((Widget)checkbox);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, null);
        checkbox.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createByteAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new ByteValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToByteConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new ByteToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createShortAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new ShortValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToShortConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new ShortToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createIntAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new IntegerValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToIntegerConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new IntegerToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createLongAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new LongValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToLongConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new LongToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createFloatAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new FloatValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToFloatConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new FloatToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createDoubleAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new DoubleValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToDoubleConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new DoubleToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createCharAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new CharacterValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        targetToModelStrategy.setConverter(new StringToCharacterConverter());
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)new CharacterToStringConverter());
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, modelToTargetStrategy);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createStringAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = null;
        if (multiLineAttributes.contains(attr)) {
            this.setLayoutData(label, true);
            text = new Text(comp, 2562);
        } else {
            this.setLayoutData(label, false);
            text = new Text(comp, 2048);
        }
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new StringValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, null);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createDefaultAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData(label);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Text text = new Text(comp, 2048);
        this.setLayoutData(text);
        text.addModifyListener((ModifyListener)new ObjectValidator(bo, (EStructuralFeature)attr, text));
        ISWTObservableValue targetProperty = WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
        IObservableValue modelProperty = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)attr).observe((Object)bo);
        AttributeChangeEventStrategy targetToModelStrategy = new AttributeChangeEventStrategy(bo, (EStructuralFeature)attr);
        this.context.bindValue((IObservableValue)targetProperty, modelProperty, targetToModelStrategy, null);
        text.setEnabled(!readOnlyAttributes.contains(attr));
    }

    private void createMultiAttributeProperty(EObject bo, Composite comp, EStructuralFeature attr) {
        if (attr instanceof EAttribute) {
            this.createMultiAttributeProperty(bo, comp, (EAttribute)attr);
        } else if (attr instanceof EReference) {
            this.createMultiAttributeProperty(bo, comp, (EReference)attr);
        }
    }

    private void createMultiAttributeProperty(EObject bo, Composite comp, EAttribute attr) {
        Label label = new Label(comp, 0);
        this.setLayoutData((Control)label, false, false, false, false, 1, 3);
        label.setText(String.valueOf(attr.getName()) + ": ");
        Table table = new Table(comp, 67588);
        this.setLayoutData(table);
        TableViewer tableViewer = new TableViewer(table);
        TextCellEditor editor = new TextCellEditor((Composite)table);
        tableViewer.setCellEditors(new CellEditor[]{editor});
        tableViewer.getTable().setEnabled(true);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)CincoPropertyView.getPossibleValuesLabelProvider(bo, (EStructuralFeature)attr));
        IEMFEditListProperty input = EMFEditProperties.list((EditingDomain)this.domain, (EStructuralFeature)attr);
        tableViewer.setInput((Object)input.observe((Object)bo));
        AddAttributeAction addAction = new AddAttributeAction(tableViewer, bo, attr);
        Button addButton = addAction.createButton(comp, 2056);
        this.setLayoutData(addButton);
        EditAttributeAction editAction = new EditAttributeAction(tableViewer, bo, attr);
        Button editButton = editAction.createButton(comp, 2056);
        this.setLayoutData(editButton);
        tableViewer.addDoubleClickListener((IDoubleClickListener)editAction);
        RemoveAttributeAction removeAction = new RemoveAttributeAction(tableViewer, bo, attr);
        Button removeButton = removeAction.createButton(comp, 2056);
        this.setLayoutData(removeButton);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(manager -> {
            manager.add((IAction)addAction);
            manager.add((IAction)editAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)removeAction);
        });
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void createMultiAttributeProperty(EObject bo, Composite comp, EReference ref) {
        Label label = new Label(comp, 0);
        this.setLayoutData((Control)label, false, false, false, false, 1, 3);
        label.setText(String.valueOf(ref.getName()) + ": ");
        Table table = new Table(comp, 67588);
        this.setLayoutData(table);
        TableViewer tableViewer = new TableViewer(table);
        TextCellEditor editor = new TextCellEditor((Composite)table);
        tableViewer.setCellEditors(new CellEditor[]{editor});
        tableViewer.getTable().setEnabled(true);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)CincoPropertyView.getPossibleValuesLabelProvider(bo, (EStructuralFeature)ref));
        IEMFEditListProperty input = EMFEditProperties.list((EditingDomain)this.domain, (EStructuralFeature)ref);
        tableViewer.setInput((Object)input.observe((Object)bo));
        AddReferenceAction addAction = new AddReferenceAction(tableViewer, bo, ref);
        Button addButton = addAction.createButton(comp, 2056);
        this.setLayoutData(addButton);
        EditReferenceAction editAction = new EditReferenceAction(tableViewer, bo, ref);
        Button editButton = editAction.createButton(comp, 2056);
        this.setLayoutData(editButton);
        tableViewer.addDoubleClickListener((IDoubleClickListener)editAction);
        RemoveReferenceAction removeAction = new RemoveReferenceAction(tableViewer, bo, ref);
        Button removeButton = removeAction.createButton(comp, 2056);
        this.setLayoutData(removeButton);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(manager -> {
            manager.add((IAction)addAction);
            manager.add((IAction)editAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)removeAction);
        });
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void disposeChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    public static PossibleValuesLabelProvider getPossibleValuesLabelProvider(EObject bo, EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            PossibleValues<Object> possibleValues = PossibleValues.fromAttribute(bo, attribute, possibleValuesMap.get(attribute));
            return new PossibleValuesLabelProvider(possibleValues);
        }
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            PossibleValues<ModelElement> possibleValues = PossibleValues.fromReference(bo, reference, possibleValuesMap.get(reference));
            return new PossibleValuesLabelProvider(possibleValues);
        }
        throw new IllegalArgumentException("feature is neither EAttribute nor EReference.");
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addSelectionListener((ISelectionListener)this);
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removeSelectionListener((ISelectionListener)this);
    }
}

